#ifndef morpheo_Address
#define morpheo_Address

/*
 * $Id: Address.h 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

namespace morpheo              {

  // get_tag, get_index, get_offset ...............
  template <typename T>
  T get_tag    (T value, uint32_t size_tag, uint32_t size_index, uint32_t size_offset) 
  {
    const T mask = gen_mask<T>(size_tag   ); 
    return (value >> (size_index+size_offset)) & mask;
  }
  
  template <typename T>
  T get_index  (T value, uint32_t size_tag, uint32_t size_index, uint32_t size_offset) 
  {
    const T mask = gen_mask<T>(size_index ); 
    return (value >> (           size_offset)) & mask;
  }
  
  template <typename T>
  T get_offset (T value, uint32_t size_tag, uint32_t size_index, uint32_t size_offset) 
  {
    const T mask = gen_mask<T>(size_offset); 
    return (value                            ) & mask;
  }

}; // end namespace morpheo              

#endif
