#ifndef morpheo_ErrorMorpheo
#define morpheo_ErrorMorpheo

/*
 * $Id: ErrorMorpheo.h 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "ToString.h"
#include <iostream>
#include <exception>

namespace morpheo              {

#define ERRORMORPHEO(funcname,msg) ErrorMorpheo(funcname,msg,__LINE__,__FILE__)

  class ErrorMorpheo : public std::exception 
  {
    // -----[fields ]----------------------------------------------------
  private : std::string _msg;
    
    // -----[methods ]---------------------------------------------------
  public  :             ErrorMorpheo  ()                throw() {_msg="Exception detected ...";}
  public  :             ErrorMorpheo  (std::string msg) throw() {_msg=msg;}
  public  :             ErrorMorpheo  (std::string funcname,
				       std::string msg     ,
				       int         line    ,
				       std::string file    ) throw() 
    { 
      _msg = "<"+funcname+"> at line " + toString(line) + ", in file " + file + " : "+msg;
    }
  public  :             ~ErrorMorpheo (void)       throw() {}
  public  : const char* what          ()    const  throw() { return ( _msg.c_str() );}

  };

  class TestMorpheo : public std::exception 
  {
    // -----[fields ]----------------------------------------------------
  private : std::string _msg;
    
    // -----[methods ]---------------------------------------------------
  public  :             TestMorpheo   ()                throw() {_msg="Test error ...";}
  public  :             TestMorpheo   (std::string msg) throw() {_msg=msg;}
  public  :             ~TestMorpheo  (void)            throw() {}
  public  : const char* what          ()    const       throw() { return ( _msg.c_str() );}
  };

}; // end namespace morpheo              

#endif
