ENTRY(_start)
OUTPUT_ARCH(or32)
/*
__DYNAMIC  =  0;
*/

/*
 * Memory Mapping
 */

MEMORY
{
	iram     : ORIGIN = 0x00000000, LENGTH = 0x01000000
	dram     : ORIGIN = 0x10000000, LENGTH = 0x10000000
	dram_unc : ORIGIN = 0x40000000, LENGTH = 0x01000000
}

/*
 * Allocate the stack to be at the top of memory, since the stack
 * grows down.
 */
PROVIDE (_stack       = 0x52000000 - 4);
PROVIDE (__stack      = 0x52000000 - 4);
PROVIDE (_stack_alloc = 0x00500000    );
SECTIONS
{
   /*
    * Code
    */

   .text : 
	{
		*(.text)
   	} > iram

   /*
    * Data
    */

   .rodata : 
	{
		*(.rodata);
		*(.rodata.*);
	} > dram

   .data : 
	{
		sdata   =  .;
		_sdata  =  .;
		*(.data)
		edata   =  .;
		_edata  =  .;
	} > dram
   .bss SIZEOF(.data) + ADDR(.data) :
	{
		sbss         = . ;
		_sbss        = . ;
		__bss_start  = ALIGN(0x8);
		___bss_start = ALIGN(0x8);
		*(.bss)
		*(COMMON)
		end          = ALIGN(0x8);
		_end         = ALIGN(0x8);
		__end        = ALIGN(0x8);
		ebss         = .;
		_ebss        = .;
	}
/*
    .stab  0 (NOLOAD) : 
        {
                [ .stab ]
        }
        
    .stabstr  0 (NOLOAD) :
        {
                [ .stabstr ]
        }
*/


   /*
    * Suppression de la section comment
    */

   /DISCARD/ :
	{
	*(.comment)
	*(.gnu.*)
	*(.stab*)
	}
}

