/*
 * $Id: Branch_Target_Buffer_Register_deallocation.cpp 82 2008-05-01 16:48:45Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Branch_Target_Buffer/Branch_Target_Buffer_Register/include/Branch_Target_Buffer_Register.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace branch_target_buffer {
namespace branch_target_buffer_register {


#undef  FUNCTION
#define FUNCTION "Branch_Target_Buffer_Register::deallocation"
  void Branch_Target_Buffer_Register::deallocation (void)
  {
    log_printf(FUNC,Branch_Target_Buffer_Register,FUNCTION,"Begin");

    if (_usage & USE_SYSTEMC)
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

	delete []  in_PREDICT_VAL           ;
	delete [] out_PREDICT_ACK           ;
	if (_param->_have_port_context_id)
	delete []  in_PREDICT_CONTEXT_ID    ;
	delete []  in_PREDICT_ADDRESS       ;
	delete [] out_PREDICT_HIT           ;
	delete [] out_PREDICT_ADDRESS_SRC   ;
	delete [] out_PREDICT_ADDRESS_DEST  ;
	delete [] out_PREDICT_CONDITION     ;
	delete [] out_PREDICT_LAST_TAKE     ;
	delete [] out_PREDICT_IS_ACCURATE   ;
	delete []  in_DECOD_VAL             ;
	delete [] out_DECOD_ACK             ;
	delete [] out_DECOD_HIT             ;
	if (_param->_have_port_victim)
	delete [] out_DECOD_HIT_INDEX       ;
	if (_param->_have_port_victim)
	delete []  in_DECOD_VICTIM          ;
	if (_param->_have_port_context_id)
	delete []  in_DECOD_CONTEXT_ID      ;
	delete []  in_DECOD_ADDRESS_SRC     ;
	delete []  in_DECOD_ADDRESS_DEST    ;
	delete []  in_DECOD_CONDITION       ;
	delete []  in_DECOD_LAST_TAKE       ;
	delete []  in_DECOD_MISS_PREDICTION ;
	delete []  in_DECOD_IS_ACCURATE     ;
	delete []  in_UPDATE_VAL            ;
	delete [] out_UPDATE_ACK            ;
	delete [] out_UPDATE_HIT            ;
	if (_param->_have_port_victim)
	delete [] out_UPDATE_HIT_INDEX      ;
	if (_param->_have_port_victim)
	delete []  in_UPDATE_VICTIM         ;
	if (_param->_have_port_context_id)
	delete []  in_UPDATE_CONTEXT_ID     ;
	delete []  in_UPDATE_ADDRESS_SRC    ;
	delete []  in_UPDATE_ADDRESS_DEST   ;
	delete []  in_UPDATE_CONDITION      ;
	delete []  in_UPDATE_LAST_TAKE      ;
	delete []  in_UPDATE_MISS_PREDICTION;

	delete [] reg_BTB;

	delete [] internal_DECOD_ACK       ;
	delete [] internal_DECOD_HIT       ;
	delete [] internal_DECOD_NUM_BANK  ;
	delete [] internal_DECOD_NUM_ENTRY ;

	delete [] internal_UPDATE_ACK      ;
	delete [] internal_UPDATE_HIT      ;
	delete [] internal_UPDATE_NUM_BANK ;
	delete [] internal_UPDATE_NUM_ENTRY;
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    delete _component;

    log_printf(FUNC,Branch_Target_Buffer_Register,FUNCTION,"End");
  };

}; // end namespace branch_target_buffer_register
}; // end namespace branch_target_buffer
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
