#ifdef SYSTEMC
/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Update_Prediction_Table/include/Update_Prediction_Table.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace update_prediction_table {


#undef  FUNCTION
#define FUNCTION "Update_Prediction_Table::genMealy_decod"
  void Update_Prediction_Table::genMealy_decod (void)
  {
    log_printf(FUNC,Update_Prediction_Table,FUNCTION,"Begin");
    
    for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
      {
	Tcontrol_t miss = PORT_READ(in_DECOD_MISS_DECOD [i]);

	if (miss)
	  {
	    // miss : need a empty slot.
	    Tcontext_t context = (_param->_have_port_context_id)?PORT_READ(in_DECOD_CONTEXT_ID [i]):0;
	    uint32_t   top     = reg_TOP[context];
	    internal_DECOD_ACK [i] = (reg_UPDATE_PREDICTION_TABLE [context][top]._state == UPDATE_PREDICTION_STATE_EMPTY);
	  }
	else
	  {
	    internal_DECOD_ACK [i] = true;
	  }

	PORT_WRITE(out_DECOD_ACK [i], internal_DECOD_ACK [i]);
      }

    log_printf(FUNC,Update_Prediction_Table,FUNCTION,"End");
  };

}; // end namespace update_prediction_table
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
