/*
 * $Id: test2.cpp 82 2008-05-01 16:48:45Z rosiere $
 *
 * [Description ]
 * 
 * Test
 */

#include <queue>
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Load_store_unit/SelfTest/include/test.h"

//===================================================================={test}
void test2 (void)
{
  std::string name = "Test_Load_store_queue_manual";

  cout << "<" << name << "> : Simulation SystemC" << endl;


  morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::load_store_unit::Parameters * _param = new morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::load_store_unit::Parameters
	(
	 4,  //_size_store_queue       
	 4,  //_size_load_queue        
	 2,  //_size_speculative_access_queue
	 2,  //_nb_port_check          
	 SPECULATIVE_LOAD_COMMIT,  //_speculative_load       
	 0,  //_nb_bypass_memory
	 1,  //_nb_context             
	 1,  //_nb_front_end           
	 2,  //_nb_ooo_engine          
	 128,//_nb_packet              
	 32, //_size_general_data      
	 2 , //_size_special_data      
	 64, //_nb_general_register    
	 16  //_nb_special_register    
        );

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,0);
#endif

  Load_store_unit * _Load_store_unit = new Load_store_unit (name.c_str(),
#ifdef STATISTICS
							    _parameters_statistics,
#endif
							    _param,
							    USE_ALL);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename = "";

  sc_clock                               * in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);
  sc_signal<Tcontrol_t>                  * in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  sc_signal<Tcontrol_t        > *   in_MEMORY_IN_VAL                   = new sc_signal<Tcontrol_t        > (rename.c_str());
  sc_signal<Tcontrol_t        > *  out_MEMORY_IN_ACK                   = new sc_signal<Tcontrol_t        > (rename.c_str());
  sc_signal<Tcontext_t        > *   in_MEMORY_IN_CONTEXT_ID            = new sc_signal<Tcontext_t        > (rename.c_str());
  sc_signal<Tcontext_t        > *   in_MEMORY_IN_FRONT_END_ID          = new sc_signal<Tcontext_t        > (rename.c_str());
  sc_signal<Tcontext_t        > *   in_MEMORY_IN_OOO_ENGINE_ID         = new sc_signal<Tcontext_t        > (rename.c_str());
  sc_signal<Tpacket_t         > *   in_MEMORY_IN_PACKET_ID             = new sc_signal<Tpacket_t         > (rename.c_str());
  sc_signal<Toperation_t      > *   in_MEMORY_IN_OPERATION             = new sc_signal<Toperation_t      > (rename.c_str());
  sc_signal<Ttype_t           > *   in_MEMORY_IN_TYPE                  = new sc_signal<Ttype_t           > (rename.c_str());
  sc_signal<Tlsq_ptr_t        > *   in_MEMORY_IN_STORE_QUEUE_PTR_WRITE = new sc_signal<Tlsq_ptr_t        > (rename.c_str());
  sc_signal<Tlsq_ptr_t        > *   in_MEMORY_IN_LOAD_QUEUE_PTR_WRITE  = new sc_signal<Tlsq_ptr_t        > (rename.c_str());
  sc_signal<Tcontrol_t        > *   in_MEMORY_IN_HAS_IMMEDIAT          = new sc_signal<Tcontrol_t        > (rename.c_str());
  sc_signal<Tgeneral_data_t   > *   in_MEMORY_IN_IMMEDIAT              = new sc_signal<Tgeneral_data_t   > (rename.c_str());
  sc_signal<Tgeneral_data_t   > *   in_MEMORY_IN_DATA_RA               = new sc_signal<Tgeneral_data_t   > (rename.c_str());
  sc_signal<Tgeneral_data_t   > *   in_MEMORY_IN_DATA_RB               = new sc_signal<Tgeneral_data_t   > (rename.c_str());
  sc_signal<Tspecial_data_t   > *   in_MEMORY_IN_DATA_RC               = new sc_signal<Tspecial_data_t   > (rename.c_str());
  sc_signal<Tcontrol_t        > *   in_MEMORY_IN_WRITE_RD              = new sc_signal<Tcontrol_t        > (rename.c_str());
  sc_signal<Tgeneral_address_t> *   in_MEMORY_IN_NUM_REG_RD            = new sc_signal<Tgeneral_address_t> (rename.c_str());
  sc_signal<Tcontrol_t        > *   in_MEMORY_IN_WRITE_RE              = new sc_signal<Tcontrol_t        > (rename.c_str());
  sc_signal<Tspecial_address_t> *   in_MEMORY_IN_NUM_REG_RE            = new sc_signal<Tspecial_address_t> (rename.c_str());

  sc_signal<Tcontrol_t	      > *  out_MEMORY_OUT_VAL           = new sc_signal<Tcontrol_t	  >(rename.c_str());
  sc_signal<Tcontrol_t	      > *   in_MEMORY_OUT_ACK           = new sc_signal<Tcontrol_t	  >(rename.c_str());
  sc_signal<Tcontext_t        > *  out_MEMORY_OUT_CONTEXT_ID    = new sc_signal<Tcontext_t        >(rename.c_str());
  sc_signal<Tcontext_t        > *  out_MEMORY_OUT_FRONT_END_ID  = new sc_signal<Tcontext_t        >(rename.c_str());
  sc_signal<Tcontext_t        > *  out_MEMORY_OUT_OOO_ENGINE_ID = new sc_signal<Tcontext_t        >(rename.c_str());
  sc_signal<Tpacket_t         > *  out_MEMORY_OUT_PACKET_ID     = new sc_signal<Tpacket_t         >(rename.c_str());
//   sc_signal<Toperation_t      > *  out_MEMORY_OUT_OPERATION     = new sc_signal<Toperation_t      >(rename.c_str());
  sc_signal<Ttype_t           > *  out_MEMORY_OUT_TYPE          = new sc_signal<Ttype_t           >(rename.c_str());
  sc_signal<Tcontrol_t        > *  out_MEMORY_OUT_WRITE_RD      = new sc_signal<Tcontrol_t        >(rename.c_str());
  sc_signal<Tgeneral_address_t> *  out_MEMORY_OUT_NUM_REG_RD    = new sc_signal<Tgeneral_address_t>(rename.c_str());
  sc_signal<Tgeneral_data_t   > *  out_MEMORY_OUT_DATA_RD       = new sc_signal<Tgeneral_data_t   >(rename.c_str());
  sc_signal<Tcontrol_t        > *  out_MEMORY_OUT_WRITE_RE      = new sc_signal<Tcontrol_t        >(rename.c_str());
  sc_signal<Tspecial_address_t> *  out_MEMORY_OUT_NUM_REG_RE    = new sc_signal<Tspecial_address_t>(rename.c_str());
  sc_signal<Tspecial_data_t   > *  out_MEMORY_OUT_DATA_RE       = new sc_signal<Tspecial_data_t   >(rename.c_str());
  sc_signal<Texception_t      > *  out_MEMORY_OUT_EXCEPTION     = new sc_signal<Texception_t      >(rename.c_str());
  sc_signal<Tcontrol_t        > *  out_MEMORY_OUT_NO_SEQUENCE   = new sc_signal<Tcontrol_t        >(rename.c_str());
  sc_signal<Tgeneral_data_t   > *  out_MEMORY_OUT_ADDRESS       = new sc_signal<Tgeneral_data_t   >(rename.c_str());

  sc_signal<Tcontrol_t        > * out_DCACHE_REQ_VAL        = new sc_signal<Tcontrol_t        >(rename.c_str());
  sc_signal<Tcontrol_t        > *  in_DCACHE_REQ_ACK        = new sc_signal<Tcontrol_t        >(rename.c_str());
  sc_signal<Tcontext_t        > * out_DCACHE_REQ_CONTEXT_ID = new sc_signal<Tcontext_t        >(rename.c_str());
  sc_signal<Tpacket_t         > * out_DCACHE_REQ_PACKET_ID  = new sc_signal<Tpacket_t         >(rename.c_str());
  sc_signal<Tdcache_address_t > * out_DCACHE_REQ_ADDRESS    = new sc_signal<Tdcache_address_t >(rename.c_str());
  sc_signal<Tdcache_type_t    > * out_DCACHE_REQ_TYPE       = new sc_signal<Tdcache_type_t    >(rename.c_str());
  sc_signal<Tdcache_data_t    > * out_DCACHE_REQ_WDATA      = new sc_signal<Tdcache_data_t    >(rename.c_str());
  
  sc_signal<Tcontrol_t        > *  in_DCACHE_RSP_VAL        = new sc_signal<Tcontrol_t        >(rename.c_str());
  sc_signal<Tcontrol_t        > * out_DCACHE_RSP_ACK        = new sc_signal<Tcontrol_t        >(rename.c_str());
  sc_signal<Tcontext_t        > *  in_DCACHE_RSP_CONTEXT_ID = new sc_signal<Tcontext_t        >(rename.c_str());
  sc_signal<Tpacket_t         > *  in_DCACHE_RSP_PACKET_ID  = new sc_signal<Tpacket_t         >(rename.c_str());
  sc_signal<Tdcache_data_t    > *  in_DCACHE_RSP_RDATA      = new sc_signal<Tdcache_data_t    >(rename.c_str());
  sc_signal<Tdcache_error_t   > *  in_DCACHE_RSP_ERROR      = new sc_signal<Tdcache_error_t   >(rename.c_str());
  
  sc_signal<Tcontrol_t        > ** out_BYPASS_MEMORY_VAL           = new sc_signal<Tcontrol_t        > * [_param->_nb_bypass_memory];
  sc_signal<Tcontext_t        > ** out_BYPASS_MEMORY_OOO_ENGINE_ID = new sc_signal<Tcontext_t        > * [_param->_nb_bypass_memory];
  sc_signal<Tgeneral_address_t> ** out_BYPASS_MEMORY_NUM_REG       = new sc_signal<Tgeneral_address_t> * [_param->_nb_bypass_memory];
  sc_signal<Tgeneral_data_t   > ** out_BYPASS_MEMORY_DATA          = new sc_signal<Tgeneral_data_t   > * [_param->_nb_bypass_memory];
    
  for (uint32_t i=0; i<_param->_nb_bypass_memory; i++)
    {
      out_BYPASS_MEMORY_VAL           [i] = new sc_signal<Tcontrol_t        >(rename.c_str());
      out_BYPASS_MEMORY_OOO_ENGINE_ID [i] = new sc_signal<Tcontext_t        >(rename.c_str());
      out_BYPASS_MEMORY_NUM_REG       [i] = new sc_signal<Tgeneral_address_t>(rename.c_str());
      out_BYPASS_MEMORY_DATA          [i] = new sc_signal<Tgeneral_data_t   >(rename.c_str());
    }
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  cout << "<" << name << "> Instanciation of _Load_store_unit" << endl;
  
  (*(_Load_store_unit->in_CLOCK))        (*(in_CLOCK));
  (*(_Load_store_unit->in_NRESET))       (*(in_NRESET));

  (*(_Load_store_unit-> in_MEMORY_IN_VAL                  ))(*( in_MEMORY_IN_VAL                  ));
  (*(_Load_store_unit->out_MEMORY_IN_ACK                  ))(*(out_MEMORY_IN_ACK                  ));
  if (_param->_have_port_context_id)
    (*(_Load_store_unit-> in_MEMORY_IN_CONTEXT_ID           ))(*( in_MEMORY_IN_CONTEXT_ID           ));
  if (_param->_have_port_front_end_id)
    (*(_Load_store_unit-> in_MEMORY_IN_FRONT_END_ID         ))(*( in_MEMORY_IN_FRONT_END_ID         ));
  if (_param->_have_port_ooo_engine_id)
    (*(_Load_store_unit-> in_MEMORY_IN_OOO_ENGINE_ID        ))(*( in_MEMORY_IN_OOO_ENGINE_ID        ));
  if (_param->_have_port_packet_id)
    (*(_Load_store_unit-> in_MEMORY_IN_PACKET_ID            ))(*( in_MEMORY_IN_PACKET_ID            ));
  (*(_Load_store_unit-> in_MEMORY_IN_OPERATION            ))(*( in_MEMORY_IN_OPERATION            ));
  (*(_Load_store_unit-> in_MEMORY_IN_TYPE                 ))(*( in_MEMORY_IN_TYPE                 ));
  (*(_Load_store_unit-> in_MEMORY_IN_STORE_QUEUE_PTR_WRITE))(*( in_MEMORY_IN_STORE_QUEUE_PTR_WRITE));
  if (_param->_have_port_load_queue_ptr)
  (*(_Load_store_unit-> in_MEMORY_IN_LOAD_QUEUE_PTR_WRITE ))(*( in_MEMORY_IN_LOAD_QUEUE_PTR_WRITE ));
  (*(_Load_store_unit-> in_MEMORY_IN_HAS_IMMEDIAT         ))(*( in_MEMORY_IN_HAS_IMMEDIAT         ));
  (*(_Load_store_unit-> in_MEMORY_IN_IMMEDIAT             ))(*( in_MEMORY_IN_IMMEDIAT             ));
  (*(_Load_store_unit-> in_MEMORY_IN_DATA_RA              ))(*( in_MEMORY_IN_DATA_RA              ));
  (*(_Load_store_unit-> in_MEMORY_IN_DATA_RB              ))(*( in_MEMORY_IN_DATA_RB              ));
  (*(_Load_store_unit-> in_MEMORY_IN_DATA_RC              ))(*( in_MEMORY_IN_DATA_RC              ));
  (*(_Load_store_unit-> in_MEMORY_IN_WRITE_RD             ))(*( in_MEMORY_IN_WRITE_RD             ));
  (*(_Load_store_unit-> in_MEMORY_IN_NUM_REG_RD           ))(*( in_MEMORY_IN_NUM_REG_RD           ));
  (*(_Load_store_unit-> in_MEMORY_IN_WRITE_RE             ))(*( in_MEMORY_IN_WRITE_RE             ));
  (*(_Load_store_unit-> in_MEMORY_IN_NUM_REG_RE           ))(*( in_MEMORY_IN_NUM_REG_RE           ));
  
  (*(_Load_store_unit->out_MEMORY_OUT_VAL           ))(*(out_MEMORY_OUT_VAL           ));
  (*(_Load_store_unit-> in_MEMORY_OUT_ACK           ))(*( in_MEMORY_OUT_ACK           ));
  if (_param->_have_port_context_id)
    (*(_Load_store_unit->out_MEMORY_OUT_CONTEXT_ID    ))(*(out_MEMORY_OUT_CONTEXT_ID    ));
  if (_param->_have_port_front_end_id)
    (*(_Load_store_unit->out_MEMORY_OUT_FRONT_END_ID  ))(*(out_MEMORY_OUT_FRONT_END_ID  ));
  if (_param->_have_port_ooo_engine_id)
    (*(_Load_store_unit->out_MEMORY_OUT_OOO_ENGINE_ID ))(*(out_MEMORY_OUT_OOO_ENGINE_ID ));
  if (_param->_have_port_packet_id)
    (*(_Load_store_unit->out_MEMORY_OUT_PACKET_ID     ))(*(out_MEMORY_OUT_PACKET_ID     ));
//   (*(_Load_store_unit->out_MEMORY_OUT_OPERATION     ))(*(out_MEMORY_OUT_OPERATION     ));
  (*(_Load_store_unit->out_MEMORY_OUT_TYPE          ))(*(out_MEMORY_OUT_TYPE          ));
  (*(_Load_store_unit->out_MEMORY_OUT_WRITE_RD      ))(*(out_MEMORY_OUT_WRITE_RD      ));
  (*(_Load_store_unit->out_MEMORY_OUT_NUM_REG_RD    ))(*(out_MEMORY_OUT_NUM_REG_RD    ));
  (*(_Load_store_unit->out_MEMORY_OUT_DATA_RD       ))(*(out_MEMORY_OUT_DATA_RD       ));
  (*(_Load_store_unit->out_MEMORY_OUT_WRITE_RE      ))(*(out_MEMORY_OUT_WRITE_RE      ));
  (*(_Load_store_unit->out_MEMORY_OUT_NUM_REG_RE    ))(*(out_MEMORY_OUT_NUM_REG_RE    ));
  (*(_Load_store_unit->out_MEMORY_OUT_DATA_RE       ))(*(out_MEMORY_OUT_DATA_RE       ));
  (*(_Load_store_unit->out_MEMORY_OUT_EXCEPTION     ))(*(out_MEMORY_OUT_EXCEPTION     ));
  (*(_Load_store_unit->out_MEMORY_OUT_NO_SEQUENCE   ))(*(out_MEMORY_OUT_NO_SEQUENCE   ));
  (*(_Load_store_unit->out_MEMORY_OUT_ADDRESS       ))(*(out_MEMORY_OUT_ADDRESS       ));

  (*(_Load_store_unit->out_DCACHE_REQ_VAL       ))(*(out_DCACHE_REQ_VAL       ));
  (*(_Load_store_unit-> in_DCACHE_REQ_ACK       ))(*( in_DCACHE_REQ_ACK       ));
  if (_param->_have_port_dcache_context_id)
    (*(_Load_store_unit->out_DCACHE_REQ_CONTEXT_ID))(*(out_DCACHE_REQ_CONTEXT_ID));
  (*(_Load_store_unit->out_DCACHE_REQ_PACKET_ID ))(*(out_DCACHE_REQ_PACKET_ID ));
  (*(_Load_store_unit->out_DCACHE_REQ_ADDRESS   ))(*(out_DCACHE_REQ_ADDRESS   ));
  (*(_Load_store_unit->out_DCACHE_REQ_TYPE      ))(*(out_DCACHE_REQ_TYPE      ));
  (*(_Load_store_unit->out_DCACHE_REQ_WDATA     ))(*(out_DCACHE_REQ_WDATA     ));

  (*(_Load_store_unit-> in_DCACHE_RSP_VAL       ))(*( in_DCACHE_RSP_VAL       ));
  (*(_Load_store_unit->out_DCACHE_RSP_ACK       ))(*(out_DCACHE_RSP_ACK       ));
  if (_param->_have_port_dcache_context_id)
    (*(_Load_store_unit-> in_DCACHE_RSP_CONTEXT_ID))(*( in_DCACHE_RSP_CONTEXT_ID));
  (*(_Load_store_unit-> in_DCACHE_RSP_PACKET_ID ))(*( in_DCACHE_RSP_PACKET_ID ));
  (*(_Load_store_unit-> in_DCACHE_RSP_RDATA     ))(*( in_DCACHE_RSP_RDATA     ));
  (*(_Load_store_unit-> in_DCACHE_RSP_ERROR     ))(*( in_DCACHE_RSP_ERROR     ));

    {
      for (uint32_t i=0; i<_param->_nb_bypass_memory; i++)
	{
	  (*(_Load_store_unit->out_BYPASS_MEMORY_VAL           [i]))(*(out_BYPASS_MEMORY_VAL           [i]));
	  if (_param->_have_port_ooo_engine_id)    
	    (*(_Load_store_unit->out_BYPASS_MEMORY_OOO_ENGINE_ID [i]))(*(out_BYPASS_MEMORY_OOO_ENGINE_ID [i]));
	  (*(_Load_store_unit->out_BYPASS_MEMORY_NUM_REG       [i]))(*(out_BYPASS_MEMORY_NUM_REG       [i]));
	  (*(_Load_store_unit->out_BYPASS_MEMORY_DATA          [i]))(*(out_BYPASS_MEMORY_DATA          [i]));
	}
    }
  cout << "<" << name << "> Start Simulation ............" << endl;
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
  //const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  const int32_t      percent_transaction_memory_out = 100;
  const int32_t      percent_transaction_dcache     = 100;
  const uint32_t     miss_rate                      =   0;
  const uint32_t     miss_penality                  =   0;

  uint32_t           nb_request_memory_out=0;

  MemoryRequest_t                 tab_request  [_param->_nb_packet];
  priority_queue<MemoryRequest_t> fifo_request;

  const uint32_t     size_memory = 0x100;
  // emulation of memory
  Memory_t                      * _memory = new Memory_t (1<<_param->_size_dcache_context_id, size_memory, _param->_size_general_data);
  Cache_t                       * _cache  = new Cache_t  (miss_rate, miss_penality);

  SC_START(0);

  LABEL("Initialisation");

  in_MEMORY_IN_VAL ->write(0);
  in_MEMORY_OUT_ACK->write(0);
  in_DCACHE_REQ_ACK->write(0);
  in_DCACHE_RSP_VAL->write(0);

  in_NRESET        ->write(0);
  SC_START(5);
  in_NRESET        ->write(5);

  LABEL("Loop of Test");

  try 
    {
	  LABEL("Structure's initialisation");

	  bool               store_queue_use [_param->_size_store_queue];
	  uint32_t           nb_store_slot_use = 0;
	  bool               load_queue_use  [_param->_size_load_queue ];

	  for (uint32_t i=0; i<_param->_size_store_queue; i++)
	    store_queue_use [i] = false;
	  for (uint32_t i=0; i<_param->_size_load_queue ; i++)
	    load_queue_use  [i] = false;

	  
	  //--------------------------------------------------------------------------------------------------------------
	  //                    c  c f o p  o                              t           s l i     d     d          w n w 
	  //                    y  o r o a  p                              y           t o m     a     a          r u r 
	  //                    c  n o o c  e                              p           o a m     t     t          i m i 
	  //                    l  t n _ k  r                              e           r d e     a     a          t _ t 
	  //                    e  e t e e  a                                          e _ d     _     _          e r e  
	  //                       x _ n t  t                                          _ p i     r     r          _ _ _
	  //                       t e g _  i                                          p t a     a     b          r g s
	  //                       _ n i i  o                                          t r t                      d _ p 
	  //                       i d n d  n                                          r _                          r e 
	  //                       d _ e                                               _ w                          d c 
	  //                         i _                                               w r                            _ 
	  //                         d i                                               r i                            k 
	  //                           d                                               i t                            o 
	  //                                                                           t e                              
	  //                                                                           e                               
	  //                                                                                                        
	  tab_request[ 0].modif( 5,0,0,0, 0,OPERATION_MEMORY_STORE_32     ,TYPE_MEMORY,0,0,0x0  ,0x10 ,0xdead1234,0,0,0);

	  tab_request[ 1].modif(10,0,0,0, 0,OPERATION_MEMORY_STORE_HEAD_OK,TYPE_MEMORY,0,0,0x0  ,0x0  ,0x0       ,0,0,0);

	  // READ 32b 
	  tab_request[ 2].modif(12,0,0,0, 2,OPERATION_MEMORY_LOAD_32_Z    ,TYPE_MEMORY,1,0,0x10 ,0x0  ,0x0       ,1,1,0,0xdead1234);
	  tab_request[ 3].modif(13,0,0,0, 3,OPERATION_MEMORY_LOAD_32_S    ,TYPE_MEMORY,1,1,0x10 ,0x0  ,0x0       ,1,2,0,0xdead1234);

	  // READ 16b 
	  tab_request[ 4].modif(14,0,0,0, 4,OPERATION_MEMORY_LOAD_16_Z    ,TYPE_MEMORY,1,2,0x10 ,0x0  ,0x0       ,1,3,0,0x00001234);
	  tab_request[ 5].modif(15,0,0,0, 5,OPERATION_MEMORY_LOAD_16_Z    ,TYPE_MEMORY,1,3,0x12 ,0x0  ,0x0       ,1,4,0,0x0000dead);
	  tab_request[ 6].modif(16,0,0,0, 6,OPERATION_MEMORY_LOAD_16_S    ,TYPE_MEMORY,1,0,0x10 ,0x0  ,0x0       ,1,5,0,0x00001234);
	  tab_request[ 7].modif(17,0,0,0, 7,OPERATION_MEMORY_LOAD_16_S    ,TYPE_MEMORY,1,1,0x12 ,0x0  ,0x0       ,1,6,0,0xffffdead);

	  // READ  8b 
	  tab_request[ 8].modif(18,0,0,0, 8,OPERATION_MEMORY_LOAD_8_Z     ,TYPE_MEMORY,1,0,0x10 ,0x0  ,0x0       ,1,7,0,0x00000034);
	  tab_request[ 9].modif(19,0,0,0, 9,OPERATION_MEMORY_LOAD_8_Z     ,TYPE_MEMORY,1,1,0x11 ,0x0  ,0x0       ,1,8,0,0x00000012);
	  tab_request[10].modif(20,0,0,0,10,OPERATION_MEMORY_LOAD_8_Z     ,TYPE_MEMORY,1,2,0x12 ,0x0  ,0x0       ,1,9,0,0x000000ad);
	  tab_request[11].modif(21,0,0,0,11,OPERATION_MEMORY_LOAD_8_Z     ,TYPE_MEMORY,1,3,0x13 ,0x0  ,0x0       ,1,1,0,0x000000de);
	  tab_request[12].modif(22,0,0,0,12,OPERATION_MEMORY_LOAD_8_S     ,TYPE_MEMORY,1,0,0x10 ,0x0  ,0x0       ,1,2,0,0x00000034);
	  tab_request[13].modif(23,0,0,0,13,OPERATION_MEMORY_LOAD_8_S     ,TYPE_MEMORY,1,1,0x11 ,0x0  ,0x0       ,1,3,0,0x00000012);
	  tab_request[14].modif(24,0,0,0,14,OPERATION_MEMORY_LOAD_8_S     ,TYPE_MEMORY,1,2,0x12 ,0x0  ,0x0       ,1,4,0,0xffffffad);
	  tab_request[15].modif(25,0,0,0,15,OPERATION_MEMORY_LOAD_8_S     ,TYPE_MEMORY,1,3,0x13 ,0x0  ,0x0       ,1,5,0,0xffffffde);

	  // STORE 16b
	  tab_request[16].modif(30,0,0,0,16,OPERATION_MEMORY_STORE_16     ,TYPE_MEMORY,1,0,0x20 ,0x0  ,0xffffabcd,0,0,0);
	  tab_request[17].modif(31,0,0,0,17,OPERATION_MEMORY_STORE_16     ,TYPE_MEMORY,2,0,0x22 ,0x0  ,0xffffdcba,0,0,0);
	  tab_request[18].modif(35,0,0,0,18,OPERATION_MEMORY_STORE_HEAD_OK,TYPE_MEMORY,1,0,0x0  ,0x0  ,0x0       ,0,0,0);
	  tab_request[19].modif(36,0,0,0,19,OPERATION_MEMORY_STORE_HEAD_OK,TYPE_MEMORY,2,0,0x0  ,0x0  ,0x0       ,0,0,0);
	  tab_request[20].modif(40,0,0,0,20,OPERATION_MEMORY_LOAD_32_Z    ,TYPE_MEMORY,3,0,0x20 ,0x0  ,0x0       ,1,0,0,0xdcbaabcd);

	  // STORE  8b and head / valid out order
	  tab_request[21].modif(50,0,0,0,21,OPERATION_MEMORY_STORE_8      ,TYPE_MEMORY,3,0,0x1  ,0x4  ,0xffffff56,0,0,0);
	  tab_request[22].modif(55,0,0,0,22,OPERATION_MEMORY_STORE_HEAD_OK,TYPE_MEMORY,3,0,0x1  ,0x0  ,0x0       ,0,0,0);
	  tab_request[23].modif(48,0,0,0,23,OPERATION_MEMORY_STORE_8      ,TYPE_MEMORY,0,0,0x0  ,0x4  ,0xffffff78,0,0,0);
	  tab_request[24].modif(43,0,0,0,24,OPERATION_MEMORY_STORE_HEAD_OK,TYPE_MEMORY,0,0,0x0  ,0x0  ,0x0       ,0,0,0);
	  tab_request[25].modif(47,0,0,0,25,OPERATION_MEMORY_STORE_8      ,TYPE_MEMORY,1,0,0x3  ,0x4  ,0xffffff12,0,0,0);
	  tab_request[26].modif(49,0,0,0,26,OPERATION_MEMORY_STORE_HEAD_OK,TYPE_MEMORY,1,0,0x0  ,0x0  ,0x0       ,0,0,0);
	  tab_request[27].modif(57,0,0,0,27,OPERATION_MEMORY_STORE_8      ,TYPE_MEMORY,2,0,0x2  ,0x4  ,0xffffff34,0,0,0);
	  tab_request[28].modif(44,0,0,0,28,OPERATION_MEMORY_STORE_HEAD_OK,TYPE_MEMORY,2,0,0x0  ,0x0  ,0x0       ,0,0,0);
	  tab_request[29].modif(70,0,0,0,29,OPERATION_MEMORY_LOAD_32_Z    ,TYPE_MEMORY,3,1,0x2  ,0x2  ,0x0       ,1,0,0,0x12345678);

	  // CHECK - with a store not present, store format is >=
	  tab_request[30].modif(180,0,0,0,30,OPERATION_MEMORY_STORE_32     ,TYPE_MEMORY,3,0,0x0  ,0x30 ,0x21071981,0,0,0);
	  tab_request[31].modif(179,0,0,0,31,OPERATION_MEMORY_STORE_HEAD_OK,TYPE_MEMORY,3,0,0x0  ,0x0  ,0x0       ,0,0,0);
	  tab_request[32].modif(173,0,0,0,32,OPERATION_MEMORY_LOAD_32_Z    ,TYPE_MEMORY,0,2,0x0  ,0x30 ,0x0       ,1,0,0,0x21071981);
	  tab_request[33].modif(174,0,0,0,33,OPERATION_MEMORY_LOAD_16_Z    ,TYPE_MEMORY,0,3,0x0  ,0x30 ,0x0       ,1,0,0,0x00001981);
	  tab_request[34].modif(175,0,0,0,34,OPERATION_MEMORY_LOAD_16_Z    ,TYPE_MEMORY,0,0,0x0  ,0x32 ,0x0       ,1,0,0,0x00002107);
	  tab_request[35].modif(176,0,0,0,35,OPERATION_MEMORY_LOAD_8_S     ,TYPE_MEMORY,0,1,0x0  ,0x31 ,0x0       ,1,0,0,0x00000019);

	  // CHECK - with a store not present, multiple store and format is different
	  tab_request[36].modif(200,0,0,0,36,OPERATION_MEMORY_STORE_32     ,TYPE_MEMORY,0,0,0x0  ,0x40 ,0xffffffff,0,0,0);
	  tab_request[37].modif(200,0,0,0,37,OPERATION_MEMORY_STORE_HEAD_OK,TYPE_MEMORY,0,0,0x0  ,0x0  ,0x0       ,0,0,0);
	  tab_request[38].modif(220,0,0,0,38,OPERATION_MEMORY_STORE_16     ,TYPE_MEMORY,1,0,0x0  ,0x42 ,0xbaba    ,0,0,0);
	  tab_request[39].modif(245,0,0,0,39,OPERATION_MEMORY_STORE_HEAD_OK,TYPE_MEMORY,1,0,0x0  ,0x0  ,0x0       ,0,0,0);
	  tab_request[40].modif(224,0,0,0,40,OPERATION_MEMORY_STORE_8      ,TYPE_MEMORY,2,0,0x0  ,0x42 ,0xbe      ,0,0,0);
	  tab_request[41].modif(240,0,0,0,41,OPERATION_MEMORY_STORE_HEAD_OK,TYPE_MEMORY,2,0,0x0  ,0x0  ,0x0       ,0,0,0);
	  tab_request[42].modif(228,0,0,0,42,OPERATION_MEMORY_STORE_16     ,TYPE_MEMORY,3,0,0x0  ,0x40 ,0xf00d    ,0,0,0);
	  tab_request[43].modif(235,0,0,0,43,OPERATION_MEMORY_STORE_HEAD_OK,TYPE_MEMORY,3,0,0x0  ,0x0  ,0x0       ,0,0,0);
	  tab_request[44].modif(210,0,0,0,44,OPERATION_MEMORY_LOAD_32_Z    ,TYPE_MEMORY,0,2,0x0  ,0x40 ,0x0       ,1,0,0,0xbabef00d);
	  tab_request[45].modif(211,0,0,0,45,OPERATION_MEMORY_LOAD_32_Z    ,TYPE_MEMORY,2,3,0x0  ,0x40 ,0x0       ,1,0,0,0xbabaffff);
	  tab_request[46].modif(212,0,0,0,46,OPERATION_MEMORY_LOAD_32_Z    ,TYPE_MEMORY,3,0,0x0  ,0x40 ,0x0       ,1,0,0,0xbabeffff);
	  tab_request[47].modif(213,0,0,0,47,OPERATION_MEMORY_LOAD_8_S     ,TYPE_MEMORY,3,1,0x0  ,0x42 ,0x0       ,1,0,0,0xffffffbe);


	  // CHECK - with different ooo_engine_id
	  tab_request[48].modif(300,0,0,0,48,OPERATION_MEMORY_STORE_32     ,TYPE_MEMORY,0,0,0x0  ,0x0  ,0xdad1900d,0,0,0);
	  tab_request[49].modif(300,0,0,0,49,OPERATION_MEMORY_STORE_HEAD_OK,TYPE_MEMORY,0,0,0x0  ,0x0  ,0x0       ,0,0,0);
	  tab_request[50].modif(300,0,0,1,50,OPERATION_MEMORY_STORE_32     ,TYPE_MEMORY,1,0,0x0  ,0x0  ,0x55508570,0,0,0);
	  tab_request[51].modif(300,0,0,1,51,OPERATION_MEMORY_STORE_HEAD_OK,TYPE_MEMORY,1,0,0x0  ,0x0  ,0x0       ,0,0,0);


	  tab_request[52].modif(320,0,0,0,52,OPERATION_MEMORY_LOAD_16_S    ,TYPE_MEMORY,2,2,0x0  ,0x2  ,0x0       ,1,0,0,0xffffdad1);
	  tab_request[53].modif(321,0,0,1,53,OPERATION_MEMORY_LOAD_16_S    ,TYPE_MEMORY,2,3,0x0  ,0x0  ,0x0       ,1,0,0,0xffff8570);


	  // with a little exception
	  tab_request[54].modif(330,0,0,1,54,OPERATION_MEMORY_STORE_16     ,TYPE_MEMORY,2,0,0x0  ,0x0  ,0xffff6996,0,0,1);
	  tab_request[55].modif(340,0,0,1,55,OPERATION_MEMORY_STORE_HEAD_KO,TYPE_MEMORY,2,0,0x0  ,0x0  ,0x0       ,0,0,0);
	  tab_request[56].modif(322,0,0,1,56,OPERATION_MEMORY_LOAD_8_Z     ,TYPE_MEMORY,3,0,0x0  ,0x1  ,0x0       ,1,0,0,0x00000069); // they are a bypass (because, the cpu go in exception handler ... load is not use)
	  tab_request[57].modif(350,0,0,1,57,OPERATION_MEMORY_LOAD_32_Z    ,TYPE_MEMORY,3,1,0x0  ,0x0  ,0x0       ,1,0,0,0x55508570); // the memory have not change


	  // multiple event
	  //   * store : miss_spec and aligment, priority : miss_spec > aligment
	  //   * load  : miss_spec and aligment, priority : miss_spec > aligment
	  tab_request[58].modif(410,0,0,0,58,OPERATION_MEMORY_STORE_32     ,TYPE_MEMORY,3,0,0x0  ,0x1  ,0x0       ,0,0,1);
	  tab_request[59].modif(415,0,0,0,59,OPERATION_MEMORY_STORE_HEAD_KO,TYPE_MEMORY,3,0,0x0  ,0x0  ,0x0       ,0,0,0);

	  tab_request[60].modif(430,0,0,0,60,OPERATION_MEMORY_LOAD_32_Z    ,TYPE_MEMORY,0,2,0x0  ,0x0  ,0x0       ,1,0,0,0xdad1900d);
	  tab_request[61].modif(400,0,0,0,61,OPERATION_MEMORY_LOAD_32_Z    ,TYPE_MEMORY,0,3,0x0  ,0x3  ,0x0       ,1,0,0); // miss_spec and alignment
	  tab_request[62].modif(450,0,0,0,62,OPERATION_MEMORY_LOAD_32_Z    ,TYPE_MEMORY,0,0,0x0  ,size_memory  ,0x0       ,1,0,0); // bus error and alignement
	  tab_request[63].modif(460,0,0,0,63,OPERATION_MEMORY_LOAD_32_Z    ,TYPE_MEMORY,0,1,0x0  ,size_memory+1,0x0       ,1,0,0); // bus error and alignement


	  
	  tab_request[64].modif(500,0,0,0,64,OPERATION_MEMORY_STORE_32     ,TYPE_MEMORY,0,0,0x0  ,size_memory  ,0x0       ,0,0,0); // bus error
	  tab_request[65].modif(505,0,0,0,65,OPERATION_MEMORY_STORE_HEAD_OK,TYPE_MEMORY,0,0,0x0  ,0x0          ,0x0       ,0,0,0);
	  tab_request[66].modif(550,0,0,0,65,OPERATION_MEMORY_LOAD_32_Z    ,TYPE_MEMORY,1,0,0x0  ,0x0          ,0x0       ,1,0,0,0x55508570); // just to wait the dcache_rsp

	  const uint32_t nb_request = 64;//_param->_nb_packet;
        
	  for (uint32_t i=0; i<nb_request; i++)
	    {
	      std::cout << tab_request [i] << std::endl;
	      fifo_request.push(tab_request [i]);
	    }
	  LABEL("Simulation ...");
    
	  while (nb_request_memory_out < nb_request)
	    {
	      cout << "*********************************************" << endl;
	      cout << "Dump STORE_QUEUE_USE : " << endl;
	      cout << " use " << nb_store_slot_use << endl;
	      for (uint32_t i=0; i<_param->_size_store_queue; i++)
		cout << "  [" << i << "] " << store_queue_use [i] << endl;
	      cout << "Dump LOAD_QUEUE_USE : " << endl;
	      for (uint32_t i=0; i<_param->_size_load_queue ; i++)
		cout << "  [" << i << "] " << load_queue_use [i] << endl;
	      cout << "*********************************************" << endl;


	      // ***** MEMORY_IN *****

	      // memory_in_val depends of three factors :
	      //  1) request's fifo is not empty ?
	      //  2) the slot destination is free ?
	      //  3) The head of request's fifo can be issue : the number of cycle is more than current cycle

	      bool can_execute = false;

	      if (not fifo_request.empty())
		{
		  can_execute = sc_simulation_time() >= fifo_request.top()._cycle;
		  if (is_operation_memory_store(fifo_request.top()._operation))
		    can_execute &= (not store_queue_use [fifo_request.top()._store_queue_ptr_write] and (nb_store_slot_use < _param->_size_store_queue-1)) or is_operation_memory_store_head(fifo_request.top()._operation);
		  else
		    can_execute &= not load_queue_use  [fifo_request.top()._load_queue_ptr_write];
		}
	      in_MEMORY_IN_VAL ->write(can_execute);
	
	      if (not fifo_request.empty())
		{
		  if (_param->_have_port_context_id)
		    in_MEMORY_IN_CONTEXT_ID           ->write (fifo_request.top()._context_id           );
		  if (_param->_have_port_front_end_id)
		    in_MEMORY_IN_FRONT_END_ID         ->write (fifo_request.top()._front_end_id         );
		  if (_param->_have_port_ooo_engine_id)
		    in_MEMORY_IN_OOO_ENGINE_ID        ->write (fifo_request.top()._ooo_engine_id        );
		  if (_param->_have_port_packet_id)
		    in_MEMORY_IN_PACKET_ID            ->write (fifo_request.top()._packet_id            );
		  in_MEMORY_IN_OPERATION            ->write (fifo_request.top()._operation            );
		  in_MEMORY_IN_TYPE                 ->write (fifo_request.top()._type                 );
		  in_MEMORY_IN_STORE_QUEUE_PTR_WRITE->write (fifo_request.top()._store_queue_ptr_write);
		  if (_param->_have_port_load_queue_ptr)
		  in_MEMORY_IN_LOAD_QUEUE_PTR_WRITE ->write (fifo_request.top()._load_queue_ptr_write );
		  in_MEMORY_IN_IMMEDIAT             ->write (fifo_request.top()._immediat             );
		  in_MEMORY_IN_DATA_RA              ->write (fifo_request.top()._data_ra              );
		  in_MEMORY_IN_DATA_RB              ->write (fifo_request.top()._data_rb              );
// 		  in_MEMORY_IN_WRITE_RD             ->write (fifo_request.top()._write_rd             );
		  in_MEMORY_IN_NUM_REG_RD           ->write (fifo_request.top()._num_reg_rd           );
		}
	      in_MEMORY_OUT_ACK->write((rand()%100)<percent_transaction_memory_out);

	      // ***** DCACHE_REQ *****
	      in_DCACHE_REQ_ACK->write((rand()%100)<percent_transaction_dcache);

	      // ***** DCACHE_RSP *****
	      bool have_rsp = _cache->have_rsp ();
	      in_DCACHE_RSP_VAL->write(have_rsp);

	      if (have_rsp)
		{
		  in_DCACHE_RSP_CONTEXT_ID->write(_cache->front()._context_id);
		  in_DCACHE_RSP_PACKET_ID ->write(_cache->front()._packet_id );
		  in_DCACHE_RSP_RDATA     ->write(_cache->front()._rdata     );
		  in_DCACHE_RSP_ERROR     ->write(_cache->front()._error     );
		}

	      SC_START(0);

	      LABEL("MEMORY_IN  : %d - %d",in_MEMORY_IN_VAL ->read(),out_MEMORY_IN_ACK ->read());
	      if ( in_MEMORY_IN_VAL ->read() and out_MEMORY_IN_ACK ->read())
		{
		  Tpacket_t  packet_id = in_MEMORY_IN_PACKET_ID->read();

		  LABEL(" * Accepted MEMORY_IN  : %d",packet_id);
		  cout << fifo_request.top();

		  if (is_operation_memory_store(fifo_request.top()._operation))
		    {
		      if (not is_operation_memory_store_head(fifo_request.top()._operation))
			{
			  store_queue_use [fifo_request.top()._store_queue_ptr_write] = true;
			  nb_store_slot_use ++;
			}
		    }
		  else
		    load_queue_use [fifo_request.top()._load_queue_ptr_write] = true;

		  fifo_request.pop();
		}

	      LABEL("MEMORY_OUT : %d - %d",out_MEMORY_OUT_VAL->read(),in_MEMORY_OUT_ACK ->read());
	      if (out_MEMORY_OUT_VAL->read() and  in_MEMORY_OUT_ACK->read())
		{
		  Tpacket_t  packet_id = out_MEMORY_OUT_PACKET_ID->read();

		  LABEL(" * Accepted MEMORY_OUT : %d",packet_id);

		  if (is_operation_memory_store(tab_request[packet_id]._operation))
		    {
		      store_queue_use [tab_request[packet_id]._store_queue_ptr_write] = false;
		      nb_store_slot_use --;
		      nb_request_memory_out +=2;

		    }
		  else
		    {
		      if (not (out_MEMORY_OUT_EXCEPTION->read() == EXCEPTION_MEMORY_LOAD_SPECULATIVE))
			{
			  nb_request_memory_out ++;

			  load_queue_use  [tab_request[packet_id]._load_queue_ptr_write] = false;
			}
		      else
			{
			  std::cout << "seth - have a load_speculative." << std::endl;
			  tab_request[packet_id]._write_spec_ko = (out_MEMORY_OUT_DATA_RD->read() != tab_request[packet_id]._data_wait);
			  tab_request[packet_id]._previous_load_speculative = 1;
			}
		    }
		  
		  std::cout << "kane - nb_request_memory_out : " << nb_request_memory_out << std::endl;

		  // a lot of test
		  TEST(Tpacket_t         , out_MEMORY_OUT_PACKET_ID    ->read(), tab_request[packet_id]._packet_id    );
		  TEST(Tcontext_t        , out_MEMORY_OUT_CONTEXT_ID   ->read(), tab_request[packet_id]._context_id   );
		  TEST(Tcontext_t        , out_MEMORY_OUT_FRONT_END_ID ->read(), tab_request[packet_id]._front_end_id );
		  TEST(Tcontext_t        , out_MEMORY_OUT_OOO_ENGINE_ID->read(), tab_request[packet_id]._ooo_engine_id);
// 		  TEST(Toperation_t      , out_MEMORY_OUT_OPERATION    ->read(), tab_request[packet_id]._operation    );
		  TEST(Ttype_t           , out_MEMORY_OUT_TYPE         ->read(), TYPE_MEMORY                          );

		  if (is_operation_memory_load (tab_request[packet_id]._operation))
		    {
		      TEST(Tgeneral_address_t, out_MEMORY_OUT_NUM_REG_RD   ->read(), tab_request[packet_id]._num_reg_rd   );
		    }

		  Tgeneral_data_t address         = tab_request[packet_id]._data_ra + tab_request[packet_id]._immediat;

		  bool            error_alignment = (address != (address & (~ mask_memory_access(tab_request[packet_id]._operation))));
		  bool            berr            = (address >= size_memory);
		  Texception_t    exception       = out_MEMORY_OUT_EXCEPTION->read();

		  if (is_operation_memory_store(tab_request[packet_id]._operation))
		    {
		      TEST(Tcontrol_t        , out_MEMORY_OUT_WRITE_RD     ->read(), 0);

		      // store.
		      // prioritary : miss_speculation > aligmnent > DBERR
		      
			  bool test_result_ko = false;
			  
			  if (tab_request[packet_id]._write_spec_ko)
			    {
			      TEST(Texception_t, exception, EXCEPTION_MEMORY_MISS_SPECULATION);
			    }
			  else
			    if (error_alignment)
			      {
				TEST(Texception_t, exception, EXCEPTION_MEMORY_ALIGNMENT);
				test_result_ko = true;
			      }
			    else
			      if (berr)
				{
				  // TODO NOT SUPPORTED
// 				  TEST(Texception_t, exception, EXCEPTION_MEMORY_BUS_ERROR);

				  //test_result_ko = true;
				}
			      else
				{
				  TEST(Texception_t, exception, EXCEPTION_MEMORY_NONE);
				}
			  // In all case : test data
			  if (test_result_ko)
			    {
			      TEST(Tgeneral_data_t   , out_MEMORY_OUT_DATA_RD->read(), address);
			    }
		    }
		  else
		    {
		      // load
		      // prioritary : miss_speculation > aligmnent > DBERR
		      
		      bool is_load = is_operation_memory_load(tab_request[packet_id]._operation);

		      if (not (out_MEMORY_OUT_EXCEPTION->read() == EXCEPTION_MEMORY_LOAD_SPECULATIVE))
			{
			  bool test_result_ko = false;
			  
			  if (tab_request[packet_id]._write_spec_ko)
			    {
			      // IS A LOAD :D
			      TEST(Texception_t, exception, EXCEPTION_MEMORY_MISS_SPECULATION);
			      TEST(Tcontrol_t, out_MEMORY_OUT_WRITE_RD->read(), 1);
			    }
			  else
			    if (error_alignment)
			      {
				TEST(Texception_t, exception, EXCEPTION_MEMORY_ALIGNMENT);
				TEST(Tcontrol_t, out_MEMORY_OUT_WRITE_RD->read(), is_load);
				test_result_ko = true;
			      }
			    else
			      if (berr)
				{
				  TEST(Texception_t, exception, EXCEPTION_MEMORY_BUS_ERROR);
				  TEST(Tcontrol_t  , out_MEMORY_OUT_WRITE_RD->read(), is_load);
				  test_result_ko = true;
				}
			      else
				{
				  TEST(Texception_t, exception, EXCEPTION_MEMORY_NONE);
				  TEST(Tcontrol_t  , out_MEMORY_OUT_WRITE_RD->read(), is_load and not tab_request[packet_id]._previous_load_speculative);
				}
			  // In all case : test data
			  if (test_result_ko)
			    {
			      TEST(Tgeneral_data_t   , out_MEMORY_OUT_DATA_RD->read(), address);
			    }
			  else
			    {
			      TEST(Tgeneral_data_t   , out_MEMORY_OUT_DATA_RD->read(), tab_request[packet_id]._data_wait);
			    }
			}
		      else
			{
			  TEST(Tcontrol_t        , out_MEMORY_OUT_WRITE_RD     ->read(), 1);
			}
		    }
		}

	      LABEL("DCACHE_REQ : %d - %d",out_DCACHE_REQ_VAL->read(),in_DCACHE_REQ_ACK ->read());
	      if (out_DCACHE_REQ_VAL->read() and  in_DCACHE_REQ_ACK->read())
		{
		  Tcontext_t        context_id;
		  Tpacket_t         packet_id ; 
		  Tdcache_address_t address = out_DCACHE_REQ_ADDRESS->read();
		  Tdcache_data_t    rdata;
		  Tdcache_error_t   error = 0;
		  if (_param->_have_port_dcache_context_id)
		    context_id = out_DCACHE_REQ_CONTEXT_ID->read();
		  else
		    context_id = 0;

		  packet_id  = (out_DCACHE_REQ_PACKET_ID ->read())>>1;
	      
		  LABEL(" * Accepted DCACHE_REQ : %d",packet_id);

		  if (address >= size_memory)
		    {
		      // Bus error
		      error = DCACHE_ERROR_BUS_ERROR;
		      rdata = address; // convention : cache return the address fautive !
		    }
		  else
		    {
		      rdata = _memory->access (context_id, address, out_DCACHE_REQ_TYPE->read(), out_DCACHE_REQ_WDATA->read());
		      LABEL("   * rdata : 0x%x",rdata);
		    }

		  // test type : send or not a respons !
		  if ((out_DCACHE_REQ_TYPE->read() == DCACHE_TYPE_SYNCHRONIZATION) or
		      (out_DCACHE_REQ_TYPE->read() == DCACHE_TYPE_LOAD_8 ) or
		      (out_DCACHE_REQ_TYPE->read() == DCACHE_TYPE_LOAD_16) or
		      (out_DCACHE_REQ_TYPE->read() == DCACHE_TYPE_LOAD_32) or
		      (out_DCACHE_REQ_TYPE->read() == DCACHE_TYPE_LOAD_64) or
		      ((error != DCACHE_ERROR_NONE) and ((out_DCACHE_REQ_TYPE->read() == DCACHE_TYPE_STORE_8 ) or
							 (out_DCACHE_REQ_TYPE->read() == DCACHE_TYPE_STORE_16) or
							 (out_DCACHE_REQ_TYPE->read() == DCACHE_TYPE_STORE_32) or
							 (out_DCACHE_REQ_TYPE->read() == DCACHE_TYPE_STORE_64) )))
		    {
		      LABEL("     * have_dcache_rsp");
		  
		      _cache->push (context_id,
				    out_DCACHE_REQ_PACKET_ID ->read(),
				    rdata,
				    error);
		    }
		}

	      LABEL("DCACHE_RSP : %d - %d",in_DCACHE_RSP_VAL->read(),out_DCACHE_RSP_ACK ->read());
	      if (in_DCACHE_RSP_VAL->read() and out_DCACHE_RSP_ACK->read())
		{
		  _cache->pop();
		}

	      _cache->end_cycle();

	      SC_START(1);
	    }
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      _memory->trace();
      throw (error);
    }

  _memory->trace();

  
  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;
  cout << "<" << name << "> ............ Stop Simulation" << endl;

  delete     in_CLOCK;
  delete     in_NRESET;

  delete     in_MEMORY_IN_VAL         ;
  delete    out_MEMORY_IN_ACK         ;
  delete     in_MEMORY_IN_CONTEXT_ID  ;
  delete     in_MEMORY_IN_FRONT_END_ID  ;
  delete     in_MEMORY_IN_OOO_ENGINE_ID  ;
  delete     in_MEMORY_IN_PACKET_ID   ;
  delete     in_MEMORY_IN_OPERATION   ;
  delete     in_MEMORY_IN_STORE_QUEUE_PTR_WRITE;
  delete     in_MEMORY_IN_LOAD_QUEUE_PTR_WRITE ;
  delete     in_MEMORY_IN_HAS_IMMEDIAT;
  delete     in_MEMORY_IN_IMMEDIAT    ;
  delete     in_MEMORY_IN_DATA_RA     ;
  delete     in_MEMORY_IN_DATA_RB     ;
  delete     in_MEMORY_IN_DATA_RC     ;
  delete     in_MEMORY_IN_WRITE_RD    ;
  delete     in_MEMORY_IN_NUM_REG_RD  ;
  delete     in_MEMORY_IN_WRITE_RE    ;
  delete     in_MEMORY_IN_NUM_REG_RE  ;
    
  delete    out_MEMORY_OUT_VAL       ;
  delete     in_MEMORY_OUT_ACK       ;
  delete    out_MEMORY_OUT_CONTEXT_ID;
  delete    out_MEMORY_OUT_FRONT_END_ID;
  delete    out_MEMORY_OUT_OOO_ENGINE_ID;
  delete    out_MEMORY_OUT_PACKET_ID ;
//   delete    out_MEMORY_OUT_OPERATION ;
  delete    out_MEMORY_OUT_TYPE      ;
  delete    out_MEMORY_OUT_WRITE_RD  ;
  delete    out_MEMORY_OUT_NUM_REG_RD;
  delete    out_MEMORY_OUT_DATA_RD   ;
  delete    out_MEMORY_OUT_WRITE_RE  ;
  delete    out_MEMORY_OUT_NUM_REG_RE;
  delete    out_MEMORY_OUT_DATA_RE   ;
  delete    out_MEMORY_OUT_EXCEPTION ;
  delete    out_MEMORY_OUT_NO_SEQUENCE;
  delete    out_MEMORY_OUT_ADDRESS   ;
  
  delete    out_DCACHE_REQ_VAL       ;
  delete     in_DCACHE_REQ_ACK       ;
  delete    out_DCACHE_REQ_CONTEXT_ID;
  delete    out_DCACHE_REQ_PACKET_ID ;
  delete    out_DCACHE_REQ_ADDRESS   ;
  delete    out_DCACHE_REQ_TYPE      ;
  delete    out_DCACHE_REQ_WDATA     ;
  
  delete     in_DCACHE_RSP_VAL       ;
  delete    out_DCACHE_RSP_ACK       ;
  delete     in_DCACHE_RSP_CONTEXT_ID;
  delete     in_DCACHE_RSP_PACKET_ID ;
  delete     in_DCACHE_RSP_RDATA     ;
  delete     in_DCACHE_RSP_ERROR     ;
  
    {
      delete [] out_BYPASS_MEMORY_VAL       ;
      delete [] out_BYPASS_MEMORY_OOO_ENGINE_ID;
      delete [] out_BYPASS_MEMORY_NUM_REG   ;
      delete [] out_BYPASS_MEMORY_DATA      ;
    }
#endif

  delete _Load_store_unit;
  delete _memory;
  delete _cache;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
  delete _param;
}
