/*
 * $Id: test.cpp 82 2008-05-01 16:48:45Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#define NB_ITERATION  1
#define CYCLE_MAX     (128*NB_ITERATION)

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/SelfTest/include/test.h"
#include "Common/include/Test.h"
#include "Behavioural/include/Allocation.h"

void test (string name,
	   morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Prediction_unit * _Prediction_unit = new Prediction_unit 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     USE_ALL);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");


  ALLOC1_SC_SIGNAL( in_PREDICT_VAL                        ," in_PREDICT_VAL                        ",Tcontrol_t         ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_PREDICT_ACK                        ,"out_PREDICT_ACK                        ",Tcontrol_t         ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_PREDICT_PC_PREVIOUS                ," in_PREDICT_PC_PREVIOUS                ",Taddress_t         ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_PREDICT_PC_CURRENT                 ," in_PREDICT_PC_CURRENT                 ",Taddress_t         ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_PREDICT_PC_CURRENT_IS_DS_TAKE      ," in_PREDICT_PC_CURRENT_IS_DS_TAKE      ",Tcontrol_t         ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_PREDICT_PC_NEXT                    ,"out_PREDICT_PC_NEXT                    ",Taddress_t         ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_PREDICT_PC_NEXT_IS_DS_TAKE         ,"out_PREDICT_PC_NEXT_IS_DS_TAKE         ",Tcontrol_t         ,_param->_nb_context);
  ALLOC2_SC_SIGNAL(out_PREDICT_INSTRUCTION_ENABLE         ,"out_PREDICT_INSTRUCTION_ENABLE         ",Tcontrol_t         ,_param->_nb_context,_param->_nb_instruction[alloc_signal_it1]);
  ALLOC1_SC_SIGNAL(out_PREDICT_INST_IFETCH_PTR            ,"out_PREDICT_INST_IFETCH_PTR            ",Tinst_ifetch_ptr_t ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_PREDICT_BRANCH_STATE               ,"out_PREDICT_BRANCH_STATE               ",Tbranch_state_t    ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID,"out_PREDICT_BRANCH_UPDATE_PREDICTION_ID",Tprediction_ptr_t  ,_param->_nb_context);
												                         
  ALLOC2_SC_SIGNAL( in_DECOD_VAL                          ," in_DECOD_VAL                          ",Tcontrol_t         ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1]);
  ALLOC2_SC_SIGNAL(out_DECOD_ACK                          ,"out_DECOD_ACK                          ",Tcontrol_t         ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1]);
  ALLOC2_SC_SIGNAL( in_DECOD_CONTEXT_ID                   ," in_DECOD_CONTEXT_ID                   ",Tcontext_t         ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1]);
  ALLOC2_SC_SIGNAL( in_DECOD_MATCH_INST_IFETCH_PTR        ," in_DECOD_MATCH_INST_IFETCH_PTR        ",Tcontrol_t         ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1]);
  ALLOC2_SC_SIGNAL( in_DECOD_BRANCH_STATE                 ," in_DECOD_BRANCH_STATE                 ",Tbranch_state_t    ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1]);
  ALLOC2_SC_SIGNAL( in_DECOD_BRANCH_UPDATE_PREDICTION_ID  ," in_DECOD_BRANCH_UPDATE_PREDICTION_ID  ",Tprediction_ptr_t  ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1]);
  ALLOC2_SC_SIGNAL( in_DECOD_BRANCH_CONDITION             ," in_DECOD_BRANCH_CONDITION             ",Tbranch_condition_t,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1]);
  ALLOC2_SC_SIGNAL( in_DECOD_BRANCH_DIRECTION             ," in_DECOD_BRANCH_DIRECTION             ",Tcontrol_t         ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1]);
  ALLOC2_SC_SIGNAL( in_DECOD_ADDRESS_SRC                  ," in_DECOD_ADDRESS_SRC                  ",Taddress_t         ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1]);
  ALLOC2_SC_SIGNAL( in_DECOD_ADDRESS_DEST                 ," in_DECOD_ADDRESS_DEST                 ",Taddress_t         ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1]);
												                         
  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_VAL                ," in_BRANCH_COMPLETE_VAL                ",Tcontrol_t         ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_ACK                ,"out_BRANCH_COMPLETE_ACK                ",Tcontrol_t         ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_CONTEXT_ID         ," in_BRANCH_COMPLETE_CONTEXT_ID         ",Tcontext_t         ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_DEPTH              ," in_BRANCH_COMPLETE_DEPTH              ",Tdepth_t           ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_ADDRESS            ," in_BRANCH_COMPLETE_ADDRESS            ",Taddress_t         ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_FLAG               ," in_BRANCH_COMPLETE_FLAG               ",Tcontrol_t         ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_MISS_PREDICTION    ,"out_BRANCH_COMPLETE_MISS_PREDICTION    ",Tcontrol_t         ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_TAKE               ,"out_BRANCH_COMPLETE_TAKE               ",Tcontrol_t         ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_ADDRESS_SRC        ,"out_BRANCH_COMPLETE_ADDRESS_SRC        ",Taddress_t         ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_ADDRESS_DEST       ,"out_BRANCH_COMPLETE_ADDRESS_DEST       ",Taddress_t         ,_param->_nb_inst_branch_complete);
												                         
  ALLOC1_SC_SIGNAL(out_BRANCH_EVENT_VAL                   ,"out_BRANCH_EVENT_VAL                   ",Tcontrol_t         ,_param->_nb_context);
  ALLOC1_SC_SIGNAL( in_BRANCH_EVENT_ACK                   ," in_BRANCH_EVENT_ACK                   ",Tcontrol_t         ,_param->_nb_context);
//ALLOC1_SC_SIGNAL(out_BRANCH_EVENT_CONTEXT_ID            ,"out_BRANCH_EVENT_CONTEXT_ID            ",Tcontext_t         ,_param->_nb_context);
//ALLOC1_SC_SIGNAL(out_BRANCH_EVENT_DEPTH                 ,"out_BRANCH_EVENT_DEPTH                 ",Tdepth_t           ,_param->_nb_context);
//ALLOC1_SC_SIGNAL(out_BRANCH_EVENT_MISS_PREDICTION       ,"out_BRANCH_EVENT_MISS_PREDICTION       ",Tcontrol_t         ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_BRANCH_EVENT_ADDRESS_SRC           ,"out_BRANCH_EVENT_ADDRESS_SRC           ",Taddress_t         ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_BRANCH_EVENT_ADDRESS_DEST          ,"out_BRANCH_EVENT_ADDRESS_DEST          ",Taddress_t         ,_param->_nb_context);
												                         
  ALLOC1_SC_SIGNAL(out_DEPTH_NB_BRANCH                    ,"out_DEPTH_NB_BRANCH                    ",Tdepth_t           ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_DEPTH_TAIL                         ,"out_DEPTH_TAIL                         ",Tdepth_t           ,_param->_nb_context);
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Prediction_unit.\n"),name.c_str());

  (*(_Prediction_unit->in_CLOCK))        (*(in_CLOCK));
  (*(_Prediction_unit->in_NRESET))       (*(in_NRESET));

  INSTANCE1_SC_SIGNAL(_Prediction_unit, in_PREDICT_VAL                        ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Prediction_unit,out_PREDICT_ACK                        ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Prediction_unit, in_PREDICT_PC_PREVIOUS                ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Prediction_unit, in_PREDICT_PC_CURRENT                 ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Prediction_unit, in_PREDICT_PC_CURRENT_IS_DS_TAKE      ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Prediction_unit,out_PREDICT_PC_NEXT                    ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Prediction_unit,out_PREDICT_PC_NEXT_IS_DS_TAKE         ,_param->_nb_context);
  INSTANCE2_SC_SIGNAL(_Prediction_unit,out_PREDICT_INSTRUCTION_ENABLE         ,_param->_nb_context,_param->_nb_instruction[alloc_signal_it1]);
  INSTANCE1_SC_SIGNAL(_Prediction_unit,out_PREDICT_BRANCH_STATE               ,_param->_nb_context);

  for (uint32_t i=0; i<_param->_nb_context; i++)
    {
      if (_param->_have_port_inst_ifetch_ptr [i])
	INSTANCE_SC_SIGNAL(_Prediction_unit,out_PREDICT_INST_IFETCH_PTR [i]);
      if (_param->_have_port_depth [i])
	INSTANCE_SC_SIGNAL(_Prediction_unit,out_PREDICT_BRANCH_UPDATE_PREDICTION_ID [i]);
    }

  INSTANCE2_SC_SIGNAL(_Prediction_unit, in_DECOD_VAL                          ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1]);
  INSTANCE2_SC_SIGNAL(_Prediction_unit,out_DECOD_ACK                          ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1]);
  if (_param->_have_port_context_id)
  INSTANCE2_SC_SIGNAL(_Prediction_unit, in_DECOD_CONTEXT_ID                   ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1]);
  INSTANCE2_SC_SIGNAL(_Prediction_unit, in_DECOD_MATCH_INST_IFETCH_PTR        ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1]);
  INSTANCE2_SC_SIGNAL(_Prediction_unit, in_DECOD_BRANCH_STATE                 ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1]);
  if (_param->_have_port_max_depth)
  INSTANCE2_SC_SIGNAL(_Prediction_unit, in_DECOD_BRANCH_UPDATE_PREDICTION_ID  ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1]);
  INSTANCE2_SC_SIGNAL(_Prediction_unit, in_DECOD_BRANCH_CONDITION             ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1]);
  INSTANCE2_SC_SIGNAL(_Prediction_unit, in_DECOD_BRANCH_DIRECTION             ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1]);
  INSTANCE2_SC_SIGNAL(_Prediction_unit, in_DECOD_ADDRESS_SRC                  ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1]);
  INSTANCE2_SC_SIGNAL(_Prediction_unit, in_DECOD_ADDRESS_DEST                 ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1]);

  INSTANCE1_SC_SIGNAL(_Prediction_unit, in_BRANCH_COMPLETE_VAL                ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Prediction_unit,out_BRANCH_COMPLETE_ACK                ,_param->_nb_inst_branch_complete);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Prediction_unit, in_BRANCH_COMPLETE_CONTEXT_ID         ,_param->_nb_inst_branch_complete);
  if (_param->_have_port_max_depth)
  INSTANCE1_SC_SIGNAL(_Prediction_unit, in_BRANCH_COMPLETE_DEPTH              ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Prediction_unit, in_BRANCH_COMPLETE_ADDRESS            ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Prediction_unit, in_BRANCH_COMPLETE_FLAG               ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Prediction_unit,out_BRANCH_COMPLETE_MISS_PREDICTION    ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Prediction_unit,out_BRANCH_COMPLETE_TAKE               ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Prediction_unit,out_BRANCH_COMPLETE_ADDRESS_SRC        ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Prediction_unit,out_BRANCH_COMPLETE_ADDRESS_DEST       ,_param->_nb_inst_branch_complete);

  INSTANCE1_SC_SIGNAL(_Prediction_unit,out_BRANCH_EVENT_VAL                   ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Prediction_unit, in_BRANCH_EVENT_ACK                   ,_param->_nb_context);
//if (_param->_have_port_context_id)
//INSTANCE1_SC_SIGNAL(_Prediction_unit,out_BRANCH_EVENT_CONTEXT_ID            ,_param->_nb_context);
//INSTANCE1_SC_SIGNAL(_Prediction_unit,out_BRANCH_EVENT_DEPTH                 ,_param->_nb_context);
//INSTANCE1_SC_SIGNAL(_Prediction_unit,out_BRANCH_EVENT_MISS_PREDICTION       ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Prediction_unit,out_BRANCH_EVENT_ADDRESS_SRC           ,_param->_nb_context);
  INSTANCE1_SC_SIGNAL(_Prediction_unit,out_BRANCH_EVENT_ADDRESS_DEST          ,_param->_nb_context);

  INSTANCE1_SC_SIGNAL(_Prediction_unit,out_DEPTH_NB_BRANCH                    ,_param->_nb_context);
  for (uint32_t i=0; i<_param->_nb_context; i++)
    if (_param->_have_port_depth[i])
      INSTANCE_SC_SIGNAL(_Prediction_unit,out_DEPTH_TAIL [i]);

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      SC_START(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  DELETE1_SC_SIGNAL( in_PREDICT_VAL                        ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_PREDICT_ACK                        ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_PREDICT_PC_PREVIOUS                ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_PREDICT_PC_CURRENT                 ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_PREDICT_PC_CURRENT_IS_DS_TAKE      ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_PREDICT_PC_NEXT                    ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_PREDICT_PC_NEXT_IS_DS_TAKE         ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_PREDICT_INST_IFETCH_PTR            ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_PREDICT_BRANCH_STATE               ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID,_param->_nb_context);

  DELETE2_SC_SIGNAL(out_PREDICT_INSTRUCTION_ENABLE       ,_param->_nb_context,_param->_nb_instruction[alloc_signal_it1]);
  DELETE2_SC_SIGNAL( in_DECOD_VAL                        ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1]);
  DELETE2_SC_SIGNAL(out_DECOD_ACK                        ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1]);
  DELETE2_SC_SIGNAL( in_DECOD_CONTEXT_ID                 ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1]);
  DELETE2_SC_SIGNAL( in_DECOD_MATCH_INST_IFETCH_PTR      ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1]);
  DELETE2_SC_SIGNAL( in_DECOD_BRANCH_STATE               ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1]);
  DELETE2_SC_SIGNAL( in_DECOD_BRANCH_UPDATE_PREDICTION_ID,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1]);
  DELETE2_SC_SIGNAL( in_DECOD_BRANCH_CONDITION           ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1]);
  DELETE2_SC_SIGNAL( in_DECOD_BRANCH_DIRECTION           ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1]);
  DELETE2_SC_SIGNAL( in_DECOD_ADDRESS_SRC                ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1]);
  DELETE2_SC_SIGNAL( in_DECOD_ADDRESS_DEST               ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1]);

  DELETE1_SC_SIGNAL( in_BRANCH_COMPLETE_VAL            ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL(out_BRANCH_COMPLETE_ACK            ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL( in_BRANCH_COMPLETE_CONTEXT_ID     ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL( in_BRANCH_COMPLETE_DEPTH          ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL( in_BRANCH_COMPLETE_ADDRESS        ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL( in_BRANCH_COMPLETE_FLAG           ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL(out_BRANCH_COMPLETE_MISS_PREDICTION,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL(out_BRANCH_COMPLETE_TAKE           ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL(out_BRANCH_COMPLETE_ADDRESS_SRC    ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL(out_BRANCH_COMPLETE_ADDRESS_DEST   ,_param->_nb_inst_branch_complete);

  DELETE1_SC_SIGNAL(out_BRANCH_EVENT_VAL            ,_param->_nb_context);
  DELETE1_SC_SIGNAL( in_BRANCH_EVENT_ACK            ,_param->_nb_context);
//DELETE1_SC_SIGNAL(out_BRANCH_EVENT_CONTEXT_ID     ,_param->_nb_context);
//DELETE1_SC_SIGNAL(out_BRANCH_EVENT_DEPTH          ,_param->_nb_context);
//DELETE1_SC_SIGNAL(out_BRANCH_EVENT_MISS_PREDICTION,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_BRANCH_EVENT_ADDRESS_SRC    ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_BRANCH_EVENT_ADDRESS_DEST   ,_param->_nb_context);

  DELETE1_SC_SIGNAL(out_DEPTH_NB_BRANCH    ,_param->_nb_context);
  DELETE1_SC_SIGNAL(out_DEPTH_TAIL         ,_param->_nb_context);
#endif

  delete _Prediction_unit;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
