/*
 * $Id: Update_Prediction_Table_allocation.cpp 82 2008-05-01 16:48:45Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Update_Prediction_Table/include/Update_Prediction_Table.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace update_prediction_table {



#undef  FUNCTION
#define FUNCTION "Update_Prediction_Table::allocation"
  void Update_Prediction_Table::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_printf(FUNC,Update_Prediction_Table,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Update_Prediction_Table"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 "Generalist interface"
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("predict", IN,SOUTH, "predict", _param->_nb_inst_predict);
      
      ALLOC1_VALACK_IN ( in_PREDICT_VAL                 ,VAL);
      ALLOC1_VALACK_OUT(out_PREDICT_ACK                 ,ACK);
      ALLOC1_SIGNAL_IN ( in_PREDICT_CONTEXT_ID          ,"context_id"          ,Tcontext_t         ,_param->_size_context_id);
      ALLOC1_SIGNAL_IN ( in_PREDICT_BTB_ADDRESS_SRC     ,"btb_address_src"     ,Taddress_t         ,_param->_size_address);
      ALLOC1_SIGNAL_IN ( in_PREDICT_BTB_ADDRESS_DEST    ,"btb_address_dest"    ,Taddress_t         ,_param->_size_address);
      ALLOC1_SIGNAL_IN ( in_PREDICT_BTB_CONDITION       ,"btb_condition"       ,Tbranch_condition_t,_param->_size_branch_condition);
      ALLOC1_SIGNAL_IN ( in_PREDICT_BTB_LAST_TAKE       ,"btb_last_take"       ,Tcontrol_t         ,1);
      ALLOC1_SIGNAL_IN ( in_PREDICT_BTB_IS_ACCURATE     ,"btb_is_accurate"     ,Tcontrol_t         ,1);
      ALLOC1_SIGNAL_IN ( in_PREDICT_DIR_HISTORY         ,"dir_history"         ,Thistory_t         ,_param->_size_history);
      ALLOC1_SIGNAL_IN ( in_PREDICT_RAS_ADDRESS         ,"ras_address"         ,Taddress_t         ,_param->_size_address);
      ALLOC1_SIGNAL_IN ( in_PREDICT_RAS_INDEX           ,"ras_index"           ,Tptr_t             ,_param->_max_size_ras_index);
//       ALLOC1_SIGNAL_OUT(out_PREDICT_UPDATE_PREDICTION_ID,"update_prediction_id",Tprediction_ptr_t  ,_param->_size_depth);
    }

    // ~~~~~[ Interface : "decod" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("decod", IN,SOUTH, "decod", _param->_nb_inst_predict);

      ALLOC1_VALACK_IN ( in_DECOD_VAL                 ,VAL);
      ALLOC1_VALACK_OUT(out_DECOD_ACK                 ,ACK);
      ALLOC1_SIGNAL_IN ( in_DECOD_CONTEXT_ID          ,"context_id"          ,Tcontext_t         ,_param->_size_context_id);
      ALLOC1_SIGNAL_IN ( in_DECOD_BTB_ADDRESS_SRC     ,"btb_address_src"     ,Taddress_t         ,_param->_size_address);
      ALLOC1_SIGNAL_IN ( in_DECOD_BTB_ADDRESS_DEST    ,"btb_address_dest"    ,Taddress_t         ,_param->_size_address);
      ALLOC1_SIGNAL_IN ( in_DECOD_BTB_CONDITION       ,"btb_condition"       ,Tbranch_condition_t,_param->_size_branch_condition);
      ALLOC1_SIGNAL_IN ( in_DECOD_BTB_LAST_TAKE       ,"btb_last_take"       ,Tcontrol_t         ,1);
      ALLOC1_SIGNAL_IN ( in_DECOD_RAS_ADDRESS         ,"ras_address"         ,Taddress_t         ,_param->_size_address);
      ALLOC1_SIGNAL_IN ( in_DECOD_RAS_INDEX           ,"ras_index"           ,Tptr_t             ,_param->_max_size_ras_index);
      ALLOC1_SIGNAL_IN ( in_DECOD_MISS_IFETCH         ,"miss_ifetch"         ,Tcontrol_t         ,1);
      ALLOC1_SIGNAL_IN ( in_DECOD_MISS_DECOD          ,"miss_decod"          ,Tcontrol_t         ,1);
      ALLOC1_SIGNAL_IN ( in_DECOD_UPDATE_PREDICTION_ID,"update_prediction_id",Tprediction_ptr_t  ,_param->_max_size_depth);
//    ALLOC1_SIGNAL_OUT(out_DECOD_DEPTH               ,"depth"               ,Tdepth_t           ,_param->_size_depth);
    }

    // ~~~~~[ Interface : "branch_complete" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("branch_complete", IN,SOUTH, "branch_complete", _param->_nb_inst_branch_complete);
      
      ALLOC1_VALACK_IN ( in_BRANCH_COMPLETE_VAL            ,VAL);
      ALLOC1_VALACK_OUT(out_BRANCH_COMPLETE_ACK            ,ACK);
      ALLOC1_SIGNAL_IN ( in_BRANCH_COMPLETE_CONTEXT_ID     ,"context_id"     ,Tcontext_t,_param->_size_context_id);
      ALLOC1_SIGNAL_IN ( in_BRANCH_COMPLETE_DEPTH          ,"depth"          ,Tdepth_t  ,_param->_max_size_depth);
      ALLOC1_SIGNAL_IN ( in_BRANCH_COMPLETE_ADDRESS        ,"address"        ,Taddress_t,_param->_size_address);
      ALLOC1_SIGNAL_IN ( in_BRANCH_COMPLETE_FLAG           ,"flag"           ,Tcontrol_t,1);
      ALLOC1_SIGNAL_OUT(out_BRANCH_COMPLETE_MISS_PREDICTION,"miss_prediction",Tcontrol_t,1);
      ALLOC1_SIGNAL_OUT(out_BRANCH_COMPLETE_TAKE           ,"take"           ,Tcontrol_t,1);
      ALLOC1_SIGNAL_OUT(out_BRANCH_COMPLETE_ADDRESS_SRC    ,"address_src"    ,Taddress_t,_param->_size_address);
      ALLOC1_SIGNAL_OUT(out_BRANCH_COMPLETE_ADDRESS_DEST   ,"address_dest"   ,Taddress_t,_param->_size_address);
    }

    // ~~~~~[ Interface : "branch_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("branch_event", IN,SOUTH, "branch_event", _param->_nb_context);
      
      ALLOC1_VALACK_OUT(out_BRANCH_EVENT_VAL            ,VAL);
      ALLOC1_VALACK_IN ( in_BRANCH_EVENT_ACK            ,ACK);
//    ALLOC1_SIGNAL_OUT(out_BRANCH_EVENT_CONTEXT_ID     ,"context_id"     ,Tcontext_t,_param->_size_context_id);
//    ALLOC1_SIGNAL_OUT(out_BRANCH_EVENT_DEPTH          ,"depth"          ,Tdepth_t  ,_param->_max_size_depth);
//    ALLOC1_SIGNAL_OUT(out_BRANCH_EVENT_MISS_PREDICTION,"miss_prediction",Tcontrol_t,1);
      ALLOC1_SIGNAL_OUT(out_BRANCH_EVENT_ADDRESS_SRC    ,"address_src"    ,Taddress_t,_param->_size_address);
      ALLOC1_SIGNAL_OUT(out_BRANCH_EVENT_ADDRESS_DEST   ,"address_dest"   ,Taddress_t,_param->_size_address);
    }

    // ~~~~~[ Interface : "update" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("update",OUT,SOUTH, "update", _param->_nb_inst_update);

      ALLOC1_VALACK_OUT(out_UPDATE_VAL                  ,VAL);
      ALLOC1_VALACK_IN ( in_UPDATE_ACK                  ,ACK);
      ALLOC1_SIGNAL_OUT(out_UPDATE_CONTEXT_ID           ,"context_id"           ,Tcontext_t         ,_param->_size_context_id);
      ALLOC1_SIGNAL_OUT(out_UPDATE_MISS_PREDICTION      ,"miss_prediction"      ,Tcontrol_t         ,1);
      ALLOC1_SIGNAL_OUT(out_UPDATE_DIRECTION_GOOD       ,"direction_good"       ,Tcontrol_t         ,1);
      ALLOC1_SIGNAL_OUT(out_UPDATE_BTB_VAL              ,"btb_val"              ,Tcontrol_t         ,1);
      ALLOC1_SIGNAL_OUT(out_UPDATE_BTB_ADDRESS_SRC      ,"btb_address_src"      ,Taddress_t         ,_param->_size_address);
      ALLOC1_SIGNAL_OUT(out_UPDATE_BTB_ADDRESS_DEST     ,"btb_address_dest"     ,Taddress_t         ,_param->_size_address);
      ALLOC1_SIGNAL_OUT(out_UPDATE_BTB_CONDITION        ,"btb_condition"        ,Tbranch_condition_t,_param->_size_branch_condition);
      ALLOC1_SIGNAL_OUT(out_UPDATE_DIR_VAL              ,"dir_val"              ,Tcontrol_t         ,1);
      ALLOC1_SIGNAL_OUT(out_UPDATE_DIR_HISTORY          ,"dir_history"          ,Thistory_t         ,_param->_size_history);
      ALLOC1_SIGNAL_OUT(out_UPDATE_RAS_VAL              ,"ras_val"              ,Tcontrol_t         ,1);
      ALLOC1_SIGNAL_OUT(out_UPDATE_RAS_PUSH             ,"ras_push"             ,Tcontrol_t         ,1);
      ALLOC1_SIGNAL_OUT(out_UPDATE_RAS_ADDRESS          ,"ras_address"          ,Taddress_t         ,_param->_size_address);
      ALLOC1_SIGNAL_OUT(out_UPDATE_RAS_INDEX            ,"ras_index"            ,Tptr_t             ,_param->_max_size_ras_index);
      ALLOC1_SIGNAL_OUT(out_UPDATE_RAS_PREDICTION_IFETCH,"ras_prediction_ifetch",Tcontrol_t         ,1);
    }

    // ~~~~~[ Interface : "depth" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("depth",OUT,SOUTH, "depth", _param->_nb_context);

      ALLOC1_SIGNAL_OUT(out_DEPTH_TAIL     ,"TAIL"     ,Tdepth_t,_param->_size_depth[alloc_signal_it1]);
      ALLOC1_SIGNAL_OUT(out_DEPTH_NB_BRANCH,"NB_BRANCH",Tdepth_t,_param->_size_depth[alloc_signal_it1]+1);
    }

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    internal_PREDICT_ACK                     = new Tcontrol_t [_param->_nb_inst_predict];
    internal_DECOD_ACK                       = new Tcontrol_t [_param->_nb_inst_decod];
    internal_BRANCH_COMPLETE_ACK             = new Tcontrol_t [_param->_nb_inst_branch_complete];
    internal_BRANCH_COMPLETE_MISS_PREDICTION = new Tcontrol_t [_param->_nb_inst_branch_complete];
    internal_BRANCH_COMPLETE_TAKE            = new Tcontrol_t [_param->_nb_inst_branch_complete];
    internal_BRANCH_COMPLETE_ADDRESS_DEST    = new Taddress_t [_param->_nb_inst_branch_complete];
    internal_BRANCH_EVENT_VAL                = new Tcontrol_t [_param->_nb_context];
    internal_BRANCH_EVENT_DEPTH              = new Tdepth_t   [_param->_nb_context];
    internal_UPDATE_VAL                      = new Tcontrol_t [_param->_nb_inst_update];
    internal_UPDATE_CONTEXT_ID               = new Tcontext_t [_param->_nb_inst_update];
    internal_UPDATE_DEPTH                    = new Tdepth_t   [_param->_nb_inst_update];

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    reg_TOP                     = new uint32_t  [_param->_nb_context];
    reg_BOTTOM                  = new uint32_t  [_param->_nb_context];
    reg_NB_ELT                  = new uint32_t  [_param->_nb_context];
    reg_NB_ELT_UPDATE           = new uint32_t  [_param->_nb_context];
    reg_NB_ELT_NEED_UPDATE      = new uint32_t  [_param->_nb_context];
    reg_UPDATE_PREDICTION_TABLE = new entry_t * [_param->_nb_context];
    for (uint32_t i=0; i<_param->_nb_context; i++)
      {
#ifndef NO_INIT
	reg_TOP [i] = 0;
#endif
	reg_UPDATE_PREDICTION_TABLE [i] = new entry_t [_param->_size_queue[i]];
      }
    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

#ifdef POSITION
    _component->generate_file();
#endif

    log_printf(FUNC,Update_Prediction_Table,FUNCTION,"End");
  };

}; // end namespace update_prediction_table
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
