/*
 * $Id: Update_Prediction_Table_deallocation.cpp 82 2008-05-01 16:48:45Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Update_Prediction_Table/include/Update_Prediction_Table.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace update_prediction_table {


#undef  FUNCTION
#define FUNCTION "Update_Prediction_Table::deallocation"
  void Update_Prediction_Table::deallocation (void)
  {
    log_printf(FUNC,Update_Prediction_Table,FUNCTION,"Begin");

    if (_usage & USE_SYSTEMC)
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

	// ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	delete []  in_PREDICT_VAL                 ;
	delete [] out_PREDICT_ACK                 ;
	if (_param->_have_port_context_id)
	delete []  in_PREDICT_CONTEXT_ID          ;
	delete []  in_PREDICT_BTB_ADDRESS_SRC     ;
	delete []  in_PREDICT_BTB_ADDRESS_DEST    ;
	delete []  in_PREDICT_BTB_CONDITION       ;
	delete []  in_PREDICT_BTB_LAST_TAKE       ;
	delete []  in_PREDICT_BTB_IS_ACCURATE     ;
	if (_param->_have_port_history)
	delete []  in_PREDICT_DIR_HISTORY         ;
	delete []  in_PREDICT_RAS_ADDRESS         ;
	delete []  in_PREDICT_RAS_INDEX           ;
// 	if (_param->_have_port_depth)
// 	delete [] out_PREDICT_UPDATE_PREDICTION_ID;
	
	// ~~~~~[ Interface : "decod" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	delete []  in_DECOD_VAL                   ;
	delete [] out_DECOD_ACK                   ;
	if (_param->_have_port_context_id)
	delete []  in_DECOD_CONTEXT_ID            ;
	delete []  in_DECOD_BTB_ADDRESS_SRC       ;
	delete []  in_DECOD_BTB_ADDRESS_DEST      ;
	delete []  in_DECOD_BTB_CONDITION         ;
	delete []  in_DECOD_BTB_LAST_TAKE         ;
	delete []  in_DECOD_RAS_ADDRESS           ;
	delete []  in_DECOD_RAS_INDEX             ;
	delete []  in_DECOD_MISS_IFETCH           ;
	delete []  in_DECOD_MISS_DECOD            ;
	if (_param->_have_port_max_depth)
	delete []  in_DECOD_UPDATE_PREDICTION_ID  ;
// 	if (_param->_have_port_depth)
// 	delete [] out_DECOD_DEPTH                 ;
	
	// ~~~~~[ Interface : "branch_complete" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	delete []  in_BRANCH_COMPLETE_VAL            ;
	delete [] out_BRANCH_COMPLETE_ACK            ;
	if (_param->_have_port_context_id)
	delete []  in_BRANCH_COMPLETE_CONTEXT_ID     ;
	if (_param->_have_port_max_depth)
	delete []  in_BRANCH_COMPLETE_DEPTH          ;
	delete []  in_BRANCH_COMPLETE_ADDRESS        ;
	delete []  in_BRANCH_COMPLETE_FLAG           ;
	delete [] out_BRANCH_COMPLETE_MISS_PREDICTION;
	delete [] out_BRANCH_COMPLETE_TAKE           ;
	delete [] out_BRANCH_COMPLETE_ADDRESS_SRC    ;
	delete [] out_BRANCH_COMPLETE_ADDRESS_DEST   ;

	// ~~~~~[ Interface : "branch_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	delete [] out_BRANCH_EVENT_VAL            ;
	delete []  in_BRANCH_EVENT_ACK            ;
// 	if (_param->_have_port_context_id)
// 	delete []  in_BRANCH_EVENT_CONTEXT_ID     ;
// 	if (_param->_have_port_max_depth)
// 	delete []  in_BRANCH_EVENT_DEPTH          ;
// 	delete [] out_BRANCH_EVENT_MISS_PREDICTION;
	delete [] out_BRANCH_EVENT_ADDRESS_SRC    ;
	delete [] out_BRANCH_EVENT_ADDRESS_DEST   ;
	
	// ~~~~~[ Interface : "update" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	delete [] out_UPDATE_VAL                  ;
	delete []  in_UPDATE_ACK                  ;
	if (_param->_have_port_context_id)
	delete [] out_UPDATE_CONTEXT_ID           ;
	delete [] out_UPDATE_MISS_PREDICTION      ;
	delete [] out_UPDATE_DIRECTION_GOOD       ;
	delete [] out_UPDATE_BTB_VAL              ;
	delete [] out_UPDATE_BTB_ADDRESS_SRC      ;
	delete [] out_UPDATE_BTB_ADDRESS_DEST     ;
	delete [] out_UPDATE_BTB_CONDITION        ;
	delete [] out_UPDATE_DIR_VAL              ;
	if (_param->_have_port_history)
	delete [] out_UPDATE_DIR_HISTORY          ;
	delete [] out_UPDATE_RAS_VAL              ;
	delete [] out_UPDATE_RAS_PUSH             ;
	delete [] out_UPDATE_RAS_ADDRESS          ;
	delete [] out_UPDATE_RAS_INDEX            ;
	delete [] out_UPDATE_RAS_PREDICTION_IFETCH;

	// ~~~~~[ Interface : "depth" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	if (_param->_have_port_max_depth)
	  {
	delete [] out_DEPTH_NB_BRANCH;
	delete [] out_DEPTH_TAIL;
	  }
      }

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    delete [] internal_PREDICT_ACK                     ;
    delete [] internal_DECOD_ACK                       ;
    delete [] internal_BRANCH_COMPLETE_ACK             ;
    delete [] internal_BRANCH_COMPLETE_MISS_PREDICTION ;
    delete [] internal_BRANCH_COMPLETE_TAKE            ;
    delete [] internal_BRANCH_COMPLETE_ADDRESS_DEST    ;
    delete [] internal_BRANCH_EVENT_VAL                ;
    delete [] internal_BRANCH_EVENT_DEPTH              ;
    delete [] internal_UPDATE_VAL                      ;
    delete [] internal_UPDATE_CONTEXT_ID               ;
    delete [] internal_UPDATE_DEPTH                    ;

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    delete [] reg_TOP;
    delete [] reg_BOTTOM;
    delete [] reg_NB_ELT;
    delete [] reg_NB_ELT_UPDATE;
    delete [] reg_NB_ELT_NEED_UPDATE;
    for (uint32_t i=0; i<_param->_nb_context; i++)
      delete [] reg_UPDATE_PREDICTION_TABLE [i];
    delete [] reg_UPDATE_PREDICTION_TABLE;

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    delete _component;

    log_printf(FUNC,Update_Prediction_Table,FUNCTION,"End");
  };

}; // end namespace update_prediction_table
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
