/*
 * $Id: Prediction_unit_deallocation.cpp 82 2008-05-01 16:48:45Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/include/Prediction_unit.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {


#undef  FUNCTION
#define FUNCTION "Prediction_unit::deallocation"
  void Prediction_unit::deallocation (void)
  {
    log_printf(FUNC,Prediction_unit,FUNCTION,"Begin");

    if (_usage & USE_SYSTEMC)
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

	DELETE1_SIGNAL( in_PREDICT_VAL                        ,_param->_nb_context,1);
	DELETE1_SIGNAL(out_PREDICT_ACK                        ,_param->_nb_context,1);
	DELETE1_SIGNAL( in_PREDICT_PC_PREVIOUS                ,_param->_nb_context,_param->_size_address);
	DELETE1_SIGNAL( in_PREDICT_PC_CURRENT                 ,_param->_nb_context,_param->_size_address);
	DELETE1_SIGNAL( in_PREDICT_PC_CURRENT_IS_DS_TAKE      ,_param->_nb_context,1);
	DELETE1_SIGNAL(out_PREDICT_PC_NEXT                    ,_param->_nb_context,_param->_size_address);
	DELETE1_SIGNAL(out_PREDICT_PC_NEXT_IS_DS_TAKE         ,_param->_nb_context,1);
	DELETE1_SIGNAL(out_PREDICT_INST_IFETCH_PTR            ,_param->_nb_context,_param->_size_inst_ifetch_ptr [alloc_signal_it1]);
	DELETE1_SIGNAL(out_PREDICT_BRANCH_STATE               ,_param->_nb_context,_param->_size_branch_state);
	DELETE1_SIGNAL(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID,_param->_nb_context,_param->_size_depth [alloc_signal_it1]);

	DELETE2_SIGNAL(out_PREDICT_INSTRUCTION_ENABLE       ,_param->_nb_context,_param->_nb_instruction[alloc_signal_it1],1);
	DELETE2_SIGNAL( in_DECOD_VAL                        ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1],1);
	DELETE2_SIGNAL(out_DECOD_ACK                        ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1],1);
	DELETE2_SIGNAL( in_DECOD_CONTEXT_ID                 ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1],_param->_size_context_id      );
	DELETE2_SIGNAL( in_DECOD_MATCH_INST_IFETCH_PTR      ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1],1                             );
	DELETE2_SIGNAL( in_DECOD_BRANCH_STATE               ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1],_param->_size_branch_state    );
	DELETE2_SIGNAL( in_DECOD_BRANCH_UPDATE_PREDICTION_ID,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1],_param->_max_size_depth       );
	DELETE2_SIGNAL( in_DECOD_BRANCH_CONDITION           ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1],_param->_size_branch_condition);
	DELETE2_SIGNAL( in_DECOD_BRANCH_DIRECTION           ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1],1                             );
	DELETE2_SIGNAL( in_DECOD_ADDRESS_SRC                ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1],_param->_size_address         );
	DELETE2_SIGNAL( in_DECOD_ADDRESS_DEST               ,_param->_nb_decod_unit,_param->_nb_inst_decod[alloc_signal_it1],_param->_size_address         );
      
        DELETE1_SIGNAL( in_BRANCH_COMPLETE_VAL            ,_param->_nb_inst_branch_complete,1);
        DELETE1_SIGNAL(out_BRANCH_COMPLETE_ACK            ,_param->_nb_inst_branch_complete,1);
        DELETE1_SIGNAL( in_BRANCH_COMPLETE_CONTEXT_ID     ,_param->_nb_inst_branch_complete,_param->_size_context_id);
        DELETE1_SIGNAL( in_BRANCH_COMPLETE_DEPTH          ,_param->_nb_inst_branch_complete,_param->_max_size_depth);
        DELETE1_SIGNAL( in_BRANCH_COMPLETE_ADDRESS        ,_param->_nb_inst_branch_complete,_param->_size_address);
        DELETE1_SIGNAL( in_BRANCH_COMPLETE_FLAG           ,_param->_nb_inst_branch_complete,1);
        DELETE1_SIGNAL(out_BRANCH_COMPLETE_MISS_PREDICTION,_param->_nb_inst_branch_complete,1);
        DELETE1_SIGNAL(out_BRANCH_COMPLETE_TAKE           ,_param->_nb_inst_branch_complete,1);
        DELETE1_SIGNAL(out_BRANCH_COMPLETE_ADDRESS_SRC    ,_param->_nb_inst_branch_complete,_param->_size_address);
        DELETE1_SIGNAL(out_BRANCH_COMPLETE_ADDRESS_DEST   ,_param->_nb_inst_branch_complete,_param->_size_address);

        DELETE1_SIGNAL(out_BRANCH_EVENT_VAL            ,_param->_nb_context,1);
        DELETE1_SIGNAL( in_BRANCH_EVENT_ACK            ,_param->_nb_context,1);
//      DELETE1_SIGNAL(out_BRANCH_EVENT_CONTEXT_ID     ,_param->_nb_context,_param->_size_context_id);
//      DELETE1_SIGNAL(out_BRANCH_EVENT_DEPTH          ,_param->_nb_context,_param->_max_size_depth);
//      DELETE1_SIGNAL(out_BRANCH_EVENT_MISS_PREDICTION,_param->_nb_context,1);
        DELETE1_SIGNAL(out_BRANCH_EVENT_ADDRESS_SRC    ,_param->_nb_context,_param->_size_address);
        DELETE1_SIGNAL(out_BRANCH_EVENT_ADDRESS_DEST   ,_param->_nb_context,_param->_size_address);

        DELETE1_SIGNAL(out_DEPTH_NB_BRANCH    ,_param->_nb_context,_param->_size_depth[alloc_signal_it1]+1);
        DELETE1_SIGNAL(out_DEPTH_TAIL         ,_param->_nb_context,_param->_size_depth[alloc_signal_it1]);
      }
    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    delete _component;

    delete _component_btb;
    delete _component_dir;
    delete _component_ras;
    delete _component_upt;
    delete _component_glue;

    log_printf(FUNC,Prediction_unit,FUNCTION,"End");
  };

}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
