#ifndef morpheo_behavioural_core_multi_ooo_engine_ooo_engine_rename_unit_register_translation_unit_free_list_unit_Free_List_unit_h
#define morpheo_behavioural_core_multi_ooo_engine_ooo_engine_rename_unit_register_translation_unit_free_list_unit_Free_List_unit_h

/*
 * $Id: Free_List_unit.h 82 2008-05-01 16:48:45Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include <list>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"
#include "Behavioural/include/Types.h"

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Free_List_unit/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace free_list_unit {


  class Free_List_unit 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK          ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET         ;

    // ~~~~~[ interface : "pop" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t)           **  in_POP_VAL        ;
  public    : SC_OUT(Tcontrol_t)           ** out_POP_ACK        ;
  public    : SC_IN (Tcontrol_t        )   **  in_POP_GPR_VAL    ; // write_rd
  public    : SC_OUT(Tgeneral_address_t)   ** out_POP_GPR_NUM_REG; // num_reg_rd
  public    : SC_IN (Tcontrol_t        )   **  in_POP_SPR_VAL    ; // write_re
  public    : SC_OUT(Tspecial_address_t)   ** out_POP_SPR_NUM_REG; // num_reg_re

    // ~~~~~[ interface : "push_gpr" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t)           **  in_PUSH_GPR_VAL    ; // gpr_free (cf stat_list)
  public    : SC_OUT(Tcontrol_t)           ** out_PUSH_GPR_ACK    ;
  public    : SC_IN (Tgeneral_address_t)   **  in_PUSH_GPR_NUM_REG;

    // ~~~~~[ interface : "push_spr" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t)           **  in_PUSH_SPR_VAL    ; // spr_free (cf stat_list)
  public    : SC_OUT(Tcontrol_t)           ** out_PUSH_SPR_ACK    ;
  public    : SC_IN (Tspecial_address_t)   **  in_PUSH_SPR_NUM_REG;

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  private   : std::list<Tgeneral_address_t> * _gpr_list; //[nb_bank]
  private   : std::list<Tspecial_address_t> * _spr_list; //[nb_bank]

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  private   : uint32_t                        internal_BANK_PRIORITY;

  private   : Tcontrol_t                    * internal_POP_ACK      ; //[nb_pop]
  private   : uint32_t                      * internal_POP_GPR_BANK ; //[nb_pop]
  private   : uint32_t                      * internal_POP_SPR_BANK ; //[nb_pop]

  private   : Tcontrol_t                    * internal_PUSH_GPR_ACK ; //[nb_push]
  private   : Tcontrol_t                    * internal_PUSH_SPR_ACK ; //[nb_push]
  private   : uint32_t                      * internal_PUSH_GPR_BANK; //[nb_push]
  private   : uint32_t                      * internal_PUSH_SPR_BANK; //[nb_push]
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Free_List_unit);
#endif
  public  :          Free_List_unit              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Free_List_unit             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
  public  : void        transition                (void);
  public  : void        genMealy_pop              (void);
  public  : void        genMealy_push_gpr         (void);
  public  : void        genMealy_push_spr         (void);
#endif

#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_declaration    (morpheo::behavioural::Parameters_Statistics * param_statistics);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace free_list_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
