/*
 * $Id: test.cpp 82 2008-05-01 16:48:45Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#define NB_ITERATION  1
#define CYCLE_MAX     (128*NB_ITERATION)

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/SelfTest/include/test.h"
#include "Common/include/Test.h"
#include "Behavioural/include/Allocation.h"


void test (string name,
	   morpheo::behavioural::core::multi_execute_loop::execute_loop::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Execute_loop * _Execute_loop = new Execute_loop 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     USE_ALL);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");
  
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_VAL                  ," in_EXECUTE_LOOP_IN_VAL                  ",Tcontrol_t        ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL(out_EXECUTE_LOOP_IN_ACK                  ,"out_EXECUTE_LOOP_IN_ACK                  ",Tcontrol_t        ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_CONTEXT_ID           ," in_EXECUTE_LOOP_IN_CONTEXT_ID           ",Tcontext_t        ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_FRONT_END_ID         ," in_EXECUTE_LOOP_IN_FRONT_END_ID         ",Tcontext_t        ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_OOO_ENGINE_ID        ," in_EXECUTE_LOOP_IN_OOO_ENGINE_ID        ",Tcontext_t        ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_PACKET_ID            ," in_EXECUTE_LOOP_IN_PACKET_ID            ",Tpacket_t         ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_OPERATION            ," in_EXECUTE_LOOP_IN_OPERATION            ",Toperation_t      ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_TYPE                 ," in_EXECUTE_LOOP_IN_TYPE                 ",Ttype_t           ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_STORE_QUEUE_PTR_WRITE," in_EXECUTE_LOOP_IN_STORE_QUEUE_PTR_WRITE",Tlsq_ptr_t        ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_LOAD_QUEUE_PTR_WRITE ," in_EXECUTE_LOOP_IN_LOAD_QUEUE_PTR_WRITE ",Tlsq_ptr_t        ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_HAS_IMMEDIAT         ," in_EXECUTE_LOOP_IN_HAS_IMMEDIAT         ",Tcontrol_t        ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_IMMEDIAT             ," in_EXECUTE_LOOP_IN_IMMEDIAT             ",Tgeneral_data_t   ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_READ_RA              ," in_EXECUTE_LOOP_IN_READ_RA              ",Tcontrol_t        ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_NUM_REG_RA           ," in_EXECUTE_LOOP_IN_NUM_REG_RA           ",Tgeneral_address_t,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_READ_RB              ," in_EXECUTE_LOOP_IN_READ_RB              ",Tcontrol_t        ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_NUM_REG_RB           ," in_EXECUTE_LOOP_IN_NUM_REG_RB           ",Tgeneral_address_t,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_READ_RC              ," in_EXECUTE_LOOP_IN_READ_RC              ",Tcontrol_t        ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_NUM_REG_RC           ," in_EXECUTE_LOOP_IN_NUM_REG_RC           ",Tspecial_address_t,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_WRITE_RD             ," in_EXECUTE_LOOP_IN_WRITE_RD             ",Tcontrol_t        ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_NUM_REG_RD           ," in_EXECUTE_LOOP_IN_NUM_REG_RD           ",Tgeneral_address_t,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_WRITE_RE             ," in_EXECUTE_LOOP_IN_WRITE_RE             ",Tcontrol_t        ,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_IN_NUM_REG_RE           ," in_EXECUTE_LOOP_IN_NUM_REG_RE           ",Tspecial_address_t,_param->_nb_read_unit);
  ALLOC1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_VAL                 ,"out_EXECUTE_LOOP_OUT_VAL                 ",Tcontrol_t        ,_param->_nb_write_unit);
  ALLOC1_SC_SIGNAL( in_EXECUTE_LOOP_OUT_ACK                 ," in_EXECUTE_LOOP_OUT_ACK                 ",Tcontrol_t        ,_param->_nb_write_unit);
  ALLOC1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_CONTEXT_ID          ,"out_EXECUTE_LOOP_OUT_CONTEXT_ID          ",Tcontext_t        ,_param->_nb_write_unit);
  ALLOC1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_FRONT_END_ID        ,"out_EXECUTE_LOOP_OUT_FRONT_END_ID        ",Tcontext_t        ,_param->_nb_write_unit);
  ALLOC1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_OOO_ENGINE_ID       ,"out_EXECUTE_LOOP_OUT_OOO_ENGINE_ID       ",Tcontext_t        ,_param->_nb_write_unit);
  ALLOC1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_PACKET_ID           ,"out_EXECUTE_LOOP_OUT_PACKET_ID           ",Tpacket_t         ,_param->_nb_write_unit);
//ALLOC1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_OPERATION           ,"out_EXECUTE_LOOP_OUT_OPERATION           ",Toperation_t      ,_param->_nb_write_unit);
//ALLOC1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_TYPE                ,"out_EXECUTE_LOOP_OUT_TYPE                ",Ttype_t           ,_param->_nb_write_unit);
  ALLOC1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_FLAGS               ,"out_EXECUTE_LOOP_OUT_FLAGS               ",Tspecial_data_t   ,_param->_nb_write_unit);
  ALLOC1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_EXCEPTION           ,"out_EXECUTE_LOOP_OUT_EXCEPTION           ",Texception_t      ,_param->_nb_write_unit);
  ALLOC1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_NO_SEQUENCE         ,"out_EXECUTE_LOOP_OUT_NO_SEQUENCE         ",Tcontrol_t        ,_param->_nb_write_unit);
  ALLOC1_SC_SIGNAL(out_EXECUTE_LOOP_OUT_ADDRESS             ,"out_EXECUTE_LOOP_OUT_ADDRESS             ",Tgeneral_data_t   ,_param->_nb_write_unit);
  ALLOC1_SC_SIGNAL(out_DCACHE_REQ_VAL                       ,"out_DCACHE_REQ_VAL                       ",Tcontrol_t        ,_param->_nb_load_store_unit);
  ALLOC1_SC_SIGNAL( in_DCACHE_REQ_ACK                       ," in_DCACHE_REQ_ACK                       ",Tcontrol_t        ,_param->_nb_load_store_unit);
  ALLOC1_SC_SIGNAL(out_DCACHE_REQ_CONTEXT_ID                ,"out_DCACHE_REQ_CONTEXT_ID                ",Tcontext_t        ,_param->_nb_load_store_unit);
  ALLOC1_SC_SIGNAL(out_DCACHE_REQ_PACKET_ID                 ,"out_DCACHE_REQ_PACKET_ID                 ",Tpacket_t         ,_param->_nb_load_store_unit);
  ALLOC1_SC_SIGNAL(out_DCACHE_REQ_ADDRESS                   ,"out_DCACHE_REQ_ADDRESS                   ",Tdcache_address_t ,_param->_nb_load_store_unit);
  ALLOC1_SC_SIGNAL(out_DCACHE_REQ_TYPE                      ,"out_DCACHE_REQ_TYPE                      ",Tdcache_type_t    ,_param->_nb_load_store_unit);
  ALLOC1_SC_SIGNAL(out_DCACHE_REQ_WDATA                     ,"out_DCACHE_REQ_WDATA                     ",Tdcache_data_t    ,_param->_nb_load_store_unit);
  ALLOC1_SC_SIGNAL( in_DCACHE_RSP_VAL                       ," in_DCACHE_RSP_VAL                       ",Tcontrol_t        ,_param->_nb_load_store_unit);
  ALLOC1_SC_SIGNAL(out_DCACHE_RSP_ACK                       ,"out_DCACHE_RSP_ACK                       ",Tcontrol_t        ,_param->_nb_load_store_unit);
  ALLOC1_SC_SIGNAL( in_DCACHE_RSP_CONTEXT_ID                ," in_DCACHE_RSP_CONTEXT_ID                ",Tcontext_t        ,_param->_nb_load_store_unit);
  ALLOC1_SC_SIGNAL( in_DCACHE_RSP_PACKET_ID                 ," in_DCACHE_RSP_PACKET_ID                 ",Tpacket_t         ,_param->_nb_load_store_unit);
  ALLOC1_SC_SIGNAL( in_DCACHE_RSP_RDATA                     ," in_DCACHE_RSP_RDATA                     ",Tdcache_data_t    ,_param->_nb_load_store_unit);
  ALLOC1_SC_SIGNAL( in_DCACHE_RSP_ERROR                     ," in_DCACHE_RSP_ERROR                     ",Tdcache_error_t   ,_param->_nb_load_store_unit); 
  ALLOC2_SC_SIGNAL( in_INSERT_ROB_VAL                       ," in_INSERT_ROB_VAL                       ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[alloc_signal_it1]);
  ALLOC2_SC_SIGNAL(out_INSERT_ROB_ACK                       ,"out_INSERT_ROB_ACK                       ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[alloc_signal_it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_ROB_RD_USE                    ," in_INSERT_ROB_RD_USE                    ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[alloc_signal_it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_ROB_RD_NUM_REG                ," in_INSERT_ROB_RD_NUM_REG                ",Tgeneral_address_t,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[alloc_signal_it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_ROB_RE_USE                    ," in_INSERT_ROB_RE_USE                    ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[alloc_signal_it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_ROB_RE_NUM_REG                ," in_INSERT_ROB_RE_NUM_REG                ",Tspecial_address_t,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[alloc_signal_it1]);
  ALLOC2_SC_SIGNAL( in_RETIRE_ROB_VAL                       ," in_RETIRE_ROB_VAL                       ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[alloc_signal_it1]);
  ALLOC2_SC_SIGNAL(out_RETIRE_ROB_ACK                       ,"out_RETIRE_ROB_ACK                       ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[alloc_signal_it1]);
  ALLOC2_SC_SIGNAL( in_RETIRE_ROB_RD_OLD_USE                ," in_RETIRE_ROB_RD_OLD_USE                ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[alloc_signal_it1]); 
  ALLOC2_SC_SIGNAL( in_RETIRE_ROB_RD_OLD_NUM_REG            ," in_RETIRE_ROB_RD_OLD_NUM_REG            ",Tgeneral_address_t,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[alloc_signal_it1]);
  ALLOC2_SC_SIGNAL( in_RETIRE_ROB_RD_NEW_USE                ," in_RETIRE_ROB_RD_NEW_USE                ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[alloc_signal_it1]);
  ALLOC2_SC_SIGNAL( in_RETIRE_ROB_RD_NEW_NUM_REG            ," in_RETIRE_ROB_RD_NEW_NUM_REG            ",Tgeneral_address_t,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[alloc_signal_it1]);
  ALLOC2_SC_SIGNAL( in_RETIRE_ROB_RE_OLD_USE                ," in_RETIRE_ROB_RE_OLD_USE                ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[alloc_signal_it1]); 
  ALLOC2_SC_SIGNAL( in_RETIRE_ROB_RE_OLD_NUM_REG            ," in_RETIRE_ROB_RE_OLD_NUM_REG            ",Tspecial_address_t,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[alloc_signal_it1]);
  ALLOC2_SC_SIGNAL( in_RETIRE_ROB_RE_NEW_USE                ," in_RETIRE_ROB_RE_NEW_USE                ",Tcontrol_t        ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[alloc_signal_it1]);
  ALLOC2_SC_SIGNAL( in_RETIRE_ROB_RE_NEW_NUM_REG            ," in_RETIRE_ROB_RE_NEW_NUM_REG            ",Tspecial_address_t,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[alloc_signal_it1]);
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Execute_loop.\n"),name.c_str());

  (*(_Execute_loop->in_CLOCK))        (*(in_CLOCK));
  (*(_Execute_loop->in_NRESET))       (*(in_NRESET));

  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_VAL                  ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop,out_EXECUTE_LOOP_IN_ACK                  ,_param->_nb_read_unit);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_CONTEXT_ID           ,_param->_nb_read_unit);
  if (_param->_have_port_front_end_id)
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_FRONT_END_ID         ,_param->_nb_read_unit);
  if (_param->_have_port_ooo_engine_id)
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_OOO_ENGINE_ID        ,_param->_nb_read_unit);
  if (_param->_have_port_packet_id)
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_PACKET_ID            ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_OPERATION            ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_TYPE                 ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_STORE_QUEUE_PTR_WRITE,_param->_nb_read_unit);
  if (_param->_have_port_load_queue_ptr)
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_LOAD_QUEUE_PTR_WRITE ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_HAS_IMMEDIAT         ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_IMMEDIAT             ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_READ_RA              ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_NUM_REG_RA           ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_READ_RB              ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_NUM_REG_RB           ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_READ_RC              ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_NUM_REG_RC           ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_WRITE_RD             ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_NUM_REG_RD           ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_WRITE_RE             ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_IN_NUM_REG_RE           ,_param->_nb_read_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop,out_EXECUTE_LOOP_OUT_VAL                 ,_param->_nb_write_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_EXECUTE_LOOP_OUT_ACK                 ,_param->_nb_write_unit);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Execute_loop,out_EXECUTE_LOOP_OUT_CONTEXT_ID          ,_param->_nb_write_unit);
  if (_param->_have_port_front_end_id)
  INSTANCE1_SC_SIGNAL(_Execute_loop,out_EXECUTE_LOOP_OUT_FRONT_END_ID        ,_param->_nb_write_unit);
  if (_param->_have_port_ooo_engine_id)
  INSTANCE1_SC_SIGNAL(_Execute_loop,out_EXECUTE_LOOP_OUT_OOO_ENGINE_ID       ,_param->_nb_write_unit);
  if (_param->_have_port_packet_id)
  INSTANCE1_SC_SIGNAL(_Execute_loop,out_EXECUTE_LOOP_OUT_PACKET_ID           ,_param->_nb_write_unit);
//INSTANCE1_SC_SIGNAL(_Execute_loop,out_EXECUTE_LOOP_OUT_OPERATION           ,_param->_nb_write_unit);
//INSTANCE1_SC_SIGNAL(_Execute_loop,out_EXECUTE_LOOP_OUT_TYPE                ,_param->_nb_write_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop,out_EXECUTE_LOOP_OUT_FLAGS               ,_param->_nb_write_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop,out_EXECUTE_LOOP_OUT_EXCEPTION           ,_param->_nb_write_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop,out_EXECUTE_LOOP_OUT_NO_SEQUENCE         ,_param->_nb_write_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop,out_EXECUTE_LOOP_OUT_ADDRESS             ,_param->_nb_write_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop,out_DCACHE_REQ_VAL                       ,_param->_nb_load_store_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_DCACHE_REQ_ACK                       ,_param->_nb_load_store_unit);
  if (_param->_have_port_dcache_context_id)
  INSTANCE1_SC_SIGNAL(_Execute_loop,out_DCACHE_REQ_CONTEXT_ID                ,_param->_nb_load_store_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop,out_DCACHE_REQ_PACKET_ID                 ,_param->_nb_load_store_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop,out_DCACHE_REQ_ADDRESS                   ,_param->_nb_load_store_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop,out_DCACHE_REQ_TYPE                      ,_param->_nb_load_store_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop,out_DCACHE_REQ_WDATA                     ,_param->_nb_load_store_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_DCACHE_RSP_VAL                       ,_param->_nb_load_store_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop,out_DCACHE_RSP_ACK                       ,_param->_nb_load_store_unit);
  if (_param->_have_port_dcache_context_id)
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_DCACHE_RSP_CONTEXT_ID                ,_param->_nb_load_store_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_DCACHE_RSP_PACKET_ID                 ,_param->_nb_load_store_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_DCACHE_RSP_RDATA                     ,_param->_nb_load_store_unit);
  INSTANCE1_SC_SIGNAL(_Execute_loop, in_DCACHE_RSP_ERROR                     ,_param->_nb_load_store_unit); 
  INSTANCE2_SC_SIGNAL(_Execute_loop, in_INSERT_ROB_VAL                       ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[alloc_signal_it1]);
  INSTANCE2_SC_SIGNAL(_Execute_loop,out_INSERT_ROB_ACK                       ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[alloc_signal_it1]);
  INSTANCE2_SC_SIGNAL(_Execute_loop, in_INSERT_ROB_RD_USE                    ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[alloc_signal_it1]);
  INSTANCE2_SC_SIGNAL(_Execute_loop, in_INSERT_ROB_RD_NUM_REG                ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[alloc_signal_it1]);
  INSTANCE2_SC_SIGNAL(_Execute_loop, in_INSERT_ROB_RE_USE                    ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[alloc_signal_it1]);
  INSTANCE2_SC_SIGNAL(_Execute_loop, in_INSERT_ROB_RE_NUM_REG                ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob[alloc_signal_it1]);
  INSTANCE2_SC_SIGNAL(_Execute_loop, in_RETIRE_ROB_VAL                       ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[alloc_signal_it1]);
  INSTANCE2_SC_SIGNAL(_Execute_loop,out_RETIRE_ROB_ACK                       ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[alloc_signal_it1]);
  INSTANCE2_SC_SIGNAL(_Execute_loop, in_RETIRE_ROB_RD_OLD_USE                ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[alloc_signal_it1]); 
  INSTANCE2_SC_SIGNAL(_Execute_loop, in_RETIRE_ROB_RD_OLD_NUM_REG            ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[alloc_signal_it1]);
  INSTANCE2_SC_SIGNAL(_Execute_loop, in_RETIRE_ROB_RD_NEW_USE                ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[alloc_signal_it1]);
  INSTANCE2_SC_SIGNAL(_Execute_loop, in_RETIRE_ROB_RD_NEW_NUM_REG            ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[alloc_signal_it1]);
  INSTANCE2_SC_SIGNAL(_Execute_loop, in_RETIRE_ROB_RE_OLD_USE                ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[alloc_signal_it1]); 
  INSTANCE2_SC_SIGNAL(_Execute_loop, in_RETIRE_ROB_RE_OLD_NUM_REG            ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[alloc_signal_it1]);
  INSTANCE2_SC_SIGNAL(_Execute_loop, in_RETIRE_ROB_RE_NEW_USE                ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[alloc_signal_it1]);
  INSTANCE2_SC_SIGNAL(_Execute_loop, in_RETIRE_ROB_RE_NEW_NUM_REG            ,_param->_nb_ooo_engine,_param->_nb_inst_retire_rob[alloc_signal_it1]);

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      SC_START(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  delete []  in_EXECUTE_LOOP_IN_VAL                  ;
  delete [] out_EXECUTE_LOOP_IN_ACK                  ;
  delete []  in_EXECUTE_LOOP_IN_CONTEXT_ID           ;
  delete []  in_EXECUTE_LOOP_IN_FRONT_END_ID         ;
  delete []  in_EXECUTE_LOOP_IN_OOO_ENGINE_ID        ;
  delete []  in_EXECUTE_LOOP_IN_PACKET_ID            ;
  delete []  in_EXECUTE_LOOP_IN_OPERATION            ;
  delete []  in_EXECUTE_LOOP_IN_TYPE                 ;
  delete []  in_EXECUTE_LOOP_IN_STORE_QUEUE_PTR_WRITE;
  delete []  in_EXECUTE_LOOP_IN_LOAD_QUEUE_PTR_WRITE ;
  delete []  in_EXECUTE_LOOP_IN_HAS_IMMEDIAT         ;
  delete []  in_EXECUTE_LOOP_IN_IMMEDIAT             ;
  delete []  in_EXECUTE_LOOP_IN_READ_RA              ;
  delete []  in_EXECUTE_LOOP_IN_NUM_REG_RA           ;
  delete []  in_EXECUTE_LOOP_IN_READ_RB              ;
  delete []  in_EXECUTE_LOOP_IN_NUM_REG_RB           ;
  delete []  in_EXECUTE_LOOP_IN_READ_RC              ;
  delete []  in_EXECUTE_LOOP_IN_NUM_REG_RC           ;
  delete []  in_EXECUTE_LOOP_IN_WRITE_RD             ;
  delete []  in_EXECUTE_LOOP_IN_NUM_REG_RD           ;
  delete []  in_EXECUTE_LOOP_IN_WRITE_RE             ;
  delete []  in_EXECUTE_LOOP_IN_NUM_REG_RE           ;
  delete [] out_EXECUTE_LOOP_OUT_VAL                 ;
  delete []  in_EXECUTE_LOOP_OUT_ACK                 ;
  delete [] out_EXECUTE_LOOP_OUT_CONTEXT_ID          ;
  delete [] out_EXECUTE_LOOP_OUT_FRONT_END_ID        ;
  delete [] out_EXECUTE_LOOP_OUT_OOO_ENGINE_ID       ;
  delete [] out_EXECUTE_LOOP_OUT_PACKET_ID           ;
//delete [] out_EXECUTE_LOOP_OUT_OPERATION           ;
//delete [] out_EXECUTE_LOOP_OUT_TYPE                ;
  delete [] out_EXECUTE_LOOP_OUT_FLAGS               ;
  delete [] out_EXECUTE_LOOP_OUT_EXCEPTION           ;
  delete [] out_EXECUTE_LOOP_OUT_NO_SEQUENCE         ;
  delete [] out_EXECUTE_LOOP_OUT_ADDRESS             ;
  delete [] out_DCACHE_REQ_VAL                       ;
  delete []  in_DCACHE_REQ_ACK                       ;
  delete [] out_DCACHE_REQ_CONTEXT_ID                ;
  delete [] out_DCACHE_REQ_PACKET_ID                 ;
  delete [] out_DCACHE_REQ_ADDRESS                   ;
  delete [] out_DCACHE_REQ_TYPE                      ;
  delete [] out_DCACHE_REQ_WDATA                     ;
  delete []  in_DCACHE_RSP_VAL                       ;
  delete [] out_DCACHE_RSP_ACK                       ;
  delete []  in_DCACHE_RSP_CONTEXT_ID                ;
  delete []  in_DCACHE_RSP_PACKET_ID                 ;
  delete []  in_DCACHE_RSP_RDATA                     ;
  delete []  in_DCACHE_RSP_ERROR                     ;
  delete []  in_INSERT_ROB_VAL                       ;
  delete [] out_INSERT_ROB_ACK                       ;
  delete []  in_INSERT_ROB_RD_USE                    ;
  delete []  in_INSERT_ROB_RD_NUM_REG                ;
  delete []  in_INSERT_ROB_RE_USE                    ;
  delete []  in_INSERT_ROB_RE_NUM_REG                ;
  delete []  in_RETIRE_ROB_VAL                       ;
  delete [] out_RETIRE_ROB_ACK                       ;
  delete []  in_RETIRE_ROB_RD_OLD_USE                ; 
  delete []  in_RETIRE_ROB_RD_OLD_NUM_REG            ;
  delete []  in_RETIRE_ROB_RD_NEW_USE                ;
  delete []  in_RETIRE_ROB_RD_NEW_NUM_REG            ;
  delete []  in_RETIRE_ROB_RE_OLD_USE                ; 
  delete []  in_RETIRE_ROB_RE_OLD_NUM_REG            ;
  delete []  in_RETIRE_ROB_RE_NEW_USE                ;
  delete []  in_RETIRE_ROB_RE_NEW_NUM_REG            ;

#endif

  delete _Execute_loop;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
