#ifndef morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_branch_target_buffer_branch_target_buffer_register_Branch_Target_Buffer_Register_h
#define morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_branch_target_buffer_branch_target_buffer_register_Branch_Target_Buffer_Register_h

/*
 * $Id: Branch_Target_Buffer_Register.h 82 2008-05-01 16:48:45Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Branch_Target_Buffer/Branch_Target_Buffer_Register/include/Types.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Branch_Target_Buffer/Branch_Target_Buffer_Register/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace branch_target_buffer {
namespace branch_target_buffer_register {


  class Branch_Target_Buffer_Register 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t         )  **  in_PREDICT_VAL           ; //[nb_inst_predict]
  public    : SC_OUT(Tcontrol_t         )  ** out_PREDICT_ACK           ; //[nb_inst_predict]
  public    : SC_IN (Tcontext_t         )  **  in_PREDICT_CONTEXT_ID    ; //[nb_inst_predict]
  public    : SC_IN (Tgeneral_data_t    )  **  in_PREDICT_ADDRESS       ; //[nb_inst_predict]
  public    : SC_OUT(Tcontrol_t         ) *** out_PREDICT_HIT           ; //[nb_inst_predict][associativity]
  public    : SC_OUT(Tgeneral_data_t    ) *** out_PREDICT_ADDRESS_SRC   ; //[nb_inst_predict][associativity]
  public    : SC_OUT(Tgeneral_data_t    ) *** out_PREDICT_ADDRESS_DEST  ; //[nb_inst_predict][associativity]
  public    : SC_OUT(Tbranch_condition_t) *** out_PREDICT_CONDITION     ; //[nb_inst_predict][associativity]
  public    : SC_OUT(Tcontrol_t         ) *** out_PREDICT_LAST_TAKE     ; //[nb_inst_predict][associativity]
  public    : SC_OUT(Tcontrol_t         ) *** out_PREDICT_IS_ACCURATE   ; //[nb_inst_predict][associativity]

    // ~~~~~[ Interface : "decod" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t         )  **  in_DECOD_VAL             ; //[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_ACK             ; //[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_HIT             ; //[nb_inst_decod] // hit = don't need a victim
  public    : SC_OUT(Tptr_t             )  ** out_DECOD_HIT_INDEX       ; //[nb_inst_decod]
  public    : SC_IN (Tptr_t             )  **  in_DECOD_VICTIM          ; //[nb_inst_decod]
  public    : SC_IN (Tcontext_t         )  **  in_DECOD_CONTEXT_ID      ; //[nb_inst_decod]
  public    : SC_IN (Tgeneral_data_t    )  **  in_DECOD_ADDRESS_SRC     ; //[nb_inst_decod]
  public    : SC_IN (Tgeneral_data_t    )  **  in_DECOD_ADDRESS_DEST    ; //[nb_inst_decod]
  public    : SC_IN (Tbranch_condition_t)  **  in_DECOD_CONDITION       ; //[nb_inst_decod]
  public    : SC_IN (Tcontrol_t         )  **  in_DECOD_LAST_TAKE       ; //[nb_inst_decod]
  public    : SC_IN (Tcontrol_t         )  **  in_DECOD_MISS_PREDICTION ; //[nb_inst_decod]
  public    : SC_IN (Tcontrol_t         )  **  in_DECOD_IS_ACCURATE     ; //[nb_inst_decod]

    // ~~~~~[ Interface : "update" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t         )  **  in_UPDATE_VAL            ; //[nb_inst_update]
  public    : SC_OUT(Tcontrol_t         )  ** out_UPDATE_ACK            ; //[nb_inst_update]
  public    : SC_OUT(Tcontrol_t         )  ** out_UPDATE_HIT            ; //[nb_inst_update] // hit = don't need a victim
  public    : SC_OUT(Tptr_t             )  ** out_UPDATE_HIT_INDEX      ; //[nb_inst_update]
  public    : SC_IN (Tptr_t             )  **  in_UPDATE_VICTIM         ; //[nb_inst_update]
  public    : SC_IN (Tcontext_t         )  **  in_UPDATE_CONTEXT_ID     ; //[nb_inst_update]
  public    : SC_IN (Tgeneral_data_t    )  **  in_UPDATE_ADDRESS_SRC    ; //[nb_inst_update]
  public    : SC_IN (Tgeneral_data_t    )  **  in_UPDATE_ADDRESS_DEST   ; //[nb_inst_update]
  public    : SC_IN (Tbranch_condition_t)  **  in_UPDATE_CONDITION      ; //[nb_inst_update]
  public    : SC_IN (Tcontrol_t         )  **  in_UPDATE_LAST_TAKE      ; //[nb_inst_update]
  public    : SC_IN (Tcontrol_t         )  **  in_UPDATE_MISS_PREDICTION; //[nb_inst_update]
    
    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  private   : btb_entry_t                  ** reg_BTB; //[size_bank][associativity]

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  private   : Tcontrol_t                    * internal_DECOD_ACK       ;//[nb_inst_decod]
  private   : Tcontrol_t                    * internal_DECOD_HIT       ;//[nb_inst_decod]
  private   : uint32_t                      * internal_DECOD_NUM_BANK  ;//[nb_inst_decod]
  private   : uint32_t                      * internal_DECOD_NUM_ENTRY ;//[nb_inst_decod]

  private   : Tcontrol_t                    * internal_UPDATE_ACK      ;//[nb_inst_update]
  private   : Tcontrol_t                    * internal_UPDATE_HIT      ;//[nb_inst_update]
  private   : uint32_t                      * internal_UPDATE_NUM_BANK ;//[nb_inst_update]
  private   : uint32_t                      * internal_UPDATE_NUM_ENTRY;//[nb_inst_update]
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Branch_Target_Buffer_Register);
#endif
  public  :          Branch_Target_Buffer_Register              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Branch_Target_Buffer_Register             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
  public  : void        transition                (void);
  public  : void        genMealy_predict          (void);
  public  : void        genMealy_decod            (void);
  public  : void        genMealy_update           (void);
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_allocation     (morpheo::behavioural::Parameters_Statistics * param_statistics);
  public  : void        statistics_deallocation   (void);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace branch_target_buffer_register
}; // end namespace branch_target_buffer
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
