/*
 * $Id: test.cpp 82 2008-05-01 16:48:45Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#define NB_ITERATION  1
#define CYCLE_MAX     (128*NB_ITERATION)

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/SelfTest/include/test.h"
#include "Common/include/Test.h"
#include "Behavioural/include/Allocation.h"

void test (string name,
	   morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Ifetch_unit * _Ifetch_unit = new Ifetch_unit 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     USE_ALL);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC_SC_SIGNAL (out_ICACHE_REQ_VAL                     ,"out_ICACHE_REQ_VAL                     ",Tcontrol_t           );
  ALLOC_SC_SIGNAL ( in_ICACHE_REQ_ACK                     ," in_ICACHE_REQ_ACK                     ",Tcontrol_t           );
//ALLOC_SC_SIGNAL (out_ICACHE_REQ_THREAD_ID               ,"out_ICACHE_REQ_THREAD_ID               ",Tcontext_t           );
  ALLOC_SC_SIGNAL (out_ICACHE_REQ_PACKET_ID               ,"out_ICACHE_REQ_PACKET_ID               ",Tpacket_t            );
  ALLOC_SC_SIGNAL (out_ICACHE_REQ_ADDRESS                 ,"out_ICACHE_REQ_ADDRESS                 ",Ticache_instruction_t);
  ALLOC_SC_SIGNAL (out_ICACHE_REQ_TYPE                    ,"out_ICACHE_REQ_TYPE                    ",Ticache_type_t       );
  ALLOC_SC_SIGNAL ( in_ICACHE_RSP_VAL                     ," in_ICACHE_RSP_VAL                     ",Tcontrol_t           );
  ALLOC_SC_SIGNAL (out_ICACHE_RSP_ACK                     ,"out_ICACHE_RSP_ACK                     ",Tcontrol_t           );
//ALLOC_SC_SIGNAL ( in_ICACHE_RSP_THREAD_ID               ," in_ICACHE_RSP_THREAD_ID               ",Tcontext_t           );
  ALLOC_SC_SIGNAL ( in_ICACHE_RSP_PACKET_ID               ," in_ICACHE_RSP_PACKET_ID               ",Tpacket_t            );
  ALLOC1_SC_SIGNAL( in_ICACHE_RSP_INSTRUCTION             ," in_ICACHE_RSP_INSTRUCTION             ",Ticache_instruction_t,_param->_nb_instruction);
  ALLOC_SC_SIGNAL ( in_ICACHE_RSP_ERROR                   ," in_ICACHE_RSP_ERROR                   ",Ticache_error_t      );
  ALLOC_SC_SIGNAL (out_PREDICT_VAL                        ,"out_PREDICT_VAL                        ",Tcontrol_t           );
  ALLOC_SC_SIGNAL ( in_PREDICT_ACK                        ," in_PREDICT_ACK                        ",Tcontrol_t           );
  ALLOC_SC_SIGNAL (out_PREDICT_PC_PREVIOUS                ,"out_PREDICT_PC_PREVIOUS                ",Tgeneral_address_t   );
  ALLOC_SC_SIGNAL (out_PREDICT_PC_CURRENT                 ,"out_PREDICT_PC_CURRENT                 ",Tgeneral_address_t   );
  ALLOC_SC_SIGNAL (out_PREDICT_PC_CURRENT_IS_DS_TAKE      ,"out_PREDICT_PC_CURRENT_IS_DS_TAKE      ",Tcontrol_t           );
  ALLOC_SC_SIGNAL ( in_PREDICT_PC_NEXT                    ," in_PREDICT_PC_NEXT                    ",Tgeneral_address_t   );
  ALLOC_SC_SIGNAL ( in_PREDICT_PC_NEXT_IS_DS_TAKE         ," in_PREDICT_PC_NEXT_IS_DS_TAKE         ",Tcontrol_t           );
  ALLOC1_SC_SIGNAL( in_PREDICT_INSTRUCTION_ENABLE         ," in_PREDICT_INSTRUCTION_ENABLE         ",Tcontrol_t           ,_param->_nb_instruction);
  ALLOC_SC_SIGNAL ( in_PREDICT_INST_IFETCH_PTR            ," in_PREDICT_INST_IFETCH_PTR            ",Tinst_ifetch_ptr_t   );
  ALLOC_SC_SIGNAL ( in_PREDICT_BRANCH_STATE               ," in_PREDICT_BRANCH_STATE               ",Tbranch_state_t      );
  ALLOC_SC_SIGNAL ( in_PREDICT_BRANCH_UPDATE_PREDICTION_ID," in_PREDICT_BRANCH_UPDATE_PREDICTION_ID",Tprediction_ptr_t    );
  ALLOC1_SC_SIGNAL(out_DECOD_VAL                          ,"out_DECOD_VAL                          ",Tcontrol_t           ,_param->_nb_instruction);
  ALLOC1_SC_SIGNAL( in_DECOD_ACK                          ," in_DECOD_ACK                          ",Tcontrol_t           ,_param->_nb_instruction);
  ALLOC1_SC_SIGNAL(out_DECOD_INSTRUCTION                  ,"out_DECOD_INSTRUCTION                  ",Tinstruction_t       ,_param->_nb_instruction);
//ALLOC_SC_SIGNAL (out_DECOD_CONTEXT_ID                   ,"out_DECOD_CONTEXT_ID                   ",Tcontext_t           );
  ALLOC_SC_SIGNAL (out_DECOD_ADDRESS                      ,"out_DECOD_ADDRESS                      ",Tgeneral_address_t   );
  ALLOC_SC_SIGNAL (out_DECOD_INST_IFETCH_PTR              ,"out_DECOD_INST_IFETCH_PTR              ",Tinst_ifetch_ptr_t   );
  ALLOC_SC_SIGNAL (out_DECOD_BRANCH_STATE                 ,"out_DECOD_BRANCH_STATE                 ",Tbranch_state_t      );
  ALLOC_SC_SIGNAL (out_DECOD_BRANCH_UPDATE_PREDICTION_ID  ,"out_DECOD_BRANCH_UPDATE_PREDICTION_ID  ",Tprediction_ptr_t    );
  ALLOC_SC_SIGNAL (out_DECOD_EXCEPTION                    ,"out_DECOD_EXCEPTION                    ",Texception_t         );
  ALLOC_SC_SIGNAL ( in_EVENT_VAL                          ," in_EVENT_VAL                          ",Tcontrol_t           );
  ALLOC_SC_SIGNAL (out_EVENT_ACK                          ,"out_EVENT_ACK                          ",Tcontrol_t           );
  ALLOC_SC_SIGNAL ( in_EVENT_ADDRESS                      ," in_EVENT_ADDRESS                      ",Tgeneral_address_t   );
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Ifetch_unit.\n"),name.c_str());

  (*(_Ifetch_unit->in_CLOCK))        (*(in_CLOCK));
  (*(_Ifetch_unit->in_NRESET))       (*(in_NRESET));

  INSTANCE_SC_SIGNAL (_Ifetch_unit,out_ICACHE_REQ_VAL                     );
  INSTANCE_SC_SIGNAL (_Ifetch_unit, in_ICACHE_REQ_ACK                     );
//INSTANCE_SC_SIGNAL (_Ifetch_unit,out_ICACHE_REQ_THREAD_ID               );
  if (_param->_have_port_queue_ptr)
  INSTANCE_SC_SIGNAL (_Ifetch_unit,out_ICACHE_REQ_PACKET_ID               );
  INSTANCE_SC_SIGNAL (_Ifetch_unit,out_ICACHE_REQ_ADDRESS                 );
  INSTANCE_SC_SIGNAL (_Ifetch_unit,out_ICACHE_REQ_TYPE                    );
  INSTANCE_SC_SIGNAL (_Ifetch_unit, in_ICACHE_RSP_VAL                     );
  INSTANCE_SC_SIGNAL (_Ifetch_unit,out_ICACHE_RSP_ACK                     );
//INSTANCE_SC_SIGNAL (_Ifetch_unit, in_ICACHE_RSP_THREAD_ID               );
  if (_param->_have_port_queue_ptr)
  INSTANCE_SC_SIGNAL (_Ifetch_unit, in_ICACHE_RSP_PACKET_ID               );
  INSTANCE1_SC_SIGNAL(_Ifetch_unit, in_ICACHE_RSP_INSTRUCTION             ,_param->_nb_instruction);
  INSTANCE_SC_SIGNAL (_Ifetch_unit, in_ICACHE_RSP_ERROR                   );
  INSTANCE_SC_SIGNAL (_Ifetch_unit,out_PREDICT_VAL                        );
  INSTANCE_SC_SIGNAL (_Ifetch_unit, in_PREDICT_ACK                        );
  INSTANCE_SC_SIGNAL (_Ifetch_unit,out_PREDICT_PC_PREVIOUS                );
  INSTANCE_SC_SIGNAL (_Ifetch_unit,out_PREDICT_PC_CURRENT                 );
  INSTANCE_SC_SIGNAL (_Ifetch_unit,out_PREDICT_PC_CURRENT_IS_DS_TAKE      );
  INSTANCE_SC_SIGNAL (_Ifetch_unit, in_PREDICT_PC_NEXT                    );
  INSTANCE_SC_SIGNAL (_Ifetch_unit, in_PREDICT_PC_NEXT_IS_DS_TAKE         );
  INSTANCE1_SC_SIGNAL(_Ifetch_unit, in_PREDICT_INSTRUCTION_ENABLE         ,_param->_nb_instruction);
  if (_param->_have_port_instruction_ptr)
  INSTANCE_SC_SIGNAL (_Ifetch_unit, in_PREDICT_INST_IFETCH_PTR            );
  INSTANCE_SC_SIGNAL (_Ifetch_unit, in_PREDICT_BRANCH_STATE               );
  if (_param->_have_port_branch_update_prediction_id)
  INSTANCE_SC_SIGNAL (_Ifetch_unit, in_PREDICT_BRANCH_UPDATE_PREDICTION_ID);
  INSTANCE1_SC_SIGNAL(_Ifetch_unit,out_DECOD_VAL                          ,_param->_nb_instruction);
  INSTANCE1_SC_SIGNAL(_Ifetch_unit, in_DECOD_ACK                          ,_param->_nb_instruction);
  INSTANCE1_SC_SIGNAL(_Ifetch_unit,out_DECOD_INSTRUCTION                  ,_param->_nb_instruction);
//INSTANCE_SC_SIGNAL (_Ifetch_unit,out_DECOD_CONTEXT_ID                   );
  INSTANCE_SC_SIGNAL (_Ifetch_unit,out_DECOD_ADDRESS                      );
  if (_param->_have_port_instruction_ptr)
  INSTANCE_SC_SIGNAL (_Ifetch_unit,out_DECOD_INST_IFETCH_PTR              );
  INSTANCE_SC_SIGNAL (_Ifetch_unit,out_DECOD_BRANCH_STATE                 );
  if (_param->_have_port_branch_update_prediction_id)
  INSTANCE_SC_SIGNAL (_Ifetch_unit,out_DECOD_BRANCH_UPDATE_PREDICTION_ID  );
  INSTANCE_SC_SIGNAL (_Ifetch_unit,out_DECOD_EXCEPTION                    );
  INSTANCE_SC_SIGNAL (_Ifetch_unit, in_EVENT_VAL                          );
  INSTANCE_SC_SIGNAL (_Ifetch_unit,out_EVENT_ACK                          );
  INSTANCE_SC_SIGNAL (_Ifetch_unit, in_EVENT_ADDRESS                      );

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      SC_START(100);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  delete    out_ICACHE_REQ_VAL                      ;
  delete     in_ICACHE_REQ_ACK                      ;
//delete    out_ICACHE_REQ_THREAD_ID                ;
  delete    out_ICACHE_REQ_PACKET_ID                ;
  delete    out_ICACHE_REQ_ADDRESS                  ;
  delete    out_ICACHE_REQ_TYPE                     ;

  delete     in_ICACHE_RSP_VAL                      ;
  delete    out_ICACHE_RSP_ACK                      ;
//delete     in_ICACHE_RSP_THREAD_ID                ;
  delete     in_ICACHE_RSP_PACKET_ID                ;
  delete []  in_ICACHE_RSP_INSTRUCTION              ;
  delete     in_ICACHE_RSP_ERROR                    ;

  delete    out_PREDICT_VAL                         ;
  delete     in_PREDICT_ACK                         ;
  delete    out_PREDICT_PC_PREVIOUS                 ;
  delete    out_PREDICT_PC_CURRENT                  ;
  delete    out_PREDICT_PC_CURRENT_IS_DS_TAKE       ;
  delete     in_PREDICT_PC_NEXT                     ;
  delete     in_PREDICT_PC_NEXT_IS_DS_TAKE          ;
  delete []  in_PREDICT_INSTRUCTION_ENABLE          ;
  delete     in_PREDICT_INST_IFETCH_PTR             ;
  delete     in_PREDICT_BRANCH_STATE                ;
  delete     in_PREDICT_BRANCH_UPDATE_PREDICTION_ID ;

  delete [] out_DECOD_VAL                           ;
  delete []  in_DECOD_ACK                           ;
  delete [] out_DECOD_INSTRUCTION                   ;
//delete    out_DECOD_CONTEXT_ID                    ;
  delete    out_DECOD_ADDRESS                       ;
  delete    out_DECOD_INST_IFETCH_PTR               ;
  delete    out_DECOD_BRANCH_STATE                  ;
  delete    out_DECOD_BRANCH_UPDATE_PREDICTION_ID   ;
  delete    out_DECOD_EXCEPTION                     ;

  delete     in_EVENT_VAL                           ;
  delete    out_EVENT_ACK                           ;
  delete     in_EVENT_ADDRESS                       ;
#endif

  delete _Ifetch_unit;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
