#ifdef SYSTEMC
/*
 * $Id: Decod_queue_transition.cpp 82 2008-05-01 16:48:45Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod_queue/include/Decod_queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {
namespace decod_queue {


#undef  FUNCTION
#define FUNCTION "Decod_queue::transition"
  void Decod_queue::transition (void)
  {
    log_begin(Decod_queue,FUNCTION);

    if (PORT_READ(in_NRESET) == 0)
      {
	reg_QUEUE->clear();

	for (uint32_t i=0; i<_param->_nb_context; i++)
	  reg_NB_INST [i]=0;
      }
    else
      {
	//--------------------------------------------------------------------
	//-----[ DECOD_IN ]---------------------------------------------------
	//--------------------------------------------------------------------
	for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
	  {
	    decod_queue_entry_t * entry = NULL;
	    if (PORT_READ(in_DECOD_IN_VAL [i]) and internal_DECOD_IN_ACK[i])
	      {
		log_printf(TRACE,Decod_queue,FUNCTION,_("DECOD_IN  [%d]"),i);

		if (entry == NULL)
		  entry = new decod_queue_entry_t (_param->_nb_inst_decod);

		Tcontext_t context = (_param->_have_port_context_id)?PORT_READ(in_DECOD_IN_CONTEXT_ID [i]):0;

		log_printf(TRACE,Decod_queue,FUNCTION,_("  * context : %d"),context);

		entry->_val           [i] = 1;
		entry->_context_id    [i] = context;
		entry->_depth         [i] = (_param->_have_port_depth)?PORT_READ(in_DECOD_IN_DEPTH [i]):0;
		entry->_type          [i] = PORT_READ(in_DECOD_IN_TYPE          [i]);
		entry->_operation     [i] = PORT_READ(in_DECOD_IN_OPERATION     [i]);
		entry->_is_delay_slot [i] = PORT_READ(in_DECOD_IN_IS_DELAY_SLOT [i]);
		entry->_address       [i] = PORT_READ(in_DECOD_IN_ADDRESS       [i]);
		entry->_has_immediat  [i] = PORT_READ(in_DECOD_IN_HAS_IMMEDIAT  [i]);
		entry->_immediat      [i] = PORT_READ(in_DECOD_IN_IMMEDIAT      [i]);
		entry->_read_ra       [i] = PORT_READ(in_DECOD_IN_READ_RA       [i]);
		entry->_num_reg_ra    [i] = PORT_READ(in_DECOD_IN_NUM_REG_RA    [i]);
		entry->_read_rb       [i] = PORT_READ(in_DECOD_IN_READ_RB       [i]);
		entry->_num_reg_rb    [i] = PORT_READ(in_DECOD_IN_NUM_REG_RB    [i]);
		entry->_read_rc       [i] = PORT_READ(in_DECOD_IN_READ_RC       [i]);
		entry->_num_reg_rc    [i] = PORT_READ(in_DECOD_IN_NUM_REG_RC    [i]);
		entry->_write_rd      [i] = PORT_READ(in_DECOD_IN_WRITE_RD      [i]);
		entry->_num_reg_rd    [i] = PORT_READ(in_DECOD_IN_NUM_REG_RD    [i]);
		entry->_write_re      [i] = PORT_READ(in_DECOD_IN_WRITE_RE      [i]);
		entry->_num_reg_re    [i] = PORT_READ(in_DECOD_IN_NUM_REG_RE    [i]);
		entry->_exception_use [i] = PORT_READ(in_DECOD_IN_EXCEPTION_USE [i]);

		reg_NB_INST [context] ++;
		reg_QUEUE->push_back(entry);

		log_printf(TRACE,Decod_queue,FUNCTION,_("  * nb_inst : %d"),reg_NB_INST [context]);
		log_printf(TRACE,Decod_queue,FUNCTION,_("  * PUSH queue"));

	      }
	  }

	//--------------------------------------------------------------------
	//-----[ DECOD_OUT ]--------------------------------------------------
	//--------------------------------------------------------------------
	if (not reg_QUEUE->empty())
	  {
	    bool find = false;
	    
	    for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
	      {
		// Test transaction : if ok then invalid slot
		if (internal_DECOD_OUT_VAL [i] and internal_DECOD_OUT_ACK[i])
		  {
		    log_printf(TRACE,Decod_queue,FUNCTION,_("DECOD_OUT [%d]"),i);
		
		    reg_QUEUE->front()->_val [i] = 0;

		    Tcontext_t context = reg_QUEUE->front()->_context_id [i];
		    log_printf(TRACE,Decod_queue,FUNCTION,_("  * context : %d"),context);
		    
		    reg_NB_INST [context] --;
		    log_printf(TRACE,Decod_queue,FUNCTION,_("  * nb_inst : %d"),reg_NB_INST [context]);
		  }
		// Test if slot is (again) valid, if yes, then have less one instruction in the entry
		find |= reg_QUEUE->front()->_val [i];
	      }
	    
	    // test if can free the entry
	    if (not find) // no valid instruction in current slot
	      {
		log_printf(TRACE,Decod_queue,FUNCTION,_("  * POP  queue"));

		// can pop the slot
		delete reg_QUEUE->front();
		reg_QUEUE->pop_front();
	      }
	  }
      }
    
#ifdef STATISTICS
    for (uint32_t i=0; i<_param->_nb_context; i++)
      *(_stat_nb_inst [i]) += reg_NB_INST [i];
#endif

#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    end_cycle ();
#endif

    log_end(Decod_queue,FUNCTION);
  };

}; // end namespace decod_queue
}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
