/*
 * $Id: test.cpp 82 2008-05-01 16:48:45Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#define NB_ITERATION  1024
#define CYCLE_MAX     (128*NB_ITERATION)

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Direction_Glue/SelfTest/include/test.h"
#include "Common/include/Test.h"
#include "Common/include/BitManipulation.h"
#include "Behavioural/include/Allocation.h"

void test (string name,
	   morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::direction_glue::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Direction_Glue * _Direction_Glue = new Direction_Glue 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     USE_ALL);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC1_SC_SIGNAL( in_PREDICT_VAL                  ," in_PREDICT_VAL                  ",Tcontrol_t,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_ACK                  ,"out_PREDICT_ACK                  ",Tcontrol_t,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_ADDRESS_SRC          ," in_PREDICT_ADDRESS_SRC          ",Taddress_t,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_STATIC               ," in_PREDICT_STATIC               ",Tcontrol_t,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_LAST_TAKE            ," in_PREDICT_LAST_TAKE            ",Tcontrol_t,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_HISTORY              ,"out_PREDICT_HISTORY              ",Thistory_t,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_DIRECTION            ,"out_PREDICT_DIRECTION            ",Tcontrol_t,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_PREDICTOR_VAL        ,"out_PREDICT_PREDICTOR_VAL        ",Tcontrol_t,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_PREDICTOR_ACK        ," in_PREDICT_PREDICTOR_ACK        ",Tcontrol_t,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_PREDICTOR_ADDRESS_SRC,"out_PREDICT_PREDICTOR_ADDRESS_SRC",Taddress_t,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_PREDICTOR_HISTORY    ," in_PREDICT_PREDICTOR_HISTORY    ",Thistory_t,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_PREDICTOR_DIRECTION  ," in_PREDICT_PREDICTOR_DIRECTION  ",Tcontrol_t,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL( in_UPDATE_VAL                   ," in_UPDATE_VAL                   ",Tcontrol_t,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_ACK                   ,"out_UPDATE_ACK                   ",Tcontrol_t,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL( in_UPDATE_ADDRESS               ," in_UPDATE_ADDRESS               ",Taddress_t,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL( in_UPDATE_HISTORY               ," in_UPDATE_HISTORY               ",Thistory_t,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL( in_UPDATE_DIRECTION             ," in_UPDATE_DIRECTION             ",Tcontrol_t,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_PREDICTOR_VAL         ,"out_UPDATE_PREDICTOR_VAL         ",Tcontrol_t,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL( in_UPDATE_PREDICTOR_ACK         ," in_UPDATE_PREDICTOR_ACK         ",Tcontrol_t,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_PREDICTOR_ADDRESS     ,"out_UPDATE_PREDICTOR_ADDRESS     ",Taddress_t,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_PREDICTOR_HISTORY     ,"out_UPDATE_PREDICTOR_HISTORY     ",Thistory_t,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_PREDICTOR_DIRECTION   ,"out_UPDATE_PREDICTOR_DIRECTION   ",Tcontrol_t,_param->_nb_inst_update);

  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Direction_Glue.\n"),name.c_str());

  (*(_Direction_Glue->in_CLOCK))        (*(in_CLOCK));
  (*(_Direction_Glue->in_NRESET))       (*(in_NRESET));

  INSTANCE1_SC_SIGNAL(_Direction_Glue, in_PREDICT_VAL                  ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Direction_Glue,out_PREDICT_ACK                  ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Direction_Glue, in_PREDICT_ADDRESS_SRC          ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Direction_Glue, in_PREDICT_STATIC               ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Direction_Glue, in_PREDICT_LAST_TAKE            ,_param->_nb_inst_predict);
  if (_param->_have_port_history)
  INSTANCE1_SC_SIGNAL(_Direction_Glue,out_PREDICT_HISTORY              ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Direction_Glue,out_PREDICT_DIRECTION            ,_param->_nb_inst_predict);
  if (_param->_have_component_meta_predictor)
    {
  INSTANCE1_SC_SIGNAL(_Direction_Glue,out_PREDICT_PREDICTOR_VAL        ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Direction_Glue, in_PREDICT_PREDICTOR_ACK        ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Direction_Glue,out_PREDICT_PREDICTOR_ADDRESS_SRC,_param->_nb_inst_predict);
  if (_param->_have_port_history)
  INSTANCE1_SC_SIGNAL(_Direction_Glue, in_PREDICT_PREDICTOR_HISTORY    ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Direction_Glue, in_PREDICT_PREDICTOR_DIRECTION  ,_param->_nb_inst_predict);
    }

  INSTANCE1_SC_SIGNAL(_Direction_Glue, in_UPDATE_VAL                   ,_param->_nb_inst_update );
  INSTANCE1_SC_SIGNAL(_Direction_Glue,out_UPDATE_ACK                   ,_param->_nb_inst_update );
  INSTANCE1_SC_SIGNAL(_Direction_Glue, in_UPDATE_ADDRESS               ,_param->_nb_inst_update );
  if (_param->_have_port_history)
  INSTANCE1_SC_SIGNAL(_Direction_Glue, in_UPDATE_HISTORY               ,_param->_nb_inst_update );
  INSTANCE1_SC_SIGNAL(_Direction_Glue, in_UPDATE_DIRECTION             ,_param->_nb_inst_update );
  if (_param->_have_component_meta_predictor)
    {
  INSTANCE1_SC_SIGNAL(_Direction_Glue,out_UPDATE_PREDICTOR_VAL         ,_param->_nb_inst_update );
  INSTANCE1_SC_SIGNAL(_Direction_Glue, in_UPDATE_PREDICTOR_ACK         ,_param->_nb_inst_update );
  INSTANCE1_SC_SIGNAL(_Direction_Glue,out_UPDATE_PREDICTOR_ADDRESS     ,_param->_nb_inst_update );
  if (_param->_have_port_history)
  INSTANCE1_SC_SIGNAL(_Direction_Glue,out_UPDATE_PREDICTOR_HISTORY     ,_param->_nb_inst_update );
  INSTANCE1_SC_SIGNAL(_Direction_Glue,out_UPDATE_PREDICTOR_DIRECTION   ,_param->_nb_inst_update );
    }

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	{
	  in_PREDICT_VAL                 [i]->write(rand()%2);
	  in_PREDICT_ADDRESS_SRC         [i]->write(range<Taddress_t>(rand(),_param->_size_address));
	  in_PREDICT_STATIC              [i]->write(rand()%2);
	  in_PREDICT_LAST_TAKE           [i]->write(rand()%2);
	  in_PREDICT_PREDICTOR_ACK       [i]->write(rand()%2);
	  in_PREDICT_PREDICTOR_HISTORY   [i]->write(range<Thistory_t>(rand(),_param->_size_history));
	  in_PREDICT_PREDICTOR_DIRECTION [i]->write(rand()%2);
	}

      for (uint32_t i=0; i<_param->_nb_inst_update; i++)
	{
	  in_UPDATE_VAL                  [i]->write(rand()%2);
	  in_UPDATE_ADDRESS              [i]->write(range<Taddress_t>(rand(),_param->_size_address));
	  in_UPDATE_HISTORY              [i]->write(range<Thistory_t>(rand(),_param->_size_history));
	  in_UPDATE_DIRECTION            [i]->write(rand()%2);
	  in_UPDATE_PREDICTOR_ACK        [i]->write(rand()%2);
	}

      SC_START(0);

      for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	{
	  switch (_param->_predictor_scheme)
	    {
	    case PREDICTOR_NEVER_TAKE  :
	      {
		TEST(Tcontrol_t,out_PREDICT_ACK                   [i]->read(), 1);
		TEST(Tcontrol_t,out_PREDICT_DIRECTION             [i]->read(), 0);
		break;
	      }
	    case PREDICTOR_ALWAYS_TAKE :
	      {
		TEST(Tcontrol_t,out_PREDICT_ACK                   [i]->read(), 1);
		TEST(Tcontrol_t,out_PREDICT_DIRECTION             [i]->read(), 1);
		break;
	      }
	    case PREDICTOR_STATIC      :
	      {
		TEST(Tcontrol_t,out_PREDICT_ACK                   [i]->read(), 1);
		TEST(Tcontrol_t,out_PREDICT_DIRECTION             [i]->read(), in_PREDICT_STATIC               [i]->read());
		break;
	      }
	    case PREDICTOR_LAST_TAKE   :
	      {
		TEST(Tcontrol_t,out_PREDICT_DIRECTION             [i]->read(), in_PREDICT_LAST_TAKE            [i]->read());
		break;
	      }
	    case PREDICTOR_COUNTER     :
	    case PREDICTOR_LOCAL       :
	    case PREDICTOR_GLOBAL      :
	    case PREDICTOR_META        :
	    case PREDICTOR_CUSTOM      :
	      {
		TEST(Tcontrol_t,out_PREDICT_ACK                   [i]->read(), in_PREDICT_PREDICTOR_ACK        [i]->read());
		TEST(Thistory_t,out_PREDICT_HISTORY               [i]->read(), in_PREDICT_PREDICTOR_HISTORY    [i]->read());
		TEST(Tcontrol_t,out_PREDICT_DIRECTION             [i]->read(), in_PREDICT_PREDICTOR_DIRECTION  [i]->read());
		TEST(Tcontrol_t,out_PREDICT_PREDICTOR_VAL         [i]->read(), in_PREDICT_VAL                  [i]->read());
		TEST(Taddress_t,out_PREDICT_PREDICTOR_ADDRESS_SRC [i]->read(), in_PREDICT_ADDRESS_SRC          [i]->read());
		
		break;
	      }
	    default :
	      {
		break;
	      }
	    }
	}

      for (uint32_t i=0; i<_param->_nb_inst_update; i++)
	{


	  switch (_param->_predictor_scheme)
	    {
	    case PREDICTOR_COUNTER     :
	    case PREDICTOR_LOCAL       :
	    case PREDICTOR_GLOBAL      :
	    case PREDICTOR_META        :
	    case PREDICTOR_CUSTOM      :
	      {
		TEST(Tcontrol_t,out_UPDATE_ACK                 [i]->read(), in_UPDATE_PREDICTOR_ACK [i]->read());
		TEST(Tcontrol_t,out_UPDATE_PREDICTOR_VAL       [i]->read(), in_UPDATE_VAL           [i]->read());
		TEST(Taddress_t,out_UPDATE_PREDICTOR_ADDRESS   [i]->read(), in_UPDATE_ADDRESS       [i]->read());
		TEST(Thistory_t,out_UPDATE_PREDICTOR_HISTORY   [i]->read(), in_UPDATE_HISTORY       [i]->read());
		TEST(Tcontrol_t,out_UPDATE_PREDICTOR_DIRECTION [i]->read(), in_UPDATE_DIRECTION     [i]->read());
		
		break;
	      }
	    case PREDICTOR_NEVER_TAKE  :
	    case PREDICTOR_ALWAYS_TAKE :
	    case PREDICTOR_STATIC      :
	    case PREDICTOR_LAST_TAKE   :
	    default :
	      {
		TEST(Tcontrol_t,out_UPDATE_ACK                 [i]->read(), 1);

		break;
	      }
	    }
	}

      SC_START(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  delete []  in_PREDICT_VAL                  ;
  delete [] out_PREDICT_ACK                  ;
  delete []  in_PREDICT_ADDRESS_SRC          ;
  delete []  in_PREDICT_STATIC               ;
  delete []  in_PREDICT_LAST_TAKE            ;
  delete [] out_PREDICT_HISTORY              ;
  delete [] out_PREDICT_DIRECTION            ;
  delete [] out_PREDICT_PREDICTOR_VAL        ;
  delete []  in_PREDICT_PREDICTOR_ACK        ;
  delete [] out_PREDICT_PREDICTOR_ADDRESS_SRC;
  delete []  in_PREDICT_PREDICTOR_HISTORY    ;
  delete []  in_PREDICT_PREDICTOR_DIRECTION  ;
  delete []  in_UPDATE_VAL                   ;
  delete [] out_UPDATE_ACK                   ;
  delete []  in_UPDATE_ADDRESS               ;
  delete []  in_UPDATE_HISTORY               ;
  delete []  in_UPDATE_DIRECTION             ;
  delete [] out_UPDATE_PREDICTOR_VAL         ;
  delete []  in_UPDATE_PREDICTOR_ACK         ;
  delete [] out_UPDATE_PREDICTOR_ADDRESS     ;
  delete [] out_UPDATE_PREDICTOR_HISTORY     ;
  delete [] out_UPDATE_PREDICTOR_DIRECTION   ;
#endif

  delete _Direction_Glue;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
