/*
 * $Id: test.cpp 82 2008-05-01 16:48:45Z rosiere $
 *
 * [Description ]
 * 
 * Test
 */

#define NB_ITERATION  1
#define CYCLE_MAX     (128*NB_ITERATION)

#include "Behavioural/Generic/Victim/Victim_Pseudo_LRU/SelfTest/include/test.h"
#include "Common/include/Test.h"

void test (string name,
	   morpheo::behavioural::generic::victim::victim_pseudo_lru::Parameters param)
{
  cout << "<" << name << "> : Simulation SystemC" << endl;

  try 
    {
      cout << param.print(1);
      param.test();
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      cout << "<" << name << "> : " <<  error.what ();
      return;
    }
  catch (...)
    {
      cerr << "<" << name << "> : This test must generate a error" << endl;
      exit (EXIT_FAILURE);
    }

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * param_stat = new morpheo::behavioural::Parameters_Statistics(5,50);
#endif

  Victim_Pseudo_LRU * _Victim_Pseudo_LRU = new Victim_Pseudo_LRU (name.c_str(),
#ifdef STATISTICS
								  param_stat,
#endif
								  &param,
								  USE_ALL);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  sc_clock                                 CLOCK  ("clock", 1.0, 0.5);
  sc_signal<Tcontrol_t>                    NRESET ("NRESET");

  sc_signal<Tcontrol_t>                    ACCESS_VAL     [param._nb_access];
  sc_signal<Tcontrol_t>                    ACCESS_ACK     [param._nb_access];
  sc_signal<Taddress_t>                    ACCESS_ADDRESS [param._nb_access];
  sc_signal<Tcontrol_t>                    ACCESS_HIT     [param._nb_access];
  sc_signal<Tentity_t >                    ACCESS_ENTITY  [param._nb_access];
  sc_signal<Tentity_t >                    ACCESS_VICTIM  [param._nb_access];
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  cout << "<" << name << "> Instanciation of _Victim_Pseudo_LRU" << endl;
  
  (*(_Victim_Pseudo_LRU->in_CLOCK))        (CLOCK);
  (*(_Victim_Pseudo_LRU->in_NRESET))       (NRESET);

    for (uint32_t i=0; i<param._nb_access; i++)
      {
	(*(_Victim_Pseudo_LRU-> in_ACCESS_VAL     [i])) (ACCESS_VAL     [i]);
	(*(_Victim_Pseudo_LRU->out_ACCESS_ACK     [i])) (ACCESS_ACK     [i]);
	if (param._size_address>1)
	(*(_Victim_Pseudo_LRU-> in_ACCESS_ADDRESS [i])) (ACCESS_ADDRESS [i]);
	(*(_Victim_Pseudo_LRU-> in_ACCESS_HIT     [i])) (ACCESS_HIT     [i]);
	(*(_Victim_Pseudo_LRU-> in_ACCESS_ENTITY  [i])) (ACCESS_ENTITY  [i]);
	(*(_Victim_Pseudo_LRU->out_ACCESS_VICTIM  [i])) (ACCESS_VICTIM  [i]);
      }

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  cout << "<" << name << "> Start Simulation ............" << endl;
  // Initialisation

  sc_start(0);

  bool array [param._nb_access][param._nb_entity];

  for (uint32_t i=0; i<param._nb_access; i++)
    {
      ACCESS_VAL[i].write(0);
    }

  sc_start(5);
  cout << "-----[ Test Update ]------------------------------" << endl;
  for (uint32_t i=0; i<param._nb_access; i++)
    {
      ACCESS_VAL[i].write(1);
      ACCESS_HIT[i].write(1);
    }
  
  for (uint32_t j=0; j<param._size_table; j+=param._nb_access)
    for (uint32_t k=0; k<param._nb_entity; k++)
      {
	cout << "time : " << static_cast<uint32_t>(sc_simulation_time()) << endl;
	for (uint32_t i=0; i<param._nb_access; i++)
	  {
	    
	    Tcontrol_t val     = static_cast<Tcontrol_t>((j+i)<param._size_table);
	    Taddress_t addr;
	    if (param._size_table>1)
	      addr = static_cast<Taddress_t>((j+i)%param._size_table);
	    else
	      addr = 0;
	    Tentity_t  entity  = (k+1)%param._nb_entity;
	    ACCESS_VAL     [i].write(val );
	    if (param._size_address>1)
	      ACCESS_ADDRESS [i].write(addr);
	    ACCESS_ENTITY  [i].write(entity);
	    
	    sc_start(0);
	    cout << "\t[" << i << "] " << val << " - " << ACCESS_ACK[i].read() << " addr : " << addr << " -> " << entity << endl;
	  }
	sc_start(1);
      }
		    

  for (uint32_t i=0; i<param._nb_access; i++)
    {
      ACCESS_VAL[i].write(0);
    }

  sc_start(5);

  cout << "-----[ Test Access ]------------------------------" << endl;

  for (uint32_t i=0; i<param._nb_access; i++)
    {
      ACCESS_HIT[i].write(0);
    }
  
  
  for (uint32_t j=0; j<param._size_table; j+=param._nb_access)
    {
      // init
      memset(static_cast<void*>(array),0,param._nb_access*param._nb_entity*sizeof(bool));
      
      for (uint32_t k=0; k<param._nb_entity; k++)
	{
	  
	  cout << "time : " << static_cast<uint32_t>(sc_simulation_time()) << endl;
	  for (uint32_t i=0; i<param._nb_access; i++)
	    {
	      Tcontrol_t val     = static_cast<Tcontrol_t>((j+i)<param._size_table);
	      Taddress_t addr    ;
	      if (param._size_table>1)
		addr = static_cast<Taddress_t>((j+i)%param._size_table);
	      else
		addr = 0;
	      ACCESS_VAL     [i].write(val );
	      if (param._size_address>1)
		ACCESS_ADDRESS [i].write(addr);
	      
	      sc_start(0);
	      
	      Tentity_t  entity  = ACCESS_VICTIM [i].read();
	      
	      cout << "\t[" << i << "] " << val << " - " << ACCESS_ACK[i].read() << " addr : " << addr << " -> " << entity << endl;
	      
	      TEST(bool,false,((val == true) && (array[i][entity] == true)));

// 	      if ((val == true) && (array[i][entity] == true))
// 		{
// 		  cout << "Test KO : Have already give this way" << endl;
// 		  exit (1);
// 		}
// 	      else
		array[i][entity] = true;
	    }
	  
	  sc_start(1);
	  
	}
    }

  for (uint32_t i=0; i<param._nb_access; i++)
    {
      ACCESS_VAL[i].write(0);
    }

  sc_start(0);

  /********************************************************
   * Simulation - End
   ********************************************************/

  cout << "<" << name << "> ............ Stop Simulation" << endl;

#endif

  delete _Victim_Pseudo_LRU;

#ifdef STATISTICS
  delete param_stat;
#endif

}
