#ifndef morpheo_behavioural_generic_victim_victim_pseudo_lru_Victim_Pseudo_LRU_h
#define morpheo_behavioural_generic_victim_victim_pseudo_lru_Victim_Pseudo_LRU_h

/*
 * $Id: Victim_Pseudo_LRU.h 82 2008-05-01 16:48:45Z rosiere $
 *
 * [ Description ]
 * 
 */
    // Tree of Pseudo-LRU
    //
    // |               4-5-6-7?              |
    // |          0_______|_______1	     |
    // |          |               |	     |
    // |         2-3?            6-7?        |
    // |      0___|___1       0___|___1      |
    // |      |       |       |       |      |
    // |      1?      3?      5?      7?     |
    // |    0_|_1   0_|_1   0_|_1   0_|_1    |
    // |    |   |   |   |   |   |   |   |    |
    // |   Way Way Way Way Way Way Way Way   |
    // |    0   1   2   3   4   5   6   7    |



#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include "Behavioural/Generic/Victim/Victim_Pseudo_LRU/include/Parameters.h"
#include "Behavioural/Generic/Victim/Victim_Pseudo_LRU/include/Types.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Component.h"
#include "Behavioural/include/Usage.h"

namespace morpheo {
namespace behavioural {
namespace generic {
namespace victim {
namespace victim_pseudo_lru {

  class Victim_Pseudo_LRU 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK         ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET        ;

    // Interface access
  public    : SC_IN (Tcontrol_t)           **  in_ACCESS_VAL    ;
  public    : SC_OUT(Tcontrol_t)           ** out_ACCESS_ACK    ;
  public    : SC_IN (Taddress_t)           **  in_ACCESS_ADDRESS;
  public    : SC_IN (Tcontrol_t)           **  in_ACCESS_HIT    ; // hit = 1 : update next_victim with in_entity else with out_victim
  public    : SC_IN (Tentity_t )           **  in_ACCESS_ENTITY ;
  public    : SC_OUT(Tentity_t )           ** out_ACCESS_VICTIM ;

    // Interface update
    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  private   : entry_t                      ** reg_TABLE;

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  private   : Tcontrol_t                    * internal_ACCESS_ACK   ;
  private   : Tentity_t                     * internal_ACCESS_VICTIM;
#endif

    // -----[ methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Victim_Pseudo_LRU);
#endif

  public  :          Victim_Pseudo_LRU              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param ,
   morpheo::behavioural::Tusage_t                usage);
					       
  public  :          Victim_Pseudo_LRU              (Parameters param );
  public  :          ~Victim_Pseudo_LRU             (void);
					       
#ifdef SYSTEMC				       
  private : void     allocation                (void);
  private : void     deallocation              (void);
					       
  public  : void     transition                (void);
  public  : void     genMoore                  (void);
#endif
					       
#if VHDL				       
  public  : void     vhdl                      (void);
  private : void     vhdl_declaration          (Vhdl * & vhdl);
  private : void     vhdl_body                 (Vhdl * & vhdl);
#endif					       
					       
#ifdef STATISTICS
  public  : void     statistics_declaration    (morpheo::behavioural::Parameters_Statistics * param_statistics);
#endif

#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void     end_cycle                 (void);
#endif
  };

}; // end namespace victim_pseudo_lru
}; // end namespace victim
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
