/*
 * $Id: main.cpp 82 2008-05-01 16:48:45Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/SelfTest/include/test.h"

#define NB_PARAMS (12+3*7)

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_(" * nb_context                                (uint32_t    )\n"));
  err (_(" * nb_decod_unit                             (uint32_t    )\n"));
  err (_(" * size_address                              (uint32_t    )\n"));
  err (_(" * nb_instruction             [nb_context]   (uint32_t    )\n"));
  err (_(" * nb_inst_decod              [nb_decod_unit](uint32_t    )\n"));
  err (_(" * nb_inst_branch_predict                    (uint32_t    )\n"));
  err (_(" * nb_inst_branch_decod                      (uint32_t    )\n"));
  err (_(" * nb_inst_branch_update                     (uint32_t    )\n"));
  err (_(" * nb_inst_branch_complete                   (uint32_t    )\n"));
  err (_(" * btb_size_queue                            (uint32_t    )\n"));
  err (_(" * btb_associativity                         (uint32_t    )\n"));
  err (_(" * btb_size_counter                          (uint32_t    )\n"));
  err (_(" * btb_victim_scheme                         (Tvictim_t   )\n"));
  err (_(" * dir_predictor_scheme                      (Tpredictor_t)\n"));
  err (_(" * dir_have_bht               [3]            (bool        )\n"));
  err (_(" * dir_bht_size_shifter       [3]            (uint32_t    )\n"));
  err (_(" * dir_bht_nb_shifter         [3]            (uint32_t    )\n"));
  err (_(" * dir_have_pht               [3]            (bool        )\n"));
  err (_(" * dir_pht_size_counter       [3]            (uint32_t    )\n"));
  err (_(" * dir_pht_nb_counter         [3]            (uint32_t    )\n"));
  err (_(" * dir_pht_size_address_share [3]            (uint32_t    )\n"));
  err (_(" * ras_size_queue             [nb_context]   (uint32_t    )\n"));
  err (_(" * upt_size_queue             [nb_context]   (uint32_t    )\n"));

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc < static_cast<int>(2+NB_PARAMS))
    usage (argc, argv);

  uint32_t x = 1;

  string name = argv[x++];
  uint32_t     _nb_context                     = fromString<uint32_t>(argv[x++]);
  uint32_t     _nb_decod_unit                  = fromString<uint32_t>(argv[x++]);
  uint32_t     _size_address                   = fromString<uint32_t>(argv[x++]);

  if (argc != static_cast<int>(2+NB_PARAMS+3*_nb_context+_nb_decod_unit))
    usage (argc, argv);

  uint32_t *   _nb_instruction                 = new uint32_t [_nb_context];
  for (uint32_t i=0; i<_nb_context; i++)
    _nb_instruction [i]                        = fromString<uint32_t    >(argv[x++]);
  uint32_t *   _nb_inst_decod                  = new uint32_t [_nb_decod_unit];
  for (uint32_t i=0; i<_nb_decod_unit; i++)
    _nb_inst_decod [i]                         = fromString<uint32_t    >(argv[x++]);
  uint32_t     _nb_inst_branch_predict         = fromString<uint32_t    >(argv[x++]);
  uint32_t     _nb_inst_branch_decod           = fromString<uint32_t    >(argv[x++]);
  uint32_t     _nb_inst_branch_update          = fromString<uint32_t    >(argv[x++]);
  uint32_t     _nb_inst_branch_complete        = fromString<uint32_t    >(argv[x++]);
  uint32_t     _btb_size_queue                 = fromString<uint32_t    >(argv[x++]);
  uint32_t     _btb_associativity              = fromString<uint32_t    >(argv[x++]);
  uint32_t     _btb_size_counter               = fromString<uint32_t    >(argv[x++]);
  Tvictim_t    _btb_victim_scheme              = fromString<Tvictim_t   >(argv[x++]);
  Tpredictor_t _dir_predictor_scheme           = fromString<Tpredictor_t>(argv[x++]);
  bool         _dir_have_bht               [3];
  for (uint32_t i=0; i<3; i++)
    _dir_have_bht [i]                          = fromString<bool        >(argv[x++]);
  uint32_t     _dir_bht_size_shifter       [3];
  for (uint32_t i=0; i<3; i++)
    _dir_bht_size_shifter [i]                  = fromString<uint32_t    >(argv[x++]);
  uint32_t     _dir_bht_nb_shifter         [3];
  for (uint32_t i=0; i<3; i++)
    _dir_bht_nb_shifter [i]                    = fromString<uint32_t    >(argv[x++]);
  bool         _dir_have_pht               [3];
  for (uint32_t i=0; i<3; i++)
    _dir_have_pht [i]                          = fromString<bool        >(argv[x++]);
  uint32_t     _dir_pht_size_counter       [3];
  for (uint32_t i=0; i<3; i++)
    _dir_pht_size_counter [i]                  = fromString<uint32_t    >(argv[x++]);
  uint32_t     _dir_pht_nb_counter         [3];
  for (uint32_t i=0; i<3; i++)
    _dir_pht_nb_counter [i]                    = fromString<uint32_t    >(argv[x++]);
  uint32_t     _dir_pht_size_address_share [3];
  for (uint32_t i=0; i<3; i++)
    _dir_pht_size_address_share [i]            = fromString<uint32_t    >(argv[x++]);
  uint32_t *   _ras_size_queue                 = new uint32_t    [_nb_context];
  for (uint32_t i=0; i<_nb_context; i++)
    _ras_size_queue [i]                        = fromString<uint32_t    >(argv[x++]);
  uint32_t *   _upt_size_queue                 = new uint32_t    [_nb_context];
  for (uint32_t i=0; i<_nb_context; i++)
    _upt_size_queue [i]                        = fromString<uint32_t    >(argv[x++]);

  int _return = EXIT_SUCCESS;
  try 
    {
      morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::Parameters * param = new morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::Parameters
	(_nb_context                ,
	 _nb_decod_unit             ,
	 _size_address              ,
	 _nb_instruction            ,
	 _nb_inst_decod             ,
	 _nb_inst_branch_predict    ,
	 _nb_inst_branch_decod      ,
	 _nb_inst_branch_update     ,
	 _nb_inst_branch_complete   ,
	 _btb_size_queue            ,
	 _btb_associativity         ,
	 _btb_size_counter          ,
	 _btb_victim_scheme         ,
	 _dir_predictor_scheme      ,
	 _dir_have_bht              ,
	 _dir_bht_size_shifter      ,
	 _dir_bht_nb_shifter        ,
	 _dir_have_pht              ,
	 _dir_pht_size_counter      ,
	 _dir_pht_nb_counter        ,
	 _dir_pht_size_address_share,
	 _ras_size_queue            ,
	 _upt_size_queue            
	 );
      
      msg(_("%s"),param->print(1).c_str());
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }
  catch (...)
    {
      err (_("<%s> : This test must generate a error.\n"),name.c_str());
      _return = EXIT_FAILURE;
    }

  delete [] _nb_instruction            ;
  delete [] _nb_inst_decod             ;
  delete [] _ras_size_queue            ;
  delete [] _upt_size_queue            ;

  return (_return);
}
