/*
 * $Id: Context_State.cpp 83 2008-05-09 18:00:21Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Context_State/include/Context_State.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace context_state {


#undef  FUNCTION
#define FUNCTION "Context_State::Context_State"
  Context_State::Context_State 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_front_end::front_end::context_state::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_begin(Context_State,FUNCTION);

    usage_environment(_usage);

    log_printf(INFO,Context_State,FUNCTION,_("Allocation"));

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Context_State,FUNCTION,_("Allocation of statistics"));

	statistics_allocation(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Context_State,FUNCTION,_("Generate the vhdl"));
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	// Constant
	for (uint32_t i=0; i<_param->_nb_decod_unit; i++)
	  {
	    internal_DECOD_EVENT_ACK [i] = 1;
	    PORT_WRITE(out_DECOD_EVENT_ACK [i], internal_DECOD_EVENT_ACK [i]);
	  }

	for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
	  {
	    internal_COMMIT_EVENT_ACK [i] = 1;
	    PORT_WRITE(out_COMMIT_EVENT_ACK [i], internal_COMMIT_EVENT_ACK [i]);
	  }

	for (uint32_t i=0; i<_param->_nb_inst_branch_complete; i++)
	  {
	    internal_BRANCH_COMPLETE_ACK [i] = 1;
	    PORT_WRITE(out_BRANCH_COMPLETE_ACK [i], internal_BRANCH_COMPLETE_ACK [i]);
	  }

	log_printf(INFO,Context_State,FUNCTION,_("Method - transition"));

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Context_State,FUNCTION,_("Method - genMoore"));

	SC_METHOD (genMoore);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg(); // use internal register
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
	
#endif
      }
    log_end(Context_State,FUNCTION);
  };
    
#undef  FUNCTION
#define FUNCTION "Context_State::~Context_State"
  Context_State::~Context_State (void)
  {
    log_begin(Context_State,FUNCTION);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,Context_State,FUNCTION,_("Deallocation"));
    deallocation ();

    log_end(Context_State,FUNCTION);
  };

}; // end namespace context_state
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
