#ifdef SYSTEMC
/*
 * $Id: Context_State_genMoore.cpp 83 2008-05-09 18:00:21Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Context_State/include/Context_State.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace context_state {


#undef  FUNCTION
#define FUNCTION "Context_State::genMoore"
  void Context_State::genMoore (void)
  {
    log_begin(Context_State,FUNCTION);

    // -------------------------------------------------------------------
    // -----[ EVENT ]-----------------------------------------------------
    // -------------------------------------------------------------------
    for (uint32_t i=0; i<_param->_nb_context; i++)
      {
	context_state_t state = reg_STATE [i];

	internal_EVENT_VAL [i] = ((state == CONTEXT_STATE_KO_EXCEP_ADDR) or
				  (state == CONTEXT_STATE_KO_MISS_ADDR ) or
				  (state == CONTEXT_STATE_KO_PSYNC_ADDR) or 
				  (state == CONTEXT_STATE_KO_CSYNC_ADDR));

	// excep : address exception
	// miss  : address delay_slot, and address dest
	// psync : address next
	// csync : address next
	PORT_WRITE(out_EVENT_VAL              [i], internal_EVENT_VAL     [i]);
	PORT_WRITE(out_EVENT_ADDRESS          [i], reg_EVENT_ADDRESS      [i]);
	PORT_WRITE(out_EVENT_ADDRESS_NEXT     [i], reg_EVENT_ADDRESS_EPCR [i]); 
	PORT_WRITE(out_EVENT_ADDRESS_NEXT_VAL [i], (state == CONTEXT_STATE_KO_MISS_ADDR) and (reg_EVENT_ADDRESS_EPCR_VAL [i]));
	PORT_WRITE(out_EVENT_IS_DS_TAKE       [i], (state == CONTEXT_STATE_KO_MISS_ADDR) and (reg_EVENT_IS_DS_TAKE       [i]));
      }

    // -------------------------------------------------------------------
    // -----[ SPR ]-------------------------------------------------------
    // -------------------------------------------------------------------
    for (uint32_t i=0; i<_param->_nb_context; i++)
      {
	context_state_t state = reg_STATE [i];

	internal_SPR_VAL [i] = (state == CONTEXT_STATE_KO_EXCEP_SPR  );

	PORT_WRITE(out_SPR_VAL       [i], internal_SPR_VAL           [i]);
	PORT_WRITE(out_SPR_EPCR      [i], reg_EVENT_ADDRESS_EPCR     [i]);
	PORT_WRITE(out_SPR_EEAR      [i], reg_EVENT_ADDRESS_EEAR     [i]);
	PORT_WRITE(out_SPR_EEAR_WEN  [i], reg_EVENT_ADDRESS_EEAR_VAL [i]);
	PORT_WRITE(out_SPR_SR_DSX    [i], reg_EVENT_IS_DELAY_SLOT    [i]);
	PORT_WRITE(out_SPR_SR_TO_ESR [i], 1);
      }

    // -------------------------------------------------------------------
    // -----[ CONTEXT ]---------------------------------------------------
    // -------------------------------------------------------------------
    for (uint32_t i=0; i<_param->_nb_context; i++)
      {
	context_state_t state = reg_STATE [i];

	PORT_WRITE(out_CONTEXT_DECOD_ENABLE [i], ((state==CONTEXT_STATE_OK            ) or
						  (state==CONTEXT_STATE_KO_MSYNC_ISSUE) or
						  (state==CONTEXT_STATE_KO_SPR_ISSUE  )));
      }

    log_end(Context_State,FUNCTION);
  };

}; // end namespace context_state
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
