/*
 * $Id: test.cpp 84 2008-05-13 18:04:50Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */


#define NB_ITERATION  1024
#define CYCLE_MAX     (128*NB_ITERATION)

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Address_management/SelfTest/include/test.h"
#include "Common/include/Test.h"
#include "Behavioural/include/Allocation.h"

void test (string name,
	   morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::address_management::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Address_management * _Address_management = new Address_management 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     USE_ALL);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC_SC_SIGNAL (out_ADDRESS_VAL                        ,"out_ADDRESS_VAL                        ",Tcontrol_t        );
  ALLOC_SC_SIGNAL ( in_ADDRESS_ACK                        ," in_ADDRESS_ACK                        ",Tcontrol_t        );
  ALLOC_SC_SIGNAL (out_ADDRESS_INSTRUCTION_ADDRESS        ,"out_ADDRESS_INSTRUCTION_ADDRESS        ",Tgeneral_address_t);
  ALLOC1_SC_SIGNAL(out_ADDRESS_INSTRUCTION_ENABLE         ,"out_ADDRESS_INSTRUCTION_ENABLE         ",Tcontrol_t        ,_param->_nb_instruction);
  ALLOC_SC_SIGNAL (out_ADDRESS_INST_IFETCH_PTR            ,"out_ADDRESS_INST_IFETCH_PTR            ",Tinst_ifetch_ptr_t);
  ALLOC_SC_SIGNAL (out_ADDRESS_BRANCH_STATE               ,"out_ADDRESS_BRANCH_STATE               ",Tbranch_state_t   );
  ALLOC_SC_SIGNAL (out_ADDRESS_BRANCH_UPDATE_PREDICTION_ID,"out_ADDRESS_BRANCH_UPDATE_PREDICTION_ID",Tprediction_ptr_t );
  ALLOC_SC_SIGNAL (out_PREDICT_VAL                        ,"out_PREDICT_VAL                        ",Tcontrol_t        );
  ALLOC_SC_SIGNAL ( in_PREDICT_ACK                        ," in_PREDICT_ACK                        ",Tcontrol_t        );
  ALLOC_SC_SIGNAL (out_PREDICT_PC_PREVIOUS                ,"out_PREDICT_PC_PREVIOUS                ",Tgeneral_address_t);
  ALLOC_SC_SIGNAL (out_PREDICT_PC_CURRENT                 ,"out_PREDICT_PC_CURRENT                 ",Tgeneral_address_t);
  ALLOC_SC_SIGNAL (out_PREDICT_PC_CURRENT_IS_DS_TAKE      ,"out_PREDICT_PC_CURRENT_IS_DS_TAKE      ",Tcontrol_t        );
  ALLOC_SC_SIGNAL ( in_PREDICT_PC_NEXT                    ," in_PREDICT_PC_NEXT                    ",Tgeneral_address_t);
  ALLOC_SC_SIGNAL ( in_PREDICT_PC_NEXT_IS_DS_TAKE         ," in_PREDICT_PC_NEXT_IS_DS_TAKE         ",Tcontrol_t        );
  ALLOC1_SC_SIGNAL( in_PREDICT_INSTRUCTION_ENABLE         ," in_PREDICT_INSTRUCTION_ENABLE         ",Tcontrol_t        ,_param->_nb_instruction);
  ALLOC_SC_SIGNAL ( in_PREDICT_INST_IFETCH_PTR            ," in_PREDICT_INST_IFETCH_PTR            ",Tinst_ifetch_ptr_t);
  ALLOC_SC_SIGNAL ( in_PREDICT_BRANCH_STATE               ," in_PREDICT_BRANCH_STATE               ",Tbranch_state_t   );
  ALLOC_SC_SIGNAL ( in_PREDICT_BRANCH_UPDATE_PREDICTION_ID," in_PREDICT_BRANCH_UPDATE_PREDICTION_ID",Tprediction_ptr_t );
  ALLOC_SC_SIGNAL ( in_EVENT_VAL                          ," in_EVENT_VAL                          ",Tcontrol_t        );
  ALLOC_SC_SIGNAL (out_EVENT_ACK                          ,"out_EVENT_ACK                          ",Tcontrol_t        );
  ALLOC_SC_SIGNAL ( in_EVENT_ADDRESS                      ," in_EVENT_ADDRESS                      ",Tgeneral_address_t);
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Address_management.\n"),name.c_str());

  (*(_Address_management->in_CLOCK))        (*(in_CLOCK));
  (*(_Address_management->in_NRESET))       (*(in_NRESET));

  INSTANCE_SC_SIGNAL (_Address_management,out_ADDRESS_VAL                        );
  INSTANCE_SC_SIGNAL (_Address_management, in_ADDRESS_ACK                        );
  INSTANCE_SC_SIGNAL (_Address_management,out_ADDRESS_INSTRUCTION_ADDRESS        );
  INSTANCE1_SC_SIGNAL(_Address_management,out_ADDRESS_INSTRUCTION_ENABLE         ,_param->_nb_instruction);
  if (_param->_have_port_instruction_ptr)
  INSTANCE_SC_SIGNAL (_Address_management,out_ADDRESS_INST_IFETCH_PTR            );
  INSTANCE_SC_SIGNAL (_Address_management,out_ADDRESS_BRANCH_STATE               );
  if (_param->_have_port_branch_update_prediction_id)
  INSTANCE_SC_SIGNAL (_Address_management,out_ADDRESS_BRANCH_UPDATE_PREDICTION_ID);
  INSTANCE_SC_SIGNAL (_Address_management,out_PREDICT_VAL                        );
  INSTANCE_SC_SIGNAL (_Address_management, in_PREDICT_ACK                        );
  INSTANCE_SC_SIGNAL (_Address_management,out_PREDICT_PC_PREVIOUS                );
  INSTANCE_SC_SIGNAL (_Address_management,out_PREDICT_PC_CURRENT                 );
  INSTANCE_SC_SIGNAL (_Address_management,out_PREDICT_PC_CURRENT_IS_DS_TAKE      );
  INSTANCE_SC_SIGNAL (_Address_management, in_PREDICT_PC_NEXT                    );
  INSTANCE_SC_SIGNAL (_Address_management, in_PREDICT_PC_NEXT_IS_DS_TAKE         );
  INSTANCE1_SC_SIGNAL(_Address_management, in_PREDICT_INSTRUCTION_ENABLE         ,_param->_nb_instruction);
  if (_param->_have_port_instruction_ptr)
  INSTANCE_SC_SIGNAL (_Address_management, in_PREDICT_INST_IFETCH_PTR            );
  INSTANCE_SC_SIGNAL (_Address_management, in_PREDICT_BRANCH_STATE               );
  if (_param->_have_port_branch_update_prediction_id)
  INSTANCE_SC_SIGNAL (_Address_management, in_PREDICT_BRANCH_UPDATE_PREDICTION_ID);
  INSTANCE_SC_SIGNAL (_Address_management, in_EVENT_VAL                          );
  INSTANCE_SC_SIGNAL (_Address_management,out_EVENT_ACK                          );
  INSTANCE_SC_SIGNAL (_Address_management, in_EVENT_ADDRESS                      );

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  const  int32_t percent_transaction_address = 75;
  const  int32_t percent_transaction_predict = 75;
  const  int32_t percent_transaction_event   =  5;

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");

  in_ADDRESS_ACK->write(0);
 out_PREDICT_VAL->write(0);
  in_EVENT_VAL  ->write(0);

  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Test Reset");

  TEST(Tcontrol_t, out_ADDRESS_VAL->read(), false);
  TEST(Tcontrol_t,  in_PREDICT_ACK->read(), false); // can't send a prediction
  TEST(Tcontrol_t, out_EVENT_ACK->read()  , true ); // can receveive an event

  uint32_t        jump      = 7 ;// packet
  uint32_t        nb_packet = 1;

  Tcontrol_t      c_val   = false;
  Tcontrol_t      n_val   = false;
  Tcontrol_t      nn_val  = false;

  Tgeneral_data_t c_addr  = 0x100;
  Tgeneral_data_t n_addr  = 0x100;
  Tgeneral_data_t nn_addr = 0x100;

  Tcontrol_t      c_enable [_param->_nb_instruction];
  Tcontrol_t      n_enable [_param->_nb_instruction];

  Tcontrol_t      c_is_ds_take   = 0;
  Tcontrol_t      n_is_ds_take   = 0;		
  Tcontrol_t      nn_is_ds_take  = 0;

  c_enable [0] = 1;
  for (uint32_t i=1; i<_param->_nb_instruction; i++)
    c_enable [i] = 0;

  LABEL("Send Reset");
  do 
    {
      in_EVENT_VAL    ->write(1);
      in_EVENT_ADDRESS->write(n_addr);
      SC_START(1);  
    } while (out_EVENT_ACK->read() == false);
  in_EVENT_VAL    ->write(0);

  n_val = 1;
  
  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      // PREDICT
      {
	in_PREDICT_ACK  ->write((rand()%100)<percent_transaction_predict);
	
	SC_START(0);

	Taddress_t addr  = (out_PREDICT_PC_CURRENT_IS_DS_TAKE->read())?out_PREDICT_PC_PREVIOUS->read():out_PREDICT_PC_CURRENT->read();

	uint32_t   begin = addr%_param->_nb_instruction;
	uint32_t   end   = ((begin<<1)>_param->_nb_instruction)?(_param->_nb_instruction-1):(begin<<1);
	Tcontrol_t take  = (nb_packet%jump)==0;
	
	if (take)
	  addr += 0x100;
	else
	  addr += end-begin+1;

	for (uint32_t i=0; i<_param->_nb_instruction; i++)
	in_PREDICT_INSTRUCTION_ENABLE     [i] ->write((i>=begin) and (i<=end));
	in_PREDICT_PC_NEXT                    ->write(addr);
	in_PREDICT_PC_NEXT_IS_DS_TAKE         ->write(take);
	in_PREDICT_INST_IFETCH_PTR            ->write(0);
	in_PREDICT_BRANCH_STATE               ->write(0);
	in_PREDICT_BRANCH_UPDATE_PREDICTION_ID->write(0);
      }
      
      // ADDRESS
      {
	in_ADDRESS_ACK  ->write((rand()%100)<percent_transaction_address);
      }

      in_EVENT_VAL    ->write((rand()%100)<percent_transaction_event  );
      in_EVENT_ADDRESS->write(0x100);

      //-------------------------------------------------
      SC_START(0);
      //-------------------------------------------------

      if (out_PREDICT_VAL->read() and in_PREDICT_ACK->read())
	{
	  LABEL("PREDICT    : Transaction accepted");

	  if (c_val)
	  TEST(Tgeneral_address_t,out_PREDICT_PC_PREVIOUS          ->read(),c_addr      );
	  TEST(Tgeneral_address_t,out_PREDICT_PC_CURRENT           ->read(),n_addr      );
	  TEST(Tcontrol_t        ,out_PREDICT_PC_CURRENT_IS_DS_TAKE->read(),n_is_ds_take);

	  nn_val        = true;
	  nn_addr       = in_PREDICT_PC_NEXT           ->read();
	  nn_is_ds_take = in_PREDICT_PC_NEXT_IS_DS_TAKE->read();
	
	  for (uint32_t i=0; i<_param->_nb_instruction; i++)
	  n_enable [i]  = in_PREDICT_INSTRUCTION_ENABLE [i]->read();
	}
 
      if (out_ADDRESS_VAL->read() and in_ADDRESS_ACK->read())
	{
	  LABEL("ADDRESS    : Transaction accepted");
	  LABEL("  * address wait     : %.8x",c_addr);

	  TEST(Tgeneral_address_t,out_ADDRESS_INSTRUCTION_ADDRESS        ->read(),c_addr);
	  for (uint32_t i=0; i<_param->_nb_instruction; i++)
	  TEST(Tcontrol_t        ,out_ADDRESS_INSTRUCTION_ENABLE     [i] ->read(),c_enable[i]);
	  if (_param->_have_port_instruction_ptr)
	  TEST(Tinst_ifetch_ptr_t,out_ADDRESS_INST_IFETCH_PTR            ->read(),0);
	  TEST(Tbranch_state_t   ,out_ADDRESS_BRANCH_STATE               ->read(),0);
	  if (_param->_have_port_branch_update_prediction_id)
	  TEST(Tprediction_ptr_t ,out_ADDRESS_BRANCH_UPDATE_PREDICTION_ID->read(),0);

	  c_val = 0;
	  nb_packet ++;
	}


      if (not c_val)
	{
	  if (n_val and nn_val)
	    {
	      c_val        = 1;
	      c_addr       = n_addr;
	      c_is_ds_take = n_is_ds_take;

	      for (uint32_t i=0; i<_param->_nb_instruction; i++)
		c_enable [i] = n_enable [i];
	      
	      n_val        = 1;
	      n_addr       = nn_addr;
	      n_is_ds_take = nn_is_ds_take;
	      
	      nn_val       = 0;
	    }
	}

      if (in_EVENT_VAL->read() and out_EVENT_ACK->read())
	{
	  LABEL("EVENT      : Transaction accepted");

	  c_val           = false;
	  n_val           = true;
	  nn_val          = false;

	  n_addr         = in_EVENT_ADDRESS->read();
	  n_is_ds_take   = 0;

	  n_enable [0] = 1;
	  for (uint32_t i=1; i<_param->_nb_instruction; i++)
	    n_enable [i] = 0;
	}

      
      {
	string str_c_enable = "";
	string str_n_enable = "";

	for (uint32_t i=0; i<_param->_nb_instruction; i++)
	  {
	    str_c_enable += " " + toString(c_enable [i]);
	    str_n_enable += " " + toString(n_enable [i]);
	  }

	LABEL("-----------------------------------");
	LABEL("  * nb_packet : %d",nb_packet);
	LABEL("  * pc   : %d %d %.8x %s",c_val  ,c_is_ds_take , c_addr ,str_c_enable.c_str());
	if (nn_val)
	  {
	LABEL("  * pc+4 : %d %d %.8x %s",n_val  ,n_is_ds_take , n_addr ,str_n_enable.c_str());
	  }
	else
	  {
	LABEL("  * pc+4 : %d %d %.8x"   ,n_val  ,n_is_ds_take , n_addr );
	  }
	LABEL("  * pc+8 : %d %d %.8x"   ,nn_val ,nn_is_ds_take, nn_addr);
	LABEL("-----------------------------------");
      }

      SC_START(1);
      
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  delete    out_ADDRESS_VAL                        ;
  delete     in_ADDRESS_ACK                        ;
  delete    out_ADDRESS_INSTRUCTION_ADDRESS        ;
  delete [] out_ADDRESS_INSTRUCTION_ENABLE         ;
  delete    out_ADDRESS_INST_IFETCH_PTR            ;
  delete    out_ADDRESS_BRANCH_STATE               ;
  delete    out_ADDRESS_BRANCH_UPDATE_PREDICTION_ID;
  delete    out_PREDICT_VAL                        ;
  delete     in_PREDICT_ACK                        ;
  delete    out_PREDICT_PC_PREVIOUS                ;
  delete    out_PREDICT_PC_CURRENT                 ;
  delete    out_PREDICT_PC_CURRENT_IS_DS_TAKE      ;
  delete     in_PREDICT_PC_NEXT                    ;
  delete     in_PREDICT_PC_NEXT_IS_DS_TAKE         ;
  delete []  in_PREDICT_INSTRUCTION_ENABLE         ;
  delete     in_PREDICT_INST_IFETCH_PTR            ;
  delete     in_PREDICT_BRANCH_STATE               ;
  delete     in_PREDICT_BRANCH_UPDATE_PREDICTION_ID;
  delete     in_EVENT_VAL                          ;
  delete    out_EVENT_ACK                          ;
  delete     in_EVENT_ADDRESS                      ;
#endif

  delete _Address_management;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
