#ifdef STATISTICS
/*
 * $Id: Address_management_statistics_allocation.cpp 84 2008-05-13 18:04:50Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Address_management/include/Address_management.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {
namespace address_management {


#undef  FUNCTION
#define FUNCTION "Address_management::statistics_allocation"
  void Address_management::statistics_allocation (morpheo::behavioural::Parameters_Statistics * param_statistics)
  {
    log_printf(FUNC,Address_management,FUNCTION,"Begin");

    _stat = new Stat (static_cast<std::string>(_name),
		      "Address_management",
		      param_statistics);

    _stat_nb_transaction_address = _stat->create_variable("nb_transaction_address");
    _stat_nb_transaction_predict = _stat->create_variable("nb_transaction_predict");
    _stat_nb_transaction_event   = _stat->create_variable("nb_transaction_event"  );
    _stat_sum_packet_size        = _stat->create_variable("sum_packet_size"       );

    _stat->create_expr_average_by_cycle("average_transaction_address", "nb_transaction_address", "", _("Average transaction in Address interface by cycle"));
    _stat->create_expr_average_by_cycle("average_transaction_predict", "nb_transaction_predict", "", _("Average transaction in Predict interface by cycle"));
    _stat->create_expr_average_by_cycle("average_transaction_event"  , "nb_transaction_event"  , "", _("Average transaction in Event interface by cycle"  ));
    _stat->create_expr                 ("average_packet_size"        , "/ sum_packet_size nb_transaction_address", TYPE_COUNTER, "", _("Average of Packet size per request"));
    
    log_printf(FUNC,Address_management,FUNCTION,"End");
  };

}; // end namespace address_management
}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
