#!/bin/bash

#-----------------------------------------------------------
# $Id$
#-----------------------------------------------------------

#-----[ variable ]------------------------------------------

declare    test_ko="Test KO";
declare    test_ok="Test OK";
declare    tmp="${MORPHEO_HOME}/tmp/SelfTest";
declare    path="${MORPHEO_TOPLEVEL}/IPs/systemC/processor/Morpheo/Behavioural";

declare -a directory=(
    ""
    "Custom"

    "Generic/Counter"
    "Generic/Queue_Control"                                 
    "Generic/Queue"                                 
    "Generic/RegisterFile/RegisterFile_Monolithic"  
    "Generic/RegisterFile/RegisterFile_Multi_Banked"
    "Generic/RegisterFile"                          
    "Generic/Select/Select_Priority_Fixed"           
    "Generic/Select"                                
    "Generic/Shifter"                               
    "Generic/Sort"                                  
    "Generic/Victim/Victim_Pseudo_LRU"              
    "Generic/Victim"                                

    "Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Functionnal_unit/Operation"
    "Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Functionnal_unit"
    "Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Load_store_unit"
    "Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit"
    "Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit"
    "Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/Read_queue"
    "Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/Reservation_station"
    "Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit"
    "Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit"
    "Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Execute_queue"
    "Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Write_queue"
    "Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit"
    "Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit"
    "Core/Multi_Execute_loop/Execute_loop/Network/Execution_unit_to_Write_unit"
    "Core/Multi_Execute_loop/Execute_loop/Network/Read_unit_to_Execution_unit"
    "Core/Multi_Execute_loop/Execute_loop/Network"
    "Core/Multi_Execute_loop/Execute_loop/Register_unit/Register_unit_Glue"
    "Core/Multi_Execute_loop/Execute_loop/Register_unit"
#   "Core/Multi_Execute_loop/Execute_loop"
#   "Core/Multi_Execute_loop"

    "Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Load_Store_pointer_unit"
    "Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Dependency_checking_unit"
    "Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Free_List_unit"
    "Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Register_Address_Translation_unit"
    "Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Register_translation_unit_Glue"
    "Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Stat_List_unit"
    "Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit"
    "Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Rename_queue"
    "Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Rename_select"
    "Core/Multi_OOO_Engine/OOO_Engine/Rename_unit"
    "Core/Multi_OOO_Engine/OOO_Engine"
    "Core/Multi_OOO_Engine"
    
    "Core/Multi_Front_end/Front_end/Context_State"
    "Core/Multi_Front_end/Front_end/Decod_unit/Decod/Instruction"
    "Core/Multi_Front_end/Front_end/Decod_unit/Decod"
    "Core/Multi_Front_end/Front_end/Decod_unit/Decod_queue"
    "Core/Multi_Front_end/Front_end/Decod_unit"
    "Core/Multi_Front_end/Front_end/Ifetch_unit/Address_management"
    "Core/Multi_Front_end/Front_end/Ifetch_unit/Ifetch_queue"
    "Core/Multi_Front_end/Front_end/Ifetch_unit/Ifetch_unit_Glue"
    "Core/Multi_Front_end/Front_end/Ifetch_unit"
    "Core/Multi_Front_end/Front_end/Prediction_unit/Branch_Target_Buffer/Branch_Target_Buffer_Glue"
    "Core/Multi_Front_end/Front_end/Prediction_unit/Branch_Target_Buffer/Branch_Target_Buffer_Register"
    "Core/Multi_Front_end/Front_end/Prediction_unit/Branch_Target_Buffer"
    "Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Direction_Glue"
    "Core/Multi_Front_end/Front_end/Prediction_unit/Direction"
#   "Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Meta_Predictor_Glue"
#   "Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Two_Level_Branch_Predictor/Two_Level_Branch_Predictor_Glue"
#   "Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Two_Level_Branch_Predictor/Branch_History_Table"
#   "Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Two_Level_Branch_Predictor/Pattern_History_Table"
#   "Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Two_Level_Branch_Predictor"
#   "Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor"
    "Core/Multi_Front_end/Front_end/Prediction_unit/Prediction_unit_Glue"
    "Core/Multi_Front_end/Front_end/Prediction_unit/Return_Address_Stack"
    "Core/Multi_Front_end/Front_end/Prediction_unit/Update_Prediction_Table"
    "Core/Multi_Front_end/Front_end/Prediction_unit"
    "Core/Multi_Front_end/Front_end"
    "Core/Multi_Front_end"

    );
                                           

#-----[ usage ]---------------------------------------------
function usage ()
{
    echo "Usage          : ${0} action";
    echo "Arguments      : ";
    echo " * action";
    echo "   * test      : test all component";
    echo '                 for each component, create file in ${MORPHEO_HOME}/tmp/';
    echo "   * test_all  : same as test, but don't stop at the first error";
    echo "   * res       : list test's resultat";
    echo "   * list      : list test's resultat";
    echo "   * clean     : erase file in ${MORPHEO_HOME}/tmp/ directory";
    echo "   * clean_all : clean all component";
    echo "   * help      : print this message";
    echo "";
    echo "Notes          : ";
    echo " * Morpheo environment must be positionned";
    exit;
}

#-----[ main ]----------------------------------------------
function main ()
{
    # Test operand
    if test ${#} -ne 1; then
	usage ${*};
    fi;

    if test -z ${MORPHEO_TOPLEVEL}; then
	usage ${*};
    fi;

    if test ! -d ${tmp}; then
	mkdir ${tmp};
    fi;

    nb_cpu=$(cat /proc/cpuinfo |grep -c processor);
    pwd=${PWD};
    case ${1} in
	"test" | "test_all")
	    for i in ${directory[@]}; do
		component=$(basename ${i});
		dir="${path}/${i}/SelfTest";

		if test -d "${dir}"; then
		    # have previous test ok ?
		    declare -i make_test=1;
		    
		    if test -f ${tmp}/${component}; then
			res_test=$(cat ${tmp}/${component});
			if test "${test_ok}" = "${res_test}"; then
			    make_test=0;
			fi;
		    fi;

		    if test ${make_test} -eq 1; then
			cd ${dir};
			make config;
			make -j${nb_cpu} execute;
			case ${?} in
			    "0")
				echo ${test_ok} > ${tmp}/"${component}";
				;;
			    *)

				echo ${test_ko} > ${tmp}/"${component}";
				echo "";
				echo "${component} : ${test_ko}";
				echo "";
				if test ${1} = "test"; then
				    exit 1;
				fi;
				;;
			esac;
		    fi;
		else
		    echo "${component} have not SelfTest directory.";
		fi;

		cd ${pwd};
	    done;
	    ;;

	"res")
	    for i in ${tmp}/*; do
		if test -f ${i}; then
		    component=$(basename ${i});
		    res_test=$(cat ${i});

		    
		    case "${res_test}" in
			"${test_ok}") color=32; 
			    ;;
			"${test_ko}") color=31; 
			    ;;
			*)            color=39; 
			    ;;
		    esac
		    echo "[1;${color}m${res_test} - ${component}[1;0m";
		fi;
	    done;
	    ;;

	"list")
	    for i in ${directory[@]}; do
		component=$(basename ${i});
		echo "${i}";
	    done;
	    ;;

	"clean")
	    rm -r ${tmp};
	    ;;
	    
	"clean_all")
	    for i in ${directory[@]}; do
		component=$(basename ${i});

		cd ${path}/${i};
		make clean;
		dir="SelfTest";

		if test -d ${dir}; then
		    cd ${dir};
		    make clean;
		else
		    echo "${component} have not SelfTest directory.";
		fi;
		cd ${pwd};

	    done;
	    ;;

	"help")
	    usage ${*};
	    ;;
	*)
	    usage ${*};
    esac
}

#-----[ Body ]----------------------------------------------
main ${*};

