/*
 * $Id: Parameters.cpp 87 2008-05-15 19:23:42Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/include/Parameters.h"
#include "Common/include/Max.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {


#undef  FUNCTION
#define FUNCTION "Decod_unit::Parameters"
  Parameters::Parameters (uint32_t            nb_context                   ,
			  uint32_t          * nb_inst_fetch                ,
			  uint32_t            nb_inst_decod                ,
			  uint32_t            size_queue                   ,
			  uint32_t            size_general_data            ,
			  uint32_t          * nb_branch_speculated         ,
			  uint32_t            size_branch_update_prediction,
			  uint32_t            nb_context_select            ,
			  Tpriority_t         select_priority              ,
			  Tload_balancing_t   select_load_balancing        ,
			  bool             ** instruction_implemeted       ,
			  morpheo::behavioural::custom::custom_information_t (*get_custom_information) (uint32_t))
  {
    log_begin(Decod_unit,FUNCTION);

    _nb_context                    = nb_context                   ;
    _nb_inst_fetch                 = nb_inst_fetch                ;
    _nb_inst_decod                 = nb_inst_decod                ;
    _size_queue                    = size_queue                   ;
    _size_general_data             = size_general_data            ;
    _nb_branch_speculated          = nb_branch_speculated         ;
    _size_branch_update_prediction = size_branch_update_prediction;
    _nb_context_select             = nb_context_select            ;
    _select_priority               = select_priority              ;
    _select_load_balancing         = select_load_balancing        ;
    _instruction_implemeted        = instruction_implemeted       ;
    _get_custom_information        = get_custom_information       ;

    _max_nb_inst_fetch                     = max<uint32_t>(_nb_inst_fetch,_nb_context);

    _size_address_inst                     = size_general_data-2;
    _size_context_id                       = log2(nb_context          );
    _size_depth                            = log2(max<uint32_t>(_nb_branch_speculated,_nb_context));
    _size_inst_ifetch_ptr                  = log2(_max_nb_inst_fetch  );

    _have_port_context_id                  = (_size_context_id > 0);
    _have_port_depth                       = (_size_depth      > 0);
    _have_port_branch_update_prediction_id = (_size_branch_update_prediction > 0);
    _have_port_inst_ifetch_ptr             = (_size_inst_ifetch_ptr > 0);
    
    test();

    _param_decod = new morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod::Parameters
      (_nb_context                   ,
       _nb_inst_fetch                ,
       _nb_inst_decod                ,
       max<uint32_t>(_nb_branch_speculated,_nb_context),
       _size_branch_update_prediction,
       _nb_context_select            ,
       _size_general_data            ,
       _select_priority              ,
       _select_load_balancing        ,
       _instruction_implemeted       ,
       _get_custom_information);

    _param_decod_queue = new morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod_queue::Parameters
      (_nb_context          ,
       _nb_inst_decod       ,
       _size_queue          ,
       _size_general_data   ,
       _nb_branch_speculated);

    _size_nb_inst_decod = _param_decod_queue->_size_nb_inst;
    
    log_end(Decod_unit,FUNCTION);
  };
  
// #undef  FUNCTION
// #define FUNCTION "Decod_unit::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_begin(Decod_unit,FUNCTION);
//     test();
//     log_end(Decod_unit,FUNCTION);
//   };

#undef  FUNCTION
#define FUNCTION "Decod_unit::~Parameters"
  Parameters::~Parameters () 
  {
    log_begin(Decod_unit,FUNCTION);

    delete _param_decod;
    delete _param_decod_queue;

    log_end(Decod_unit,FUNCTION);
  };

}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
