#ifndef morpheo_max
#define morpheo_max

/*
 * $Id: Max.h 87 2008-05-15 19:23:42Z rosiere $
 *
 * [ Description ]
 * 
 */

#include <stdint.h>

namespace morpheo {

  template<typename T> inline T max (const T * x, uint32_t size)
  {
    T res = x[0];

    for (uint32_t i=1; i<size; i++)
      if (res<x[i])
	res = x[i];

    return res;
  }

  template<typename T> inline T max (const T * x, uint32_t size, uint32_t n)
  {
    if ((n==0) or (n>size))
      return max<T>(x,size);

    // validity array
    bool val [size];
    for (uint32_t i=0; i<size; i++)
      val [i] = true;

    // find min
    T min = x[0];

    for (uint32_t i=1; i<size; i++)
      if (min>x[i])
	min = x[i];
    
    // find n max
    T res = min;
    for (uint32_t i=0; i<n; i++)
      {

	uint32_t index = 0;
	res = min; // always take the minor
	for (uint32_t j=0; j<size; j++)
	  if ((res<x[j]) and val[j]) // find greater value, and slot is valid
	    {
	      res   = x[j];
	      index = j;
	    }
	val [index] = false; // invalid this value
      }

    return res;
  }

  
}; // end namespace morpheo              

#endif
