/*
 * $Id: main.cpp 87 2008-05-15 19:23:42Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod/SelfTest/include/test.h"
#include "Behavioural/Custom/include/Custom_example.h"

#define NB_PARAMS 8

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_(" * nb_context                                (uint32_t         )\n"));
  err (_(" * nb_inst_fetch                [nb_context] (uint32_t         )\n"));
  err (_(" * nb_inst_decod                             (uint32_t         )\n"));
  err (_(" * nb_branch_speculated                      (uint32_t         )\n"));
  err (_(" * size_branch_update_prediction             (uint32_t         )\n"));
  err (_(" * nb_context_select                         (uint32_t         )\n"));
  err (_(" * size_general_data                         (uint32_t         )\n"));
  err (_(" * priority                                  (Tpriority_t      )\n"));
  err (_(" * load_balancing                            (Tload_balancing_t)\n"));

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc < static_cast<int>(2+NB_PARAMS))
    usage (argc, argv);

  uint32_t x = 1;

  string name = argv[x++];
  uint32_t            _nb_context           = fromString<uint32_t         >(argv[x++]);

  if (argc != static_cast<int>(2+NB_PARAMS+_nb_context))
    usage (argc, argv);
  
  uint32_t          * _nb_inst_fetch        = new uint32_t [_nb_context];
  for (uint32_t i=0;i<_nb_context; i++)
    _nb_inst_fetch [i] = fromString<uint32_t>(argv[x++]);

  uint32_t            _nb_inst_decod                = fromString<uint32_t         >(argv[x++]);
  uint32_t            _nb_branch_speculated         = fromString<uint32_t         >(argv[x++]);
  uint32_t            _size_branch_update_prediction= fromString<uint32_t         >(argv[x++]);
  uint32_t            _nb_context_select            = fromString<uint32_t         >(argv[x++]);
  uint32_t            _size_general_data            = fromString<uint32_t         >(argv[x++]);
  Tpriority_t         _priority                     = fromString<Tpriority_t      >(argv[x++]);
  Tload_balancing_t   _load_balancing               = fromString<Tload_balancing_t>(argv[x++]);

  bool             ** _instruction_implemeted = new bool * [_nb_context];
  for (uint32_t i=0; i<_nb_context; i++)
    {
      _instruction_implemeted [i] = new bool [NB_INSTRUCTION];
      
      for (uint32_t j=0; j<NB_INSTRUCTION; j++)
	_instruction_implemeted [i][j] = true;
    }

  int _return = EXIT_SUCCESS;
  try 
    {
      morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod::Parameters * param = new morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod::Parameters
	(_nb_context                   ,
	 _nb_inst_fetch                ,
	 _nb_inst_decod                ,
	 _nb_branch_speculated         ,
	 _size_branch_update_prediction,
	 _nb_context_select            ,
	 _size_general_data            ,
	 _priority                     ,
	 _load_balancing               ,
	 _instruction_implemeted       ,
	 &(morpheo::behavioural::custom::example_get_custom_information)
	 );
      
      msg(_("%s"),param->print(1).c_str());
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }
  catch (...)
    {
      err (_("<%s> : This test must generate a error.\n"),name.c_str());
      _return = EXIT_FAILURE;
    }

  delete _nb_inst_fetch;
  delete _instruction_implemeted;
  return (_return);
}
