/*
 * $Id: Parameters_msg_error.cpp 87 2008-05-15 19:23:42Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod/include/Parameters.h"
#include "Common/include/Max.h"
#include <sstream>

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {
namespace decod {


#undef  FUNCTION
#define FUNCTION "Decod::msg_error"
  Parameters_test Parameters::msg_error(void)
  {
    log_printf(FUNC,Decod,FUNCTION,"Begin");
    
    Parameters_test test("Decod");

    if (_nb_inst_decod == 0)
      test.error(_("nb_inst_decod must be > 0.\n"));

    if ((_size_general_data != 32) and
	(_size_general_data != 64))
      test.error(_("size_general_data must be equal at 32 or 64 bits.\n"));

    if ((_nb_branch_speculated == 0) or
	(_nb_branch_speculated > _nb_context))
      test.error(_("nb_branch_speculated must be in [1:nb_context].\n"));

    if ((_nb_context_select == 0) or
        (_nb_context_select > _nb_context))
      test.error(_("nb_context_select must be in [1:nb_context].\n"));

    uint32_t sum_inst_fetch = 0;
    for (uint32_t i=0; i<_nb_context_select; i++)
      sum_inst_fetch += max<uint32_t>(_nb_inst_fetch,_nb_context,i+1);

    if (sum_inst_fetch < _nb_inst_decod)
      test.error(_("The sum of the _nb_context_select most nb_inst_fetch must be greater that _nb_inst_decod"));

    if ((_priority != PRIORITY_ROUND_ROBIN))
      test.error(toString(_("Unsupported priority scheme. Supported scheme are : %s.\n"),toString(PRIORITY_ROUND_ROBIN).c_str()));
    
    if ((_load_balancing != LOAD_BALANCING_MAXIMUM_FOR_PRIORITY))
      test.error(toString(_("Unsupported load_balancing scheme. Supported scheme are : %s.\n"),toString(LOAD_BALANCING_MAXIMUM_FOR_PRIORITY).c_str()));

    return test;

    log_printf(FUNC,Decod,FUNCTION,"End");
  };

}; // end namespace decod
}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
