/*
 * $Id: sc_main.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 * Platforms : Morpheo + Environment
 */

#include "../include/test.h"

using namespace std;
using namespace morpheo;

void usage (int argc, char * argv[])
{
  cerr <<  "<Usage> " << argv[0] << " list_params." << endl
       <<  "list_params is :" << endl
       <<  " * filename_simulator   (string  )" << endl
       <<  " * filename_generator   (string  )" << endl
       <<  " * filename_instance    (string  )" << endl
       <<  " * filename_software    (string  )" << endl
       <<  " * nb_cache_dedicated   (uint32_t)" << endl
       <<  " * nb_cache_shared      (uint32_t)" << endl
       <<  " * size cache L1 (byte) (uint32_t)" << endl
       <<  " * ratio cache          (uint32_t)" << endl;
  exit (EXIT_FAILURE);
}

int sc_main (int argc, char * argv[])
{
  cout << "<sc_main> Begin" << endl;

  for (int32_t i=0; i<argc; ++i)
    cout << argv[i] << " ";
  cout << endl;

  //==============================================================================
  //===== [ Parameters ]==========================================================
  //==============================================================================

  if (argc != 9)
    usage (argc, argv);

  uint32_t x = 1;
  string   filename_simulator = argv[x++];
  string   filename_generator = argv[x++];
  string   filename_instance  = argv[x++];
  string   filename_software  = argv[x++];
  uint32_t nb_cache_dedicated = fromString<uint32_t>(argv[x++]);
  uint32_t nb_cache_shared    = fromString<uint32_t>(argv[x++]);
  uint32_t cache_size         = fromString<uint32_t>(argv[x++]);
  uint32_t cache_ratio        = fromString<uint32_t>(argv[x++]);

  morpheo::behavioural::custom::custom_information_t (*get_custom_information) (void) = NULL;

  int _return = test (filename_simulator ,
                      filename_generator ,
                      filename_instance  ,
                      filename_software  ,
                      nb_cache_dedicated ,
                      nb_cache_shared    ,
                      cache_size         ,
                      cache_ratio        ,
                      get_custom_information);

  cout << "<sc_main> End" << endl;  

  return _return;
}
