#ifndef morpheo_behavioural_core_multi_front_end_front_end_context_state_Parameters_h
#define morpheo_behavioural_core_multi_front_end_front_end_context_state_Parameters_h

/*
 * $Id: Parameters.h 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Parameters.h"
#include "Common/include/Debug.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace context_state {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------

  public : uint32_t   _nb_context                   ;
  public : uint32_t   _nb_decod_unit                ;
  public : uint32_t   _nb_inst_branch_complete      ;
  public : uint32_t * _array_size_depth             ; //[nb_context]
//public : uint32_t * _size_depth                   ; //[nb_context]
//public : uint32_t   _size_address                 ;
//public : uint32_t * _size_nb_inst_decod           ; //[nb_decod_unit]
//public : uint32_t   _size_nb_inst_commit          ;
  public : uint32_t * _link_context_to_decod_unit   ; //[nb_context]

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t   nb_context,
			uint32_t   nb_decod_unit,
			uint32_t   nb_inst_branch_complete,
			uint32_t * size_depth,                
			uint32_t   size_address,
			uint32_t * size_nb_inst_decod,           
			uint32_t   size_nb_inst_commit,          
			uint32_t * link_context_to_decod_unit,
                        bool       is_toplevel=false);
//   public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  public :        std::string     print      (uint32_t depth);
  public : friend std::ostream&   operator<< (std::ostream& output_stream,
					      morpheo::behavioural::core::multi_front_end::front_end::context_state::Parameters & x);
  };

}; // end namespace context_state
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
