#ifndef Morpheo_Time_h
#define Morpheo_Time_h

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <string>
#include <iostream>
#include <sys/time.h>

namespace morpheo {

class Time 
{
#ifdef SYSTEMC
private : double   nb_cycles_begin;
#endif
private : timeval  time_begin;
// private : timeval time_end;
  
public  : Time ()
  { 
#ifdef SYSTEMC
    nb_cycles_begin = sc_simulation_time();
#endif
    gettimeofday(&time_begin,NULL);
  };
  
public  : ~Time ()
  {
    std::cout << *this;
  };

public  : friend std::ostream& operator<< (std::ostream& output,
					   const Time & x)
  {
    timeval time_end;
    
    gettimeofday(&time_end,NULL);
    
#ifdef SYSTEMC
    double nb_cycles_end = sc_simulation_time();
    double average       = static_cast<double>(nb_cycles_end-x.nb_cycles_begin+1) / static_cast<double>(time_end.tv_sec-x.time_begin.tv_sec+1);
    
    output << "Timing : " << nb_cycles_end << " cycles \t(" << average << " cycles/s)" << std::endl;
#else
    double average       = static_cast<double>(time_end.tv_sec-x.time_begin.tv_sec+1);
    
    output << "Timing : " average << " s" << std::endl;
#endif
    
    return output;
  }
};

}; // end namespace morpheo

#endif
