/*
 * $Id: Issue_queue.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Issue_queue/include/Issue_queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace issue_queue {


#undef  FUNCTION
#define FUNCTION "Issue_queue::Issue_queue"
  Issue_queue::Issue_queue 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_ooo_engine::ooo_engine::issue_queue::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_begin(Issue_queue,FUNCTION);

    usage_environment(_usage);

#if DEBUG_Issue_queue == true
    log_printf(INFO,Issue_queue,FUNCTION,_("<%s> Parameters"),_name.c_str());

    std::cout << *param << std::endl;
#endif    

    log_printf(INFO,Issue_queue,FUNCTION,_("<%s> : Allocation"),_name.c_str());

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Issue_queue,FUNCTION,_("<%s> : Allocation of statistics"),_name.c_str());

	statistics_allocation(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Issue_queue,FUNCTION,_("<%s> : Generate the vhdl"),_name.c_str());
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	log_printf(INFO,Issue_queue,FUNCTION,_("<%s> : Method - transition"),_name.c_str());

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Issue_queue,FUNCTION,_("<%s> : Method - genMoore"),_name.c_str());

	SC_METHOD (genMoore);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg(); // need internal register
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Issue_queue,FUNCTION,_("<%s> : Method - genMealy"),_name.c_str());

	SC_METHOD (genMealy);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg(); // need internal register
	for (uint32_t i=0; i<_param->_nb_inst_reexecute; i++)
	  sensitive << (*(in_REEXECUTE_VAL  [i])) 
		    << (*(in_REEXECUTE_TYPE [i]));
	for (uint32_t i=0; i<_param->_nb_rename_unit; i++)
	  for (uint32_t j=0; j<_param->_nb_inst_rename[i]; j++)
	    sensitive // << (*(in_ISSUE_IN_VAL  [i][j])) 
		      << (*(in_ISSUE_IN_TYPE [i][j]));
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
	for (uint32_t i=0; i<_param->_nb_inst_reexecute; i++)
	  for (uint32_t x=0; x<_param->_nb_inst_reexecute; x++)
	    {
	      (*(out_REEXECUTE_ACK [i])) (*(in_REEXECUTE_VAL  [x]));
	      (*(out_REEXECUTE_ACK [i])) (*(in_REEXECUTE_TYPE [x]));
	    }

	for (uint32_t i=0; i<_param->_nb_rename_unit; i++)
	  for (uint32_t j=0; j<_param->_nb_inst_rename[i]; j++)
	    {
	      for (uint32_t x=0; x<_param->_nb_inst_reexecute; x++)
		{
		  (*(out_ISSUE_IN_ACK [i][j])) (*(in_REEXECUTE_VAL  [x]));
		  (*(out_ISSUE_IN_ACK [i][j])) (*(in_REEXECUTE_TYPE [x]));
		}

	      for (uint32_t x=0; x<_param->_nb_rename_unit; x++)
		for (uint32_t y=0; y<_param->_nb_inst_rename[x]; y++)
		  {
		    (*(out_ISSUE_IN_ACK [i][j])) (*(in_ISSUE_IN_VAL  [x][y]));
		    (*(out_ISSUE_IN_ACK [i][j])) (*(in_ISSUE_IN_TYPE [x][y]));
		  }
	    }
# endif    
	
#endif
      }
    log_end(Issue_queue,FUNCTION);
  };
    
#undef  FUNCTION
#define FUNCTION "Issue_queue::~Issue_queue"
  Issue_queue::~Issue_queue (void)
  {
    log_begin(Issue_queue,FUNCTION);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,Issue_queue,FUNCTION,_("<%s> : Deallocation"),_name.c_str());

    deallocation ();

    log_end(Issue_queue,FUNCTION);
  };

}; // end namespace issue_queue
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
