/*
 * $Id: test.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#include "Behavioural/Configuration/SelfTest/include/test.h"
#include "Behavioural/Custom/include/Custom_default.h"
#include "Behavioural/Custom/include/Custom_example.h"

void test (string name)
{
  morpheo::behavioural::custom::custom_information_t (*_get_custom_information) (void) = &(morpheo::behavioural::custom::default_get_custom_information);

  cout << "------------------------------------------------------" << endl;

  Simulator * simulator1 = new Simulator ("../../../Files/Morpheo.sim");
  
//cout << *simulator1 << endl;
  
  simulator1->toFile("data_out");

  cout << "------------------------------------------------------" << endl;

  Generator * generator1 = new Generator ("../../../Files/Morpheo.gen");

//cout << *generator1 << endl;

  generator1->toFile("data_out");

  cout << "------------------------------------------------------" << endl;

  Instance * instance1 = new Instance ("../../../Files/Instance_min.cfg",
                                   generator1,
                                   _get_custom_information
                                   );
  
//   cout << *instance1 << endl;

  instance1->toFile("data_out");

  cout << "------------------------------------------------------" << endl;
  
  Configuration * configuration1 = new Configuration("../../../Files/Morpheo.sim",
                                           "../../../Files/Morpheo.gen",
                                           "../../../Files/Instance_min.cfg",
                                           _get_custom_information);

//cout << *configuration1 << endl;

  configuration1->toFile("data_out");

  {
    cout << "------------------------------------------------------" << endl;

    Instance * instance = new Instance ("../../../Files/Instance_scalar_1.cfg",
                                        generator1,
                                        _get_custom_information
                                        );
    instance->toFile("data_out");
    
    delete instance;
  }

  {
    cout << "------------------------------------------------------" << endl;

    Instance * instance = new Instance ("../../../Files/Instance_scalar_2.cfg",
                                        generator1,
                                        _get_custom_information
                                        );
    instance->toFile("data_out");
    
    delete instance;
  }

  delete configuration1;
  delete instance1;
  delete generator1;
  delete simulator1;


}
