#ifdef SYSTEMC
/*
 * $Id: Core_Glue_genMealy_issue.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Core_Glue/include/Core_Glue.h"
#include "Common/include/Max.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace core_glue {


#undef  FUNCTION
#define FUNCTION "Core_Glue::genMealy_issue"
  void Core_Glue::genMealy_issue (void)
  {
    log_begin(Core_Glue,FUNCTION);
    log_function(Core_Glue,FUNCTION,_name.c_str());

    Tcontrol_t ISSUE_OOO_ENGINE_ACK   [_param->_nb_ooo_engine  ][_param->_max_nb_inst_issue];
    Tcontrol_t ISSUE_EXECUTE_LOOP_VAL [_param->_nb_execute_loop][_param->_max_nb_read_unit ];
    bool       READ_UNIT_ENABLE       [_param->_nb_execute_loop][_param->_max_nb_read_unit ];

    for (uint32_t i=0; i<_param->_nb_ooo_engine; ++i)
      for (uint32_t j=0; j<_param->_nb_inst_issue[i]; ++j)
        ISSUE_OOO_ENGINE_ACK [i][j] = 0;
    for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_param->_nb_read_unit[i]; ++j)
        {
          ISSUE_EXECUTE_LOOP_VAL [i][j] = 0;
          // Read unit is enable is signal ack is set
          READ_UNIT_ENABLE       [i][j] = (PORT_READ(in_ISSUE_EXECUTE_LOOP_ACK [i][j]) == 1);
        }

    for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
      {
        log_printf(TRACE,Core_Glue,FUNCTION,"  * execute_loop [%d]",i);

        std::list<generic::priority::select_t> * select = _priority[i] ->select();
        for (std::list<generic::priority::select_t>::iterator it=select ->begin();
             it!=select->end();
             ++it)
          {
            const uint32_t ooo_engine_id  = it->grp;
            const uint32_t num_ooo_engine = _param->_translate_execute_loop_num_ooo_engine [i][ooo_engine_id];
            const uint32_t num_inst_issue = it->elt;

            log_printf(TRACE,Core_Glue,FUNCTION,"    * num_ooo_engine [%d] (id : %d)",num_ooo_engine, ooo_engine_id);
            log_printf(TRACE,Core_Glue,FUNCTION,"    * num_inst_issue          : %d",num_inst_issue);
            log_printf(TRACE,Core_Glue,FUNCTION,"    * ISSUE_OOO_ENGINE_VAL    : %d",PORT_READ(in_ISSUE_OOO_ENGINE_VAL [num_ooo_engine][num_inst_issue]));

            // have request ?
            if (PORT_READ(in_ISSUE_OOO_ENGINE_VAL [num_ooo_engine][num_inst_issue]))
              {
//              // If ooo_engine can issue instruction on multiple execute_loop
//              if (not ISSUE_OOO_ENGINE_ACK [num_ooo_engine][num_inst_issue])
                for (uint32_t j=0; j<_param->_nb_read_unit[i]; ++j)
                  // Test if have an link and read unit is enable
                  {
                  log_printf(TRACE,Core_Glue,FUNCTION,"    * read_unit               : %d",j);
                  log_printf(TRACE,Core_Glue,FUNCTION,"      * READ_UNIT_ENABLE      : %d",READ_UNIT_ENABLE [i][j]);
                  log_printf(TRACE,Core_Glue,FUNCTION,"      * table_dispatch        : %d",_param->_table_dispatch [num_ooo_engine][num_inst_issue][i][j]);

                  if (READ_UNIT_ENABLE [i][j] and 
                      _param->_table_dispatch [num_ooo_engine][num_inst_issue][i][j])
                    {
                      // Transaction
                      ISSUE_EXECUTE_LOOP_VAL [i][j] = 1;
                      ISSUE_OOO_ENGINE_ACK   [num_ooo_engine][num_inst_issue] = 1;
                      READ_UNIT_ENABLE       [i][j] = false; // now, this read_unit is busy

                      if (_param->_have_port_context_id)
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_CONTEXT_ID            [i][j],PORT_READ(in_ISSUE_OOO_ENGINE_CONTEXT_ID            [num_ooo_engine][num_inst_issue]));
                      if (_param->_have_port_front_end_id)
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_FRONT_END_ID          [i][j],PORT_READ(in_ISSUE_OOO_ENGINE_FRONT_END_ID          [num_ooo_engine][num_inst_issue]));
                      if (_param->_have_port_ooo_engine_id)
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_OOO_ENGINE_ID         [i][j],ooo_engine_id);
                      if (_param->_have_port_rob_ptr)
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_PACKET_ID             [i][j],PORT_READ(in_ISSUE_OOO_ENGINE_PACKET_ID             [num_ooo_engine][num_inst_issue]));
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_OPERATION             [i][j],PORT_READ(in_ISSUE_OOO_ENGINE_OPERATION             [num_ooo_engine][num_inst_issue]));
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_TYPE                  [i][j],PORT_READ(in_ISSUE_OOO_ENGINE_TYPE                  [num_ooo_engine][num_inst_issue]));
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_STORE_QUEUE_PTR_WRITE [i][j],PORT_READ(in_ISSUE_OOO_ENGINE_STORE_QUEUE_PTR_WRITE [num_ooo_engine][num_inst_issue]));
                      if (_param->_have_port_load_queue_ptr)
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_LOAD_QUEUE_PTR_WRITE  [i][j],PORT_READ(in_ISSUE_OOO_ENGINE_LOAD_QUEUE_PTR_WRITE  [num_ooo_engine][num_inst_issue]));
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_HAS_IMMEDIAT          [i][j],PORT_READ(in_ISSUE_OOO_ENGINE_HAS_IMMEDIAT          [num_ooo_engine][num_inst_issue]));
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_IMMEDIAT              [i][j],PORT_READ(in_ISSUE_OOO_ENGINE_IMMEDIAT              [num_ooo_engine][num_inst_issue]));
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_READ_RA               [i][j],PORT_READ(in_ISSUE_OOO_ENGINE_READ_RA               [num_ooo_engine][num_inst_issue]));
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_NUM_REG_RA            [i][j],PORT_READ(in_ISSUE_OOO_ENGINE_NUM_REG_RA            [num_ooo_engine][num_inst_issue]));
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_READ_RB               [i][j],PORT_READ(in_ISSUE_OOO_ENGINE_READ_RB               [num_ooo_engine][num_inst_issue]));
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_NUM_REG_RB            [i][j],PORT_READ(in_ISSUE_OOO_ENGINE_NUM_REG_RB            [num_ooo_engine][num_inst_issue]));
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_READ_RC               [i][j],PORT_READ(in_ISSUE_OOO_ENGINE_READ_RC               [num_ooo_engine][num_inst_issue]));
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_NUM_REG_RC            [i][j],PORT_READ(in_ISSUE_OOO_ENGINE_NUM_REG_RC            [num_ooo_engine][num_inst_issue]));
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_WRITE_RD              [i][j],PORT_READ(in_ISSUE_OOO_ENGINE_WRITE_RD              [num_ooo_engine][num_inst_issue]));
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_NUM_REG_RD            [i][j],PORT_READ(in_ISSUE_OOO_ENGINE_NUM_REG_RD            [num_ooo_engine][num_inst_issue]));
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_WRITE_RE              [i][j],PORT_READ(in_ISSUE_OOO_ENGINE_WRITE_RE              [num_ooo_engine][num_inst_issue]));
                      PORT_WRITE(out_ISSUE_EXECUTE_LOOP_NUM_REG_RE            [i][j],PORT_READ(in_ISSUE_OOO_ENGINE_NUM_REG_RE            [num_ooo_engine][num_inst_issue]));
                    }            
                  }
              }
          }
      }

    // Write output
    for (uint32_t i=0; i<_param->_nb_ooo_engine; ++i)
      for (uint32_t j=0; j<_param->_nb_inst_issue[i]; ++j)
        PORT_WRITE(out_ISSUE_OOO_ENGINE_ACK [i][j], ISSUE_OOO_ENGINE_ACK [i][j]);
    for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_param->_nb_read_unit[i]; ++j)
        PORT_WRITE(out_ISSUE_EXECUTE_LOOP_VAL [i][j], ISSUE_EXECUTE_LOOP_VAL [i][j]);

    log_end(Core_Glue,FUNCTION);
  };

}; // end namespace core_glue
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
