/*
 * $Id: Dcache_Access.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Dcache_Access/include/Dcache_Access.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace dcache_access {


#undef  FUNCTION
#define FUNCTION "Dcache_Access::Dcache_Access"
  Dcache_Access::Dcache_Access 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::dcache_access::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_begin(Dcache_Access,FUNCTION);

    usage_environment(_usage);

#if DEBUG_Dcache_Access == true
    log_printf(INFO,Dcache_Access,FUNCTION,_("<%s> Parameters"),_name.c_str());

    std::cout << *param << std::endl;
#endif    

    log_printf(INFO,Dcache_Access,FUNCTION,_("<%s> : Allocation"),_name.c_str());

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Dcache_Access,FUNCTION,_("<%s> : Allocation of statistics"),_name.c_str());

	statistics_allocation(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Dcache_Access,FUNCTION,_("<%s> : Generate the vhdl"),_name.c_str());
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	log_printf(INFO,Dcache_Access,FUNCTION,_("<%s> : Method - transition"),_name.c_str());

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

// 	log_printf(INFO,Dcache_Access,FUNCTION,_("<%s> : Method - genMoore"),_name.c_str());

// 	SC_METHOD (genMoore);
// 	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg(); // need internal register
	
// # ifdef SYSTEMCASS_SPECIFIC
// 	// List dependency information
// # endif    

	log_printf(INFO,Dcache_Access,FUNCTION,_("<%s> : Method - genMealy_req"),_name.c_str());

	SC_METHOD (genMealy_req);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg(); // need internal register
	for (uint32_t i=0; i<_param->_nb_dcache_port; ++i)
	  sensitive << (*(in_DCACHE_REQ_ACK [i]));
	for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
	  for (uint32_t j=0; j<_param->_nb_load_store_unit[i]; ++j)
	    for (uint32_t k=0; k<_param->_nb_cache_access [i][j]; ++k)
	      {
		sensitive << (*(in_LSQ_REQ_VAL       [i][j][k]))
			  << (*(in_LSQ_REQ_ADDRESS   [i][j][k]))
			  << (*(in_LSQ_REQ_WDATA     [i][j][k]))
			  << (*(in_LSQ_REQ_TYPE      [i][j][k]));
		
		if (_param->_have_port_lsq_thread_id [i][j])
		  sensitive << (*(in_LSQ_REQ_THREAD_ID [i][j][k]));
		if (_param->_have_port_lsq_packet_id [i][j])
		sensitive << (*(in_LSQ_REQ_PACKET_ID [i][j][k]));
	      }


# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Dcache_Access,FUNCTION,_("<%s> : Method - genMealy_rsp"),_name.c_str());

	SC_METHOD (genMealy_rsp);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg(); // need internal register

	for (uint32_t i=0; i<_param->_nb_dcache_port; ++i)
	  {
	    sensitive << (*(in_DCACHE_RSP_VAL       [i]))
		      << (*(in_DCACHE_RSP_RDATA     [i]))
		      << (*(in_DCACHE_RSP_ERROR     [i]));
	    if (_param->_have_port_dcache_thread_id)
	    sensitive << (*(in_DCACHE_RSP_THREAD_ID [i]));
	    if (_param->_have_port_dcache_packet_id)
	    sensitive << (*(in_DCACHE_RSP_PACKET_ID [i]));

	  }
	for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
	  for (uint32_t j=0; j<_param->_nb_load_store_unit[i]; ++j)
	    for (uint32_t k=0; k<_param->_nb_cache_access [i][j]; ++k)
	      sensitive << (*(in_LSQ_RSP_ACK [i][j][k]));



# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

#endif
      }
    log_end(Dcache_Access,FUNCTION);
  };
    
#undef  FUNCTION
#define FUNCTION "Dcache_Access::~Dcache_Access"
  Dcache_Access::~Dcache_Access (void)
  {
    log_begin(Dcache_Access,FUNCTION);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,Dcache_Access,FUNCTION,_("<%s> : Deallocation"),_name.c_str());
    deallocation ();

    log_end(Dcache_Access,FUNCTION);
  };

}; // end namespace dcache_access
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
