/*
 * $Id: main.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Execute_loop_Glue/SelfTest/include/test.h"

#define NB_PARAMS 7

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_(" * nb_gpr_write          (uint32_t)\n"));
  err (_(" * nb_spr_write          (uint32_t)\n"));
  err (_(" * size_ooo_engine_id    (uint32_t)\n"));
  err (_(" * size_general_register (uint32_t)\n"));
  err (_(" * size_special_register (uint32_t)\n"));
  err (_(" * size_general_data     (uint32_t)\n"));
  err (_(" * size_special_data     (uint32_t)\n"));

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc != static_cast<int>(2+NB_PARAMS))
    usage (argc, argv);

  uint32_t x = 1;

  string name = argv[x++];
  uint32_t _nb_gpr_write           = fromString<uint32_t>(argv[x++]);
  uint32_t _nb_spr_write           = fromString<uint32_t>(argv[x++]);
  uint32_t _size_ooo_engine_id     = fromString<uint32_t>(argv[x++]);
  uint32_t _size_general_register  = fromString<uint32_t>(argv[x++]);
  uint32_t _size_special_register  = fromString<uint32_t>(argv[x++]);
  uint32_t _size_general_data      = fromString<uint32_t>(argv[x++]);
  uint32_t _size_special_data      = fromString<uint32_t>(argv[x++]);

  int _return = EXIT_SUCCESS;
  try 
    {
      morpheo::behavioural::core::multi_execute_loop::execute_loop::execute_loop_glue::Parameters * param = new morpheo::behavioural::core::multi_execute_loop::execute_loop::execute_loop_glue::Parameters
	(
	 _nb_gpr_write           ,
	 _nb_spr_write           ,
	 _size_ooo_engine_id     ,
	 _size_general_register  ,
	 _size_special_register  ,
	 _size_general_data      ,
	 _size_special_data      ,
         true // is_toplevel
        );
      
      msg(_("%s"),param->print(0).c_str());
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }
  
  try 
    {
      if (_return == EXIT_SUCCESS)
	TEST_OK("Execute_loop_Glue : no error");
      else
	TEST_KO("Execute_loop_Glue : a lot of error");
    }
  catch (morpheo::ErrorMorpheo & error)
    {
//       msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }

  return (_return);
}
