/*
 * $Id: Parameters.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Functionnal_unit/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_execute_unit {
namespace execute_unit {
namespace functionnal_unit {


#undef  FUNCTION
#define FUNCTION "Functionnal_unit::Parameters"
  Parameters::Parameters (uint32_t           nb_context         ,
			  uint32_t           nb_front_end       ,
			  uint32_t           nb_ooo_engine      ,
			  uint32_t           nb_packet          ,
			  uint32_t           size_general_data  ,
			  uint32_t           nb_general_register,
			  uint32_t           size_special_data  ,
			  uint32_t           nb_special_register,
			  uint32_t           size_store_queue   ,
			  uint32_t           size_load_queue    ,
			  execute_timing_t** timing             ,
			  morpheo::behavioural::custom::custom_information_t (*get_custom_information) (void),
                          bool               is_toplevel)
  {
    log_printf(FUNC,Functionnal_unit,FUNCTION,"Begin");

    _nb_context              = nb_context            ;
    _nb_front_end            = nb_front_end          ;
    _nb_ooo_engine           = nb_ooo_engine         ;
    _nb_packet               = nb_packet             ;
//  _size_general_data       = size_general_data     ;
//  _size_special_data       = size_special_data     ;
//  _nb_general_register     = nb_general_register   ;
//  _nb_special_register     = nb_special_register   ;
//  _size_store_queue        = size_store_queue      ;
//  _size_load_queue         = size_load_queue       ;

//  _size_context_id         = log2(nb_context         );
//  _size_front_end_id       = log2(nb_front_end       );
//  _size_ooo_engine_id      = log2(nb_ooo_engine      );
//  _size_packet_id          = log2(nb_packet          );
//  _size_general_register   = log2(nb_general_register);
//  _size_special_register   = log2(nb_special_register);

//  _have_port_context_id    = _size_context_id    > 0;
//  _have_port_front_end_id  = _size_front_end_id  > 0;
//  _have_port_ooo_engine_id = _size_ooo_engine_id > 0;
//  _have_port_packet_id     = _size_packet_id     > 0;
//  _have_port_load_queue_ptr= _size_load_queue    > 1;

    _have_groupe_MAC         = ( (timing[TYPE_SPECIAL][OPERATION_SPECIAL_L_MAC  ]._latence > 0) or
                                 (timing[TYPE_SPECIAL][OPERATION_SPECIAL_L_MACRC]._latence > 0) or
                                 (timing[TYPE_SPECIAL][OPERATION_SPECIAL_L_MSB  ]._latence > 0));

    _timing                  = timing;

    if (get_custom_information == NULL)
      _get_custom_information = &(morpheo::behavioural::custom::default_get_custom_information);
    else
      _get_custom_information = get_custom_information;

    test();

    if (is_toplevel)
      {
        _size_context_id         = log2(nb_context         );
        _size_front_end_id       = log2(nb_front_end       );
        _size_ooo_engine_id      = log2(nb_ooo_engine      );
        _size_rob_ptr            = log2(nb_packet          );
        _size_general_register   = log2(nb_general_register);
        _size_special_register   = log2(nb_special_register);

        _size_general_data       = size_general_data     ;
        _size_special_data       = size_special_data     ;
        _size_general_register   = log2(nb_general_register);
        _size_special_register   = log2(nb_special_register);

        _size_load_queue_ptr     = log2(size_load_queue );
        _size_store_queue_ptr    = log2(size_store_queue);
   
        _have_port_context_id    = _size_context_id    > 0;
        _have_port_front_end_id  = _size_front_end_id  > 0;
        _have_port_ooo_engine_id = _size_ooo_engine_id > 0;
        _have_port_rob_ptr       = _size_rob_ptr       > 0;
        _have_port_load_queue_ptr= _size_load_queue_ptr> 0;

        copy();
      }

    log_printf(FUNC,Functionnal_unit,FUNCTION,"End");
  };
  
// #undef  FUNCTION
// #define FUNCTION "Functionnal_unit::Parameters (copy)"
//   Parameters::Parameters (Parameters & param):
//     _nb_context              (param._nb_context             ),
//     _nb_front_end            (param._nb_front_end           ),
//     _nb_ooo_engine           (param._nb_ooo_engine          ),
//     _nb_packet               (param._nb_packet              ),
//     _size_general_data       (param._size_general_data      ),
//     _nb_general_register     (param._nb_general_register    ),
//     _size_special_data       (param._size_special_data      ),
//     _nb_special_register     (param._nb_special_register    ),
//     _size_store_queue        (param._size_store_queue       ),
//     _size_load_queue         (param._size_load_queue        ),

//     _size_context_id         (param._size_context_id        ),
//     _size_front_end_id       (param._size_front_end_id      ),
//     _size_ooo_engine_id      (param._size_ooo_engine_id     ),
//     _size_packet_id          (param._size_packet_id         ),
//     _size_general_register   (param._size_general_register  ),
//     _size_special_register   (param._size_special_register  ),

//     _have_port_context_id    (param._have_port_context_id   ),
//     _have_port_front_end_id  (param._have_port_front_end_id ),
//     _have_port_ooo_engine_id (param._have_port_ooo_engine_id),
//     _have_port_packet_id     (param._have_port_packet_id    ),
//     _have_port_load_queue_ptr(param._have_port_load_queue_ptr),

//     _have_groupe_MAC         (param._have_groupe_MAC        )
//   {
//     log_printf(FUNC,Functionnal_unit,FUNCTION,"Begin");

//     _timing                 = param._timing;
//     _get_custom_information = param._get_custom_information;

//     test();
//     log_printf(FUNC,Functionnal_unit,FUNCTION,"End");
//   };

#undef  FUNCTION
#define FUNCTION "Functionnal_unit::~Parameters"
  Parameters::~Parameters (void)
  {
    log_printf(FUNC,Functionnal_unit,FUNCTION,"Begin");
    log_printf(FUNC,Functionnal_unit,FUNCTION,"End");
  };

#undef  FUNCTION
#define FUNCTION "Functionnal_unit::copy"
  void Parameters::copy (void)
  {
    log_printf(FUNC,Functionnal_unit,FUNCTION,"Begin");
    log_printf(FUNC,Functionnal_unit,FUNCTION,"End");
  };

}; // end namespace functionnal_unit
}; // end namespace execute_unit
}; // end namespace multi_execute_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
