#ifdef SYSTEMC
/*
 * $Id: Execution_unit_to_Write_unit_genMealy.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Network/Execution_unit_to_Write_unit/include/Execution_unit_to_Write_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace network {
namespace execution_unit_to_write_unit {


#undef  FUNCTION
#define FUNCTION "Execution_unit_to_Write_unit::genMealy"
  void Execution_unit_to_Write_unit::genMealy (void)
  {
    log_printf(FUNC,Execution_unit_to_Write_unit,FUNCTION,"Begin");

    bool write_unit_use [_param->_nb_write_unit];

    for (uint32_t i=0; i<_param->_nb_write_unit; i++)
      write_unit_use[i] = (PORT_READ(in_WRITE_UNIT_IN_ACK [i]) == 0);

    for (uint32_t i=0; i<_param->_nb_execute_unit; i++)
      for (uint32_t j=0; j<_param->_nb_execute_unit_port[i]; j++)
	{
	  bool       ack = false;
	  
	  log_printf(TRACE,Execution_unit_to_Write_unit,FUNCTION,"Test execute_unit[%d][%d]",i,j);
	  
	  if (PORT_READ(in_EXECUTE_UNIT_OUT_VAL [i][j]) == true)
	    {
	      log_printf(TRACE,Execution_unit_to_Write_unit,FUNCTION," * have a valid entry.");
	      
	      Tcontext_t context_id    = (_param->_have_port_context_id   )?PORT_READ(in_EXECUTE_UNIT_OUT_CONTEXT_ID    [i][j]):0;
	      Tcontext_t front_end_id  = (_param->_have_port_front_end_id )?PORT_READ(in_EXECUTE_UNIT_OUT_FRONT_END_ID  [i][j]):0;
	      Tcontext_t ooo_engine_id = (_param->_have_port_ooo_engine_id)?PORT_READ(in_EXECUTE_UNIT_OUT_OOO_ENGINE_ID [i][j]):0;
	      Tcontext_t num_thread    = get_num_thread(context_id   , _param->_size_context_id   ,
							front_end_id , _param->_size_front_end_id ,
							ooo_engine_id, _param->_size_ooo_engine_id);
#ifdef DEBUG_TEST
	      if (_destination[i][j][num_thread].empty())
		throw ERRORMORPHEO(FUNCTION,"Invalid Operation : They have no write_unit to receive a operation from the execute_unit ["+toString(i)+"]["+toString(j)+"], thread ["+toString(num_thread)+"].");
#endif
	      
	      // find a free write_unit
	      for (std::list<uint32_t>::iterator it=_destination[i][j][num_thread].begin();
		   (it != _destination[i][j][num_thread].end()) and (ack == false);
		   it++)
		{
		  uint32_t dest = *it;
		  
		  log_printf(TRACE,Execution_unit_to_Write_unit,FUNCTION,"   * Test destination [%d].",dest);
		  
		  if (write_unit_use [dest] == false)
		    {
		      log_printf(TRACE,Execution_unit_to_Write_unit,FUNCTION,"     * Is ok! Link.");
		      // have find !!!
		      ack                   = true;
		      write_unit_use [dest] = true;
		      
		      if (_param->_have_port_context_id)
		      PORT_WRITE(out_WRITE_UNIT_IN_CONTEXT_ID            [dest], context_id);
		      if (_param->_have_port_front_end_id)
		      PORT_WRITE(out_WRITE_UNIT_IN_FRONT_END_ID          [dest], front_end_id);
		      if (_param->_have_port_ooo_engine_id)
		      PORT_WRITE(out_WRITE_UNIT_IN_OOO_ENGINE_ID         [dest], ooo_engine_id);
		      if (_param->_have_port_rob_ptr  )
		      PORT_WRITE(out_WRITE_UNIT_IN_PACKET_ID             [dest], PORT_READ(in_EXECUTE_UNIT_OUT_PACKET_ID             [i][j]));
		  //  PORT_WRITE(out_WRITE_UNIT_IN_OPERATION             [dest], PORT_READ(in_EXECUTE_UNIT_OUT_OPERATION             [i][j]));
		      PORT_WRITE(out_WRITE_UNIT_IN_TYPE                  [dest], PORT_READ(in_EXECUTE_UNIT_OUT_TYPE                  [i][j]));
		      PORT_WRITE(out_WRITE_UNIT_IN_WRITE_RD              [dest], PORT_READ(in_EXECUTE_UNIT_OUT_WRITE_RD              [i][j]));
		      PORT_WRITE(out_WRITE_UNIT_IN_NUM_REG_RD            [dest], PORT_READ(in_EXECUTE_UNIT_OUT_NUM_REG_RD            [i][j]));
		      PORT_WRITE(out_WRITE_UNIT_IN_DATA_RD               [dest], PORT_READ(in_EXECUTE_UNIT_OUT_DATA_RD               [i][j]));
		      PORT_WRITE(out_WRITE_UNIT_IN_WRITE_RE              [dest], PORT_READ(in_EXECUTE_UNIT_OUT_WRITE_RE              [i][j]));
		      PORT_WRITE(out_WRITE_UNIT_IN_NUM_REG_RE            [dest], PORT_READ(in_EXECUTE_UNIT_OUT_NUM_REG_RE            [i][j]));
		      PORT_WRITE(out_WRITE_UNIT_IN_DATA_RE               [dest], PORT_READ(in_EXECUTE_UNIT_OUT_DATA_RE               [i][j]));
		      PORT_WRITE(out_WRITE_UNIT_IN_EXCEPTION             [dest], PORT_READ(in_EXECUTE_UNIT_OUT_EXCEPTION             [i][j]));
		      PORT_WRITE(out_WRITE_UNIT_IN_NO_SEQUENCE           [dest], PORT_READ(in_EXECUTE_UNIT_OUT_NO_SEQUENCE           [i][j]));
		      PORT_WRITE(out_WRITE_UNIT_IN_ADDRESS               [dest], PORT_READ(in_EXECUTE_UNIT_OUT_ADDRESS               [i][j]));
		    }
		}
	    }
	  PORT_WRITE(out_EXECUTE_UNIT_OUT_ACK [i][j], ack);
      }

    for (uint32_t i=0; i<_param->_nb_write_unit; i++)
      {
	PORT_WRITE(out_WRITE_UNIT_IN_VAL[i], write_unit_use[i]);  
      }

    log_printf(FUNC,Execution_unit_to_Write_unit,FUNCTION,"End");
  };

}; // end namespace execution_unit_to_write_unit
}; // end namespace network
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
