/*
 * $Id: Parameters.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Address_management/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {
namespace address_management {


#undef  FUNCTION
#define FUNCTION "Address_management::Parameters"
  Parameters::Parameters (uint32_t nb_instruction,
			  uint32_t size_address  ,
			  uint32_t size_branch_update_prediction,
                          bool     is_toplevel)
  {
    log_printf(FUNC,Address_management,FUNCTION,"Begin");

    _nb_instruction = nb_instruction               ;

    test();

    if (is_toplevel)
      {
        _size_instruction_address  = size_address                 ;
        _size_depth                = size_branch_update_prediction;
        _size_inst_ifetch_ptr      = log2(nb_instruction);
        
        _have_port_inst_ifetch_ptr = _size_inst_ifetch_ptr > 0;
        _have_port_depth           = _size_depth > 0;

        copy();
      }

    log_printf(FUNC,Address_management,FUNCTION,"End");
  };
  
// #undef  FUNCTION
// #define FUNCTION "Address_management::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_printf(FUNC,Address_management,FUNCTION,"Begin");
//     test();
//     log_printf(FUNC,Address_management,FUNCTION,"End");
//   };

#undef  FUNCTION
#define FUNCTION "Address_management::~Parameters"
  Parameters::~Parameters () 
  {
    log_printf(FUNC,Address_management,FUNCTION,"Begin");
    log_printf(FUNC,Address_management,FUNCTION,"End");
  };

#undef  FUNCTION
#define FUNCTION "Address_management::copy"
  void Parameters::copy (void) 
  {
    log_printf(FUNC,Address_management,FUNCTION,"Begin");
    log_printf(FUNC,Address_management,FUNCTION,"End");
  };

}; // end namespace address_management
}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
