/*
 * $Id: Parameters_msg_error.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"
#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Commit_unit/include/Parameters.h"
#include <sstream>

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace commit_unit {


#undef  FUNCTION
#define FUNCTION "Commit_unit::msg_error"
  Parameters_test Parameters::msg_error(void)
  {
    log_begin(Commit_unit,FUNCTION);

    Parameters_test test ("Commit_unit");

    for (uint32_t i=0; i<_nb_rename_unit; i++)
      if (_nb_bank < _nb_inst_insert [i])
	test.error (toString(_("For the nb_rename_unit[%d] : nb_bank must be >= nb_inst_insert.\n"),i));
    
    for (uint32_t i=0; i<_nb_rename_unit; i++)
      if (_nb_bank < _nb_inst_retire [i])
	test.error (toString(_("For the nb_rename_unit[%d] : nb_bank must be >= nb_inst_retire.\n"),i));
    
    if (_nb_rename_unit_select > _nb_rename_unit)
      test.error("nb_rename_unit must be >= nb_rename_unit_select.\n");

    if (not is_multiple(_size_queue, _nb_bank))
      test.error("nb_bank must be a multiple of size_queue.\n");

    if (_nb_inst_reexecute != 1)
      test.error("nb_inst_reexecute must be set at 1. Anothers value is unsupported.\n");

    if (_size_queue == 1)
      test.information ("Instructions are issued In-Order.\n");
    else
      test.information ("Instructions are issued Out-Of-Order.\n");

    log_end(Commit_unit,FUNCTION);

    return test;
  };

}; // end namespace commit_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
