#ifdef SYSTEMC
/*
 * $Id: Register_translation_unit_Glue_genMealy_insert_valack.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Register_translation_unit_Glue/include/Register_translation_unit_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace register_translation_unit_glue {


#undef  FUNCTION
#define FUNCTION "Register_translation_unit_Glue::genMealy_insert_valack"
  void Register_translation_unit_Glue::genMealy_insert_valack (void)
  {
    log_begin(Register_translation_unit_Glue,FUNCTION);
    log_function(Register_translation_unit_Glue,FUNCTION,_name.c_str());
    for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
      {
	Tcontrol_t rename_val     = PORT_READ(in_INSERT_RENAME_VAL     [i]);
	Tcontrol_t insert_ack     = PORT_READ(in_INSERT_INSERT_ACK     [i]);
	Tcontrol_t rat_rename_ack = PORT_READ(in_INSERT_RAT_RENAME_ACK [i]);
	Tcontrol_t rat_insert_ack = PORT_READ(in_INSERT_RAT_INSERT_ACK [i]);
	Tcontrol_t free_list_ack  = PORT_READ(in_INSERT_FREE_LIST_ACK  [i]);
	Tcontrol_t stat_list_ack  = PORT_READ(in_INSERT_STAT_LIST_ACK  [i]);

	Tcontrol_t rename_ack     = (insert_ack     and
                                     rat_rename_ack and
                                     rat_insert_ack and
                                     free_list_ack  and
                                     stat_list_ack  );
	Tcontrol_t insert_val     = (rename_val     and
                                     rat_rename_ack and
                                     rat_insert_ack and
                                     free_list_ack  and
                                     stat_list_ack  );
	Tcontrol_t rat_insert_val = (rename_val     and
                                     insert_ack     and
                                     rat_rename_ack and
                                     free_list_ack  and
                                     stat_list_ack  );
	Tcontrol_t free_list_val  = (rename_val     and
                                     insert_ack     and
                                     rat_rename_ack and
                                     rat_insert_ack and
                                     stat_list_ack  );
	Tcontrol_t stat_list_val  = (rename_val     and
                                     insert_ack     and
                                     rat_rename_ack and
                                     rat_insert_ack and
                                     free_list_ack  );

        log_printf(TRACE,Register_translation_unit_Glue,FUNCTION,"  * inst_insert [%d]",i);
        log_printf(TRACE,Register_translation_unit_Glue,FUNCTION,"    * rename_val     (r): %d",rename_val    );
        log_printf(TRACE,Register_translation_unit_Glue,FUNCTION,"    * rename_ack     (w): %d",rename_ack    );
        log_printf(TRACE,Register_translation_unit_Glue,FUNCTION,"    * insert_val     (w): %d",insert_val    );
        log_printf(TRACE,Register_translation_unit_Glue,FUNCTION,"    * insert_ack     (r): %d",insert_ack    );
//      log_printf(TRACE,Register_translation_unit_Glue,FUNCTION,"    * rat_rename_val (w): %d",rat_rename_val);
        log_printf(TRACE,Register_translation_unit_Glue,FUNCTION,"    * rat_rename_val    -> rename_val");
        log_printf(TRACE,Register_translation_unit_Glue,FUNCTION,"    * rat_rename_ack (r): %d",rat_rename_ack);
        log_printf(TRACE,Register_translation_unit_Glue,FUNCTION,"    * rat_insert_val (w): %d",rat_insert_val);
        log_printf(TRACE,Register_translation_unit_Glue,FUNCTION,"    * rat_insert_ack (r): %d",rat_insert_ack);
        log_printf(TRACE,Register_translation_unit_Glue,FUNCTION,"    * free_list_val  (w): %d",free_list_val );
        log_printf(TRACE,Register_translation_unit_Glue,FUNCTION,"    * free_list_ack  (r): %d",free_list_ack );
        log_printf(TRACE,Register_translation_unit_Glue,FUNCTION,"    * stat_list_val  (w): %d",stat_list_val );
        log_printf(TRACE,Register_translation_unit_Glue,FUNCTION,"    * stat_list_ack  (r): %d",stat_list_ack );


	PORT_WRITE(out_INSERT_RENAME_ACK     [i], rename_ack    );
	PORT_WRITE(out_INSERT_INSERT_VAL     [i], insert_val    );
	PORT_WRITE(out_INSERT_RAT_INSERT_VAL [i], rat_insert_val);
	PORT_WRITE(out_INSERT_FREE_LIST_VAL  [i], free_list_val );
	PORT_WRITE(out_INSERT_STAT_LIST_VAL  [i], stat_list_val );

      }

    log_end(Register_translation_unit_Glue,FUNCTION);
  };

}; // end namespace register_translation_unit_glue
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
