/*
 * $Id: test.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#define NB_ITERATION  1
#define CYCLE_MAX     (128*NB_ITERATION)

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Stat_List_unit/SelfTest/include/test.h"
#include "Common/include/Test.h"
#include "Behavioural/include/Allocation.h"
#include <list>


class entry_t
{
public : bool     _is_free ;
public : bool     _is_link ;
public : bool     _is_valid;
public : uint32_t _counter ;
};


void test (string name,
	   morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::stat_list_unit::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Stat_List_unit * _Stat_List_unit = new Stat_List_unit 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC1_SC_SIGNAL( in_INSERT_VAL               ," in_INSERT_VAL               ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_ACK               ,"out_INSERT_ACK               ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_READ_RA           ," in_INSERT_READ_RA           ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_NUM_REG_RA_PHY    ," in_INSERT_NUM_REG_RA_PHY    ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_READ_RB           ," in_INSERT_READ_RB           ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_NUM_REG_RB_PHY    ," in_INSERT_NUM_REG_RB_PHY    ",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_READ_RC           ," in_INSERT_READ_RC           ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_NUM_REG_RC_PHY    ," in_INSERT_NUM_REG_RC_PHY    ",Tspecial_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_WRITE_RD          ," in_INSERT_WRITE_RD          ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_NUM_REG_RD_PHY_NEW," in_INSERT_NUM_REG_RD_PHY_NEW",Tgeneral_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_WRITE_RE          ," in_INSERT_WRITE_RE          ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_NUM_REG_RE_PHY_NEW," in_INSERT_NUM_REG_RE_PHY_NEW",Tspecial_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_RETIRE_VAL               ," in_RETIRE_VAL               ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_RETIRE_ACK               ,"out_RETIRE_ACK               ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_READ_RA           ," in_RETIRE_READ_RA           ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_NUM_REG_RA_PHY    ," in_RETIRE_NUM_REG_RA_PHY    ",Tgeneral_address_t,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_READ_RB           ," in_RETIRE_READ_RB           ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_NUM_REG_RB_PHY    ," in_RETIRE_NUM_REG_RB_PHY    ",Tgeneral_address_t,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_READ_RC           ," in_RETIRE_READ_RC           ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_NUM_REG_RC_PHY    ," in_RETIRE_NUM_REG_RC_PHY    ",Tspecial_address_t,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_WRITE_RD          ," in_RETIRE_WRITE_RD          ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_RESTORE_RD_PHY_OLD," in_RETIRE_RESTORE_RD_PHY_OLD",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_NUM_REG_RD_PHY_OLD," in_RETIRE_NUM_REG_RD_PHY_OLD",Tgeneral_address_t,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_NUM_REG_RD_PHY_NEW," in_RETIRE_NUM_REG_RD_PHY_NEW",Tgeneral_address_t,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_WRITE_RE          ," in_RETIRE_WRITE_RE          ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_RESTORE_RE_PHY_OLD," in_RETIRE_RESTORE_RE_PHY_OLD",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_NUM_REG_RE_PHY_OLD," in_RETIRE_NUM_REG_RE_PHY_OLD",Tspecial_address_t,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_NUM_REG_RE_PHY_NEW," in_RETIRE_NUM_REG_RE_PHY_NEW",Tspecial_address_t,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_PUSH_GPR_VAL             ,"out_PUSH_GPR_VAL             ",Tcontrol_t        ,_param->_nb_reg_free);
  ALLOC1_SC_SIGNAL( in_PUSH_GPR_ACK             ," in_PUSH_GPR_ACK             ",Tcontrol_t        ,_param->_nb_reg_free);
  ALLOC1_SC_SIGNAL(out_PUSH_GPR_NUM_REG         ,"out_PUSH_GPR_NUM_REG         ",Tgeneral_address_t,_param->_nb_reg_free);
  ALLOC1_SC_SIGNAL(out_PUSH_SPR_VAL             ,"out_PUSH_SPR_VAL             ",Tcontrol_t        ,_param->_nb_reg_free);
  ALLOC1_SC_SIGNAL( in_PUSH_SPR_ACK             ," in_PUSH_SPR_ACK             ",Tcontrol_t        ,_param->_nb_reg_free);
  ALLOC1_SC_SIGNAL(out_PUSH_SPR_NUM_REG         ,"out_PUSH_SPR_NUM_REG         ",Tspecial_address_t,_param->_nb_reg_free);

  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Stat_List_unit.\n"),name.c_str());

  (*(_Stat_List_unit->in_CLOCK))        (*(in_CLOCK));
  (*(_Stat_List_unit->in_NRESET))       (*(in_NRESET));

  INSTANCE1_SC_SIGNAL(_Stat_List_unit, in_INSERT_VAL               ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Stat_List_unit,out_INSERT_ACK               ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Stat_List_unit, in_INSERT_READ_RA           ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Stat_List_unit, in_INSERT_NUM_REG_RA_PHY    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Stat_List_unit, in_INSERT_READ_RB           ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Stat_List_unit, in_INSERT_NUM_REG_RB_PHY    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Stat_List_unit, in_INSERT_READ_RC           ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Stat_List_unit, in_INSERT_NUM_REG_RC_PHY    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Stat_List_unit, in_INSERT_WRITE_RD          ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Stat_List_unit, in_INSERT_NUM_REG_RD_PHY_NEW,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Stat_List_unit, in_INSERT_WRITE_RE          ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Stat_List_unit, in_INSERT_NUM_REG_RE_PHY_NEW,_param->_nb_inst_insert);

  INSTANCE1_SC_SIGNAL(_Stat_List_unit, in_RETIRE_VAL               ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Stat_List_unit,out_RETIRE_ACK               ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Stat_List_unit, in_RETIRE_READ_RA           ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Stat_List_unit, in_RETIRE_NUM_REG_RA_PHY    ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Stat_List_unit, in_RETIRE_READ_RB           ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Stat_List_unit, in_RETIRE_NUM_REG_RB_PHY    ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Stat_List_unit, in_RETIRE_READ_RC           ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Stat_List_unit, in_RETIRE_NUM_REG_RC_PHY    ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Stat_List_unit, in_RETIRE_WRITE_RD          ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Stat_List_unit, in_RETIRE_RESTORE_RD_PHY_OLD,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Stat_List_unit, in_RETIRE_NUM_REG_RD_PHY_OLD,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Stat_List_unit, in_RETIRE_NUM_REG_RD_PHY_NEW,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Stat_List_unit, in_RETIRE_WRITE_RE          ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Stat_List_unit, in_RETIRE_RESTORE_RE_PHY_OLD,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Stat_List_unit, in_RETIRE_NUM_REG_RE_PHY_OLD,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Stat_List_unit, in_RETIRE_NUM_REG_RE_PHY_NEW,_param->_nb_inst_retire);

  INSTANCE1_SC_SIGNAL(_Stat_List_unit,out_PUSH_GPR_VAL             ,_param->_nb_reg_free);
  INSTANCE1_SC_SIGNAL(_Stat_List_unit, in_PUSH_GPR_ACK             ,_param->_nb_reg_free);
  INSTANCE1_SC_SIGNAL(_Stat_List_unit,out_PUSH_GPR_NUM_REG         ,_param->_nb_reg_free);

  INSTANCE1_SC_SIGNAL(_Stat_List_unit,out_PUSH_SPR_VAL             ,_param->_nb_reg_free);
  INSTANCE1_SC_SIGNAL(_Stat_List_unit, in_PUSH_SPR_ACK             ,_param->_nb_reg_free);
  INSTANCE1_SC_SIGNAL(_Stat_List_unit,out_PUSH_SPR_NUM_REG         ,_param->_nb_reg_free);

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  int32_t percent_transaction_insert = 95;
  int32_t percent_transaction_retire = 95;
  int32_t percent_transaction_push   = 95;

  uint32_t nb_thread = 0;
  for (uint32_t i=0; i<_param->_nb_front_end; i++)
    nb_thread += _param->_nb_context [i];

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      entry_t gpr_status [_param->_nb_general_register];
      entry_t spr_status [_param->_nb_special_register];

      for (uint32_t i=0; i<_param->_nb_general_register; i++)
	{
	  gpr_status[i]._is_free  = false;
	  gpr_status[i]._is_link  = (i<(nb_thread*31+1));
	  gpr_status[i]._is_valid = true;
	  gpr_status[i]._counter  = 0;
	}
      for (uint32_t i=0; i<_param->_nb_special_register; i++)
	{
	  spr_status[i]._is_free  = false;
	  spr_status[i]._is_link  = (i<(nb_thread*2));
	  spr_status[i]._is_valid = true;
	  spr_status[i]._counter  = 0;
	}

      std::list<Tgeneral_address_t> free_list_gpr;
      std::list<Tgeneral_address_t> free_list_spr;

      // Test free register
      while ((free_list_gpr.size() < (_param->_nb_general_register - (nb_thread*31+1))) and
	     (free_list_spr.size() < (_param->_nb_special_register - (nb_thread*2   ))))
	{
	  for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
	    in_INSERT_VAL   [i]->write(0);
	  for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
	    in_RETIRE_VAL   [i]->write(0);
	  
	  for (uint32_t i=0; i<_param->_nb_reg_free; i++)
	    {
	      in_PUSH_GPR_ACK [i]->write((rand()%100)<percent_transaction_push);
	      in_PUSH_SPR_ACK [i]->write((rand()%100)<percent_transaction_push);
	    }
	  
	  SC_START(0);

	  for (uint32_t i=0; i<_param->_nb_reg_free; i++)
	    {
	      if (out_PUSH_GPR_VAL [i]->read() and in_PUSH_GPR_ACK [i]->read())
		{
		  Tgeneral_address_t reg = out_PUSH_GPR_NUM_REG [i]->read();
		  
		  LABEL("PUSH_GPR [%d] - Accepted",i);
		  LABEL(" * reg              : %d",reg);
		  LABEL("   * status[%d]._is_free  : %d",reg,spr_status[reg]._is_free );
		  LABEL("   * status[%d]._is_link  : %d",reg,spr_status[reg]._is_link );
		  LABEL("   * status[%d]._is_valid : %d",reg,spr_status[reg]._is_valid);
		  LABEL("   * status[%d]._counter  : %d",reg,spr_status[reg]._counter );

		  TEST(bool, true,((gpr_status[reg]._is_free  == 0) and
				   (gpr_status[reg]._is_link  == 0) and
				   (gpr_status[reg]._is_valid == 1) and
				   (gpr_status[reg]._counter  == 0)));

		  gpr_status[reg]._is_free = 1;
		  free_list_gpr.push_back(reg);
		}

	      if (out_PUSH_SPR_VAL [i]->read() and in_PUSH_SPR_ACK [i]->read())
		{
		  Tspecial_address_t reg = out_PUSH_SPR_NUM_REG [i]->read();
		  
		  LABEL("PUSH_SPR [%d] - Accepted",i);
		  LABEL(" * reg              : %d",reg);
		  LABEL("   * status[%d]._is_free  : %d",reg,spr_status[reg]._is_free );
		  LABEL("   * status[%d]._is_link  : %d",reg,spr_status[reg]._is_link );
		  LABEL("   * status[%d]._is_valid : %d",reg,spr_status[reg]._is_valid);
		  LABEL("   * status[%d]._counter  : %d",reg,spr_status[reg]._counter );

		  TEST(bool, true,((spr_status[reg]._is_free  == 0) and
				   (spr_status[reg]._is_link  == 0) and
				   (spr_status[reg]._is_valid == 1) and
				   (spr_status[reg]._counter  == 0)));

		  spr_status[reg]._is_free = 1;
		  free_list_spr.push_back(reg);
		}
	    }
	  
	  SC_START(1);
	}

      LABEL("=======================");
      LABEL("===== END OF INIT =====");
      LABEL("=======================");

      int32_t nb_cycle = 64;
      
      while (nb_cycle > 0)
	{
	  std::list<Tgeneral_address_t>::iterator it_gpr = free_list_gpr.begin();
	  std::list<Tspecial_address_t>::iterator it_spr = free_list_spr.begin();


	  entry_t gpr_status_insert [_param->_nb_general_register];
	  entry_t spr_status_insert [_param->_nb_special_register];
	  entry_t gpr_status_retire [_param->_nb_general_register];
	  entry_t spr_status_retire [_param->_nb_special_register];

	  for (uint32_t i=0; i<_param->_nb_general_register; i++)
	    {
	      gpr_status_insert [i] = gpr_status[i];
	      gpr_status_retire [i] = gpr_status[i];
	    }
	  for (uint32_t i=0; i<_param->_nb_special_register; i++)
	    {
	      spr_status_insert [i] = spr_status[i];
	      spr_status_retire [i] = spr_status[i];
	    }

	  for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
	    {
	      Tgeneral_address_t ra       = (rand()%(_param->_nb_general_register-1))+1;
	      Tgeneral_address_t rb       = (rand()%(_param->_nb_general_register-1))+1;
	      Tspecial_address_t rc       = (rand()%(_param->_nb_special_register  ))  ;
	      Tgeneral_address_t rd       = (it_gpr != free_list_gpr.end())?*it_gpr:0;
	      Tspecial_address_t re       = (it_spr != free_list_spr.end())?*it_spr:0;

	      Tcontrol_t         read_ra  = (gpr_status_insert[ra]._is_link) and (gpr_status_insert[ra]._counter < _param->_max_reader);
	      Tcontrol_t         read_rb  = (gpr_status_insert[rb]._is_link) and (gpr_status_insert[rb]._counter < _param->_max_reader);
	      Tcontrol_t         read_rc  = (spr_status_insert[rc]._is_link) and (spr_status_insert[rc]._counter < _param->_max_reader);
	      Tcontrol_t         write_rd = (it_gpr != free_list_gpr.end());
	      Tcontrol_t         write_re = (it_spr != free_list_spr.end());

	      in_INSERT_VAL                [i]->write((rand()%100) < percent_transaction_insert);
	      in_INSERT_READ_RA            [i]->write(read_ra );
	      in_INSERT_NUM_REG_RA_PHY     [i]->write(ra);
	      in_INSERT_READ_RB            [i]->write(read_rb );
	      in_INSERT_NUM_REG_RB_PHY     [i]->write(rb);
	      in_INSERT_READ_RC            [i]->write(read_rc );
	      in_INSERT_NUM_REG_RC_PHY     [i]->write(rc);
	      in_INSERT_WRITE_RD           [i]->write(write_rd);
	      in_INSERT_NUM_REG_RD_PHY_NEW [i]->write(rd);
	      in_INSERT_WRITE_RE           [i]->write(write_re);
	      in_INSERT_NUM_REG_RE_PHY_NEW [i]->write(re);

	      if (read_ra)
		gpr_status_insert[ra]._counter++;
	      if (read_rb)
		gpr_status_insert[rb]._counter++;
	      if (read_rc)
		spr_status_insert[rc]._counter++;
	      if (write_rd)
		it_gpr ++;
	      if (write_re)
		it_spr ++;
	    }

	  for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
	    {
	      Tgeneral_address_t ra       = (rand()%(_param->_nb_general_register-1))+1;
	      Tgeneral_address_t rb       = (rand()%(_param->_nb_general_register-1))+1;
	      Tspecial_address_t rc       = (rand()%(_param->_nb_special_register  ))  ;
	      Tgeneral_address_t rd_old   = (rand()%(_param->_nb_general_register-1))+1;
	      Tgeneral_address_t rd_new   = (rand()%(_param->_nb_general_register-1))+1;
	      Tspecial_address_t re_old   = (rand()%(_param->_nb_special_register  ))  ;
	      Tspecial_address_t re_new   = (rand()%(_param->_nb_special_register  ))  ;

	      Tcontrol_t         read_ra  = (gpr_status_retire[ra]._is_link) and (gpr_status_retire[ra]._counter > 0);
	      Tcontrol_t         read_rb  = (gpr_status_retire[rb]._is_link) and (gpr_status_retire[rb]._counter > 0);
	      Tcontrol_t         read_rc  = (spr_status_retire[rc]._is_link) and (spr_status_retire[rc]._counter > 0);
	      Tcontrol_t         write_rd = (    (gpr_status_retire[rd_old]._is_link ) and 
					         (gpr_status_retire[rd_old]._is_valid) and
					         (gpr_status_retire[rd_new]._is_link ) and 
					     not (gpr_status_retire[rd_new]._is_valid));
	      Tcontrol_t         write_re = (    (spr_status_retire[re_old]._is_link ) and 
					         (spr_status_retire[re_old]._is_valid) and
					         (spr_status_retire[re_new]._is_link ) and 
					     not (spr_status_retire[re_new]._is_valid));

	      in_RETIRE_VAL                [i]->write((rand()%100) < percent_transaction_retire);
	      in_RETIRE_READ_RA            [i]->write(read_ra );
	      in_RETIRE_NUM_REG_RA_PHY     [i]->write(ra);
	      in_RETIRE_READ_RB            [i]->write(read_rb );
	      in_RETIRE_NUM_REG_RB_PHY     [i]->write(rb);
	      in_RETIRE_READ_RC            [i]->write(read_rc );
	      in_RETIRE_NUM_REG_RC_PHY     [i]->write(rc);
	      in_RETIRE_WRITE_RD           [i]->write(write_rd);
	      in_RETIRE_RESTORE_RD_PHY_OLD [i]->write(0);
	      in_RETIRE_NUM_REG_RD_PHY_OLD [i]->write(rd_old);
	      in_RETIRE_NUM_REG_RD_PHY_NEW [i]->write(rd_new);
	      in_RETIRE_WRITE_RE           [i]->write(write_re);
	      in_RETIRE_RESTORE_RE_PHY_OLD [i]->write(0);
	      in_RETIRE_NUM_REG_RE_PHY_OLD [i]->write(re_old);
	      in_RETIRE_NUM_REG_RE_PHY_NEW [i]->write(re_new);

		if (read_ra)
		  {
		    gpr_status_retire[ra]._counter --;
		  }
		if (read_rb)
		  {
		    gpr_status_retire[rb]._counter --;
		  }
		if (read_rc)
		  {
		    spr_status_retire[rc]._counter --;
		  }
		if (write_rd)
		  {
		    gpr_status_retire[rd_old]._is_link  = 0;
		    gpr_status_retire[rd_new]._is_valid = 1;
		  }
		if (write_re)
		  {
		    spr_status_retire[re_old]._is_link  = 0;
		    spr_status_retire[re_new]._is_valid = 1;
		  }

	    }


	  for (uint32_t i=0; i<_param->_nb_reg_free; i++)
	    {
	      in_PUSH_GPR_ACK [i]->write((rand()%100)<percent_transaction_push);
	      in_PUSH_SPR_ACK [i]->write((rand()%100)<percent_transaction_push);
	    }

	  SC_START(0);

	  it_gpr = free_list_gpr.begin();
	  it_spr = free_list_spr.begin();

	  for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
	    {
	      Tcontrol_t         write_rd = in_INSERT_WRITE_RD           [i]->read();
	      Tcontrol_t         write_re = in_INSERT_WRITE_RE           [i]->read();

	      if (in_INSERT_VAL [i]->read() and out_INSERT_ACK [i]->read())
		{
		  Tcontrol_t         read_ra  = in_INSERT_READ_RA            [i]->read();
		  Tgeneral_address_t ra       = in_INSERT_NUM_REG_RA_PHY     [i]->read();
		  Tcontrol_t         read_rb  = in_INSERT_READ_RB            [i]->read();
		  Tgeneral_address_t rb       = in_INSERT_NUM_REG_RB_PHY     [i]->read();
		  Tcontrol_t         read_rc  = in_INSERT_READ_RC            [i]->read();
		  Tspecial_address_t rc       = in_INSERT_NUM_REG_RC_PHY     [i]->read();
		  Tgeneral_address_t rd_new   = in_INSERT_NUM_REG_RD_PHY_NEW [i]->read();
		  Tspecial_address_t re_new   = in_INSERT_NUM_REG_RE_PHY_NEW [i]->read();		
		  
		  LABEL("INSERT [%d] - Accepted",i);
		  LABEL(" * read_ra          : %d",read_ra );
		  LABEL(" * reg_ra           : %d",ra      );
		  LABEL("   * status[%d]._is_free  : %d",ra,spr_status[ra]._is_free );
		  LABEL("   * status[%d]._is_link  : %d",ra,spr_status[ra]._is_link );
		  LABEL("   * status[%d]._is_valid : %d",ra,spr_status[ra]._is_valid);
		  LABEL("   * status[%d]._counter  : %d",ra,spr_status[ra]._counter );
		  LABEL(" * read_rb          : %d",read_rb );
		  LABEL(" * reg_rb           : %d",rb      );
		  LABEL("   * status[%d]._is_free  : %d",rb,spr_status[rb]._is_free );
		  LABEL("   * status[%d]._is_link  : %d",rb,spr_status[rb]._is_link );
		  LABEL("   * status[%d]._is_valid : %d",rb,spr_status[rb]._is_valid);
		  LABEL("   * status[%d]._counter  : %d",rb,spr_status[rb]._counter );
		  LABEL(" * read_rc          : %d",read_rc );
		  LABEL(" * reg_rc           : %d",rc      );
		  LABEL("   * status[%d]._is_free  : %d",rc,spr_status[rc]._is_free );
		  LABEL("   * status[%d]._is_link  : %d",rc,spr_status[rc]._is_link );
		  LABEL("   * status[%d]._is_valid : %d",rc,spr_status[rc]._is_valid);
		  LABEL("   * status[%d]._counter  : %d",rc,spr_status[rc]._counter );
		  LABEL(" * read_rd          : %d",write_rd);
		  LABEL(" * reg_rd_new       : %d",rd_new  );
		  LABEL("   * status[%d]._is_free  : %d",rd_new,spr_status[rd_new]._is_free );
		  LABEL("   * status[%d]._is_link  : %d",rd_new,spr_status[rd_new]._is_link );
		  LABEL("   * status[%d]._is_valid : %d",rd_new,spr_status[rd_new]._is_valid);
		  LABEL("   * status[%d]._counter  : %d",rd_new,spr_status[rd_new]._counter );
		  LABEL(" * read_re          : %d",write_re);
		  LABEL(" * reg_re_new       : %d",re_new  );
		  LABEL("   * status[%d]._is_free  : %d",re_new,spr_status[re_new]._is_free );
		  LABEL("   * status[%d]._is_link  : %d",re_new,spr_status[re_new]._is_link );
		  LABEL("   * status[%d]._is_valid : %d",re_new,spr_status[re_new]._is_valid);
		  LABEL("   * status[%d]._counter  : %d",re_new,spr_status[re_new]._counter );
		  
		  if (read_ra)
		    {
		      gpr_status[ra]._counter ++;
		    }
		  if (read_rb)
		    {
		      gpr_status[rb]._counter ++;
		    }
		  if (read_rc)
		    {
		      spr_status[rc]._counter ++;
		    }
		  if (write_rd)
		    {
		      Tgeneral_address_t reg = *it_gpr;
		      TEST(Tgeneral_address_t,reg,rd_new);
		      
		      it_gpr = free_list_gpr.erase(it_gpr);
		      
		      gpr_status[reg]._is_free  = 0;
		      gpr_status[reg]._is_link  = 1;
		      gpr_status[reg]._is_valid = 0;
		    }
		  
		  if (write_re)
		    {
		      Tspecial_address_t reg = *it_spr;
		      TEST(Tspecial_address_t,reg,re_new);
		      
		      it_spr = free_list_spr.erase(it_spr);
		      
		      spr_status[reg]._is_free  = 0;
		      spr_status[reg]._is_link  = 1;
		      spr_status[reg]._is_valid = 0;
		    }
		}
	      else
		{
		  if (write_rd)
		    it_gpr ++;
		  if (write_re)
		    it_spr ++;
		}
	    }
	  
	  for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
	    if (in_RETIRE_VAL [i]->read() and out_RETIRE_ACK [i]->read())
	      {
		Tcontrol_t         read_ra        = in_RETIRE_READ_RA            [i]->read();
		Tgeneral_address_t ra             = in_RETIRE_NUM_REG_RA_PHY     [i]->read();
		Tcontrol_t         read_rb        = in_RETIRE_READ_RB            [i]->read();
		Tgeneral_address_t rb             = in_RETIRE_NUM_REG_RB_PHY     [i]->read();
		Tcontrol_t         read_rc        = in_RETIRE_READ_RC            [i]->read();
		Tspecial_address_t rc             = in_RETIRE_NUM_REG_RC_PHY     [i]->read();
		Tcontrol_t         write_rd       = in_RETIRE_WRITE_RD           [i]->read();
		Tcontrol_t         restore_rd_old = in_RETIRE_RESTORE_RD_PHY_OLD [i]->read();
		Tgeneral_address_t rd_old         = in_RETIRE_NUM_REG_RD_PHY_OLD [i]->read();
		Tgeneral_address_t rd_new         = in_RETIRE_NUM_REG_RD_PHY_NEW [i]->read();
		Tcontrol_t         write_re       = in_RETIRE_WRITE_RE           [i]->read();
		Tcontrol_t         restore_re_old = in_RETIRE_RESTORE_RE_PHY_OLD [i]->read();
		Tgeneral_address_t re_old         = in_RETIRE_NUM_REG_RE_PHY_OLD [i]->read();
		Tgeneral_address_t re_new         = in_RETIRE_NUM_REG_RE_PHY_NEW [i]->read();		

		LABEL("RETIRE [%d] - Accepted",i);
		LABEL(" * read_ra          : %d",read_ra );
		LABEL(" * reg_ra           : %d",ra      );
		LABEL("   * status[%d]._is_free  : %d",ra,spr_status[ra]._is_free );
		LABEL("   * status[%d]._is_link  : %d",ra,spr_status[ra]._is_link );
		LABEL("   * status[%d]._is_valid : %d",ra,spr_status[ra]._is_valid);
		LABEL("   * status[%d]._counter  : %d",ra,spr_status[ra]._counter );
		LABEL(" * read_rb          : %d",read_rb );
		LABEL(" * reg_rb           : %d",rb      );
		LABEL("   * status[%d]._is_free  : %d",rb,spr_status[rb]._is_free );
		LABEL("   * status[%d]._is_link  : %d",rb,spr_status[rb]._is_link );
		LABEL("   * status[%d]._is_valid : %d",rb,spr_status[rb]._is_valid);
		LABEL("   * status[%d]._counter  : %d",rb,spr_status[rb]._counter );
		LABEL(" * read_rc          : %d",read_rc );
		LABEL(" * reg_rc           : %d",rc      );
		LABEL("   * status[%d]._is_free  : %d",rc,spr_status[rc]._is_free );
		LABEL("   * status[%d]._is_link  : %d",rc,spr_status[rc]._is_link );
		LABEL("   * status[%d]._is_valid : %d",rc,spr_status[rc]._is_valid);
		LABEL("   * status[%d]._counter  : %d",rc,spr_status[rc]._counter );
		LABEL(" * read_rd          : %d",write_rd);
		LABEL(" * restore_rd_old   : %d",restore_rd_old);
		LABEL(" * reg_rd_old       : %d",rd_old  );
		LABEL("   * status[%d]._is_free  : %d",rd_old,spr_status[rd_old]._is_free );
		LABEL("   * status[%d]._is_link  : %d",rd_old,spr_status[rd_old]._is_link );
		LABEL("   * status[%d]._is_valid : %d",rd_old,spr_status[rd_old]._is_valid);
		LABEL("   * status[%d]._counter  : %d",rd_old,spr_status[rd_old]._counter );
		LABEL(" * reg_rd_new       : %d",rd_new  );
		LABEL("   * status[%d]._is_free  : %d",rd_new,spr_status[rd_new]._is_free );
		LABEL("   * status[%d]._is_link  : %d",rd_new,spr_status[rd_new]._is_link );
		LABEL("   * status[%d]._is_valid : %d",rd_new,spr_status[rd_new]._is_valid);
		LABEL("   * status[%d]._counter  : %d",rd_new,spr_status[rd_new]._counter );
		LABEL(" * read_re          : %d",write_re);
		LABEL(" * restore_re_old   : %d",restore_re_old);
		LABEL(" * reg_re_old       : %d",re_old  );
		LABEL("   * status[%d]._is_free  : %d",re_old,spr_status[re_old]._is_free );
		LABEL("   * status[%d]._is_link  : %d",re_old,spr_status[re_old]._is_link );
		LABEL("   * status[%d]._is_valid : %d",re_old,spr_status[re_old]._is_valid);
		LABEL("   * status[%d]._counter  : %d",re_old,spr_status[re_old]._counter );
		LABEL(" * reg_re_new       : %d",re_new  );
		LABEL("   * status[%d]._is_free  : %d",re_new,spr_status[re_new]._is_free );
		LABEL("   * status[%d]._is_link  : %d",re_new,spr_status[re_new]._is_link );
		LABEL("   * status[%d]._is_valid : %d",re_new,spr_status[re_new]._is_valid);
		LABEL("   * status[%d]._counter  : %d",re_new,spr_status[re_new]._counter );

		if (read_ra)
		  {
		    gpr_status[ra]._counter --;
		  }
		if (read_rb)
		  {
		    gpr_status[rb]._counter --;
		  }
		if (read_rc)
		  {
		    spr_status[rc]._counter --;
		  }
		if (write_rd)
		  {
                    if (restore_rd_old)
                      {
                        gpr_status[rd_old]._is_link  = 1;
                        gpr_status[rd_new]._is_link  = 0;
                        gpr_status[rd_new]._is_valid = 1;
                      }
                    else
                      {
                        gpr_status[rd_old]._is_link  = 0;
                        gpr_status[rd_new]._is_valid = 1;
                      }
		  }
		if (write_re)
		  {
                    if (restore_re_old)
                      {
                        spr_status[re_old]._is_link  = 1;
                        spr_status[re_new]._is_link  = 0;
                        spr_status[re_new]._is_valid = 1;
                      }
                    else
                      {
                        spr_status[re_old]._is_link  = 0;
                        spr_status[re_new]._is_valid = 1;
                      }
                  }
	      }


	  for (uint32_t i=0; i<_param->_nb_reg_free; i++)
	    {
	      if (out_PUSH_GPR_VAL [i]->read() and in_PUSH_GPR_ACK [i]->read())
		{
		  Tgeneral_address_t reg = out_PUSH_GPR_NUM_REG [i]->read();
	
		  LABEL("PUSH_GPR [%d] - Accepted",i);
		  LABEL(" * reg              : %d",reg);
		  LABEL("   * status[%d]._is_free  : %d",reg,spr_status[reg]._is_free );
		  LABEL("   * status[%d]._is_link  : %d",reg,spr_status[reg]._is_link );
		  LABEL("   * status[%d]._is_valid : %d",reg,spr_status[reg]._is_valid);
		  LABEL("   * status[%d]._counter  : %d",reg,spr_status[reg]._counter );

		  TEST(bool, true,((gpr_status[reg]._is_free  == 0) and
				   (gpr_status[reg]._is_link  == 0) and
				   (gpr_status[reg]._is_valid == 1) and
				   (gpr_status[reg]._counter  == 0)));

		  gpr_status[reg]._is_free = 1;
		  free_list_gpr.push_back(reg);
		}

	      if (out_PUSH_SPR_VAL [i]->read() and in_PUSH_SPR_ACK [i]->read())
		{
		  Tspecial_address_t reg = out_PUSH_SPR_NUM_REG [i]->read();

		  LABEL("PUSH_SPR [%d] - Accepted",i);
		  LABEL(" * reg              : %d",reg);
		  LABEL("   * status[%d]._is_free  : %d",reg,spr_status[reg]._is_free );
		  LABEL("   * status[%d]._is_link  : %d",reg,spr_status[reg]._is_link );
		  LABEL("   * status[%d]._is_valid : %d",reg,spr_status[reg]._is_valid);
		  LABEL("   * status[%d]._counter  : %d",reg,spr_status[reg]._counter );

		  TEST(bool, true,((spr_status[reg]._is_free  == 0) and
				   (spr_status[reg]._is_link  == 0) and
				   (spr_status[reg]._is_valid == 1) and
				   (spr_status[reg]._counter  == 0)));

		  spr_status[reg]._is_free = 1;
		  free_list_spr.push_back(reg);
		}
	    }
	  
	  SC_START(1);
	  nb_cycle --;
	}
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  delete []  in_INSERT_VAL               ;
  delete [] out_INSERT_ACK               ;
  delete []  in_INSERT_READ_RA           ;
  delete []  in_INSERT_NUM_REG_RA_PHY    ;
  delete []  in_INSERT_READ_RB           ;
  delete []  in_INSERT_NUM_REG_RB_PHY    ;
  delete []  in_INSERT_READ_RC           ;
  delete []  in_INSERT_NUM_REG_RC_PHY    ;
  delete []  in_INSERT_WRITE_RD          ;
  delete []  in_INSERT_NUM_REG_RD_PHY_NEW;
  delete []  in_INSERT_WRITE_RE          ;
  delete []  in_INSERT_NUM_REG_RE_PHY_NEW;
  delete []  in_RETIRE_VAL               ;
  delete [] out_RETIRE_ACK               ;
  delete []  in_RETIRE_READ_RA           ;
  delete []  in_RETIRE_NUM_REG_RA_PHY    ;
  delete []  in_RETIRE_READ_RB           ;
  delete []  in_RETIRE_NUM_REG_RB_PHY    ;
  delete []  in_RETIRE_READ_RC           ;
  delete []  in_RETIRE_NUM_REG_RC_PHY    ;
  delete []  in_RETIRE_WRITE_RD          ;
  delete []  in_RETIRE_RESTORE_RD_PHY_OLD;
  delete []  in_RETIRE_NUM_REG_RD_PHY_OLD;
  delete []  in_RETIRE_NUM_REG_RD_PHY_NEW;
  delete []  in_RETIRE_WRITE_RE          ;
  delete []  in_RETIRE_RESTORE_RE_PHY_OLD;
  delete []  in_RETIRE_NUM_REG_RE_PHY_OLD;
  delete []  in_RETIRE_NUM_REG_RE_PHY_NEW;
  delete [] out_PUSH_GPR_VAL             ;
  delete []  in_PUSH_GPR_ACK             ;
  delete [] out_PUSH_GPR_NUM_REG         ;
  delete [] out_PUSH_SPR_VAL             ;
  delete []  in_PUSH_SPR_ACK             ;
  delete [] out_PUSH_SPR_NUM_REG         ;

#endif

  delete _Stat_List_unit;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
