/*
 * $Id: test.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Rename_unit_Glue/SelfTest/include/test.h"
#include "Behavioural/include/Allocation.h"

void test (string name,
	   morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::rename_unit_glue::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,CYCLE_MAX);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Rename_unit_Glue * _Rename_unit_Glue = new Rename_unit_Glue 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  if (usage_is_set(_usage,USE_SYSTEMC))
    {
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");
  
//ALLOC1_SC_SIGNAL(out_INSERT_VAL                                     ,"out_INSERT_VAL                                    ",Tcontrol_t        ,_param->_nb_inst_insert);
//ALLOC1_SC_SIGNAL( in_INSERT_ACK                                     ," in_INSERT_ACK                                    ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_FRONT_END_ID                            ,"out_INSERT_FRONT_END_ID                           ",Tcontext_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_CONTEXT_ID                              ,"out_INSERT_CONTEXT_ID                             ",Tcontext_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_TYPE                                    ,"out_INSERT_TYPE                                   ",Ttype_t           ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_OPERATION                               ,"out_INSERT_OPERATION                              ",Toperation_t      ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_IMMEDIAT                                ,"out_INSERT_IMMEDIAT                               ",Tgeneral_data_t   ,_param->_nb_inst_insert);
//   ALLOC1_SC_SIGNAL(out_INSERT_EXCEPTION_USE                           ,"out_INSERT_EXCEPTION_USE                          ",Texception_t      ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_EXCEPTION                               ,"out_INSERT_EXCEPTION                              ",Texception_t      ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_NUM_REG_RE_PHY_NEW                      ,"out_INSERT_NUM_REG_RE_PHY_NEW                     ",Tspecial_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_RENAME_SELECT_VAL                       ," in_INSERT_RENAME_SELECT_VAL                      ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_RENAME_SELECT_ACK                       ,"out_INSERT_RENAME_SELECT_ACK                      ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_RENAME_SELECT_FRONT_END_ID              ," in_INSERT_RENAME_SELECT_FRONT_END_ID             ",Tcontext_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_RENAME_SELECT_CONTEXT_ID                ," in_INSERT_RENAME_SELECT_CONTEXT_ID               ",Tcontext_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_RENAME_SELECT_TYPE                      ," in_INSERT_RENAME_SELECT_TYPE                     ",Ttype_t           ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_RENAME_SELECT_OPERATION                 ," in_INSERT_RENAME_SELECT_OPERATION                ",Toperation_t      ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_RENAME_SELECT_IMMEDIAT                  ," in_INSERT_RENAME_SELECT_IMMEDIAT                 ",Tgeneral_data_t   ,_param->_nb_inst_insert);
//   ALLOC1_SC_SIGNAL( in_INSERT_RENAME_SELECT_EXCEPTION_USE             ," in_INSERT_RENAME_SELECT_EXCEPTION_USE            ",Texception_t      ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_RENAME_SELECT_EXCEPTION                 ," in_INSERT_RENAME_SELECT_EXCEPTION                ",Texception_t      ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_REGISTER_TRANSLATION_VAL                ,"out_INSERT_REGISTER_TRANSLATION_VAL               ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_REGISTER_TRANSLATION_ACK                ," in_INSERT_REGISTER_TRANSLATION_ACK               ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_REGISTER_TRANSLATION_FRONT_END_ID       ,"out_INSERT_REGISTER_TRANSLATION_FRONT_END_ID      ",Tcontext_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_REGISTER_TRANSLATION_CONTEXT_ID         ,"out_INSERT_REGISTER_TRANSLATION_CONTEXT_ID        ",Tcontext_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_REGISTER_TRANSLATION_NUM_REG_RE_PHY_NEW ," in_INSERT_REGISTER_TRANSLATION_NUM_REG_RE_PHY_NEW",Tspecial_address_t,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_LOAD_STORE_QUEUE_POINTER_VAL            ,"out_INSERT_LOAD_STORE_QUEUE_POINTER_VAL           ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_LOAD_STORE_QUEUE_POINTER_ACK            ," in_INSERT_LOAD_STORE_QUEUE_POINTER_ACK           ",Tcontrol_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_LOAD_STORE_QUEUE_POINTER_FRONT_END_ID   ,"out_INSERT_LOAD_STORE_QUEUE_POINTER_FRONT_END_ID  ",Tcontext_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_LOAD_STORE_QUEUE_POINTER_CONTEXT_ID     ,"out_INSERT_LOAD_STORE_QUEUE_POINTER_CONTEXT_ID    ",Tcontext_t        ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_LOAD_STORE_QUEUE_POINTER_TYPE           ,"out_INSERT_LOAD_STORE_QUEUE_POINTER_TYPE          ",Ttype_t           ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_LOAD_STORE_QUEUE_POINTER_OPERATION      ,"out_INSERT_LOAD_STORE_QUEUE_POINTER_OPERATION     ",Toperation_t      ,_param->_nb_inst_insert);
  ALLOC1_SC_SIGNAL( in_RETIRE_VAL                                     ," in_RETIRE_VAL                                    ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_RETIRE_ACK                                     ,"out_RETIRE_ACK                                    ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_RETIRE_LOAD_STORE_QUEUE_POINTER_VAL            ,"out_RETIRE_LOAD_STORE_QUEUE_POINTER_VAL           ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_LOAD_STORE_QUEUE_POINTER_ACK            ," in_RETIRE_LOAD_STORE_QUEUE_POINTER_ACK           ",Tcontrol_t        ,_param->_nb_inst_retire);
//ALLOC1_SC_SIGNAL(out_RETIRE_LOAD_STORE_QUEUE_POINTER_TYPE           ,"out_RETIRE_LOAD_STORE_QUEUE_POINTER_TYPE          ",Ttype_t           ,_param->_nb_inst_retire);
//ALLOC1_SC_SIGNAL(out_RETIRE_LOAD_STORE_QUEUE_POINTER_OPERATION      ,"out_RETIRE_LOAD_STORE_QUEUE_POINTER_OPERATION     ",Toperation_t      ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL(out_RETIRE_REGISTER_TRANSLATION_VAL                ,"out_RETIRE_REGISTER_TRANSLATION_VAL               ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC1_SC_SIGNAL( in_RETIRE_REGISTER_TRANSLATION_ACK                ," in_RETIRE_REGISTER_TRANSLATION_ACK               ",Tcontrol_t        ,_param->_nb_inst_retire);
  ALLOC2_SC_SIGNAL( in_SPR_READ_SR                                    ," in_SPR_READ_SR                                   ",Tspr_t            ,_param->_nb_front_end,_param->_nb_context[it1]);

  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Rename_unit_Glue.\n"),name.c_str());

  (*(_Rename_unit_Glue->in_CLOCK))        (*(in_CLOCK));
  (*(_Rename_unit_Glue->in_NRESET))       (*(in_NRESET));

//INSTANCE1_SC_SIGNAL(_Rename_unit_Glue,out_INSERT_VAL                                    ,_param->_nb_inst_insert);
//INSTANCE1_SC_SIGNAL(_Rename_unit_Glue, in_INSERT_ACK                                    ,_param->_nb_inst_insert);
  if (_param->_have_port_front_end_id)							  
  INSTANCE1_SC_SIGNAL(_Rename_unit_Glue,out_INSERT_FRONT_END_ID                           ,_param->_nb_inst_insert);
  if (_param->_have_port_context_id)							  
  INSTANCE1_SC_SIGNAL(_Rename_unit_Glue,out_INSERT_CONTEXT_ID                             ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit_Glue,out_INSERT_TYPE                                   ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit_Glue,out_INSERT_OPERATION                              ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit_Glue,out_INSERT_IMMEDIAT                               ,_param->_nb_inst_insert);
//   INSTANCE1_SC_SIGNAL(_Rename_unit_Glue,out_INSERT_EXCEPTION_USE                          ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit_Glue,out_INSERT_EXCEPTION                              ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit_Glue,out_INSERT_NUM_REG_RE_PHY_NEW                     ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit_Glue, in_INSERT_RENAME_SELECT_VAL                      ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit_Glue,out_INSERT_RENAME_SELECT_ACK                      ,_param->_nb_inst_insert);
  if (_param->_have_port_front_end_id)							  
  INSTANCE1_SC_SIGNAL(_Rename_unit_Glue, in_INSERT_RENAME_SELECT_FRONT_END_ID             ,_param->_nb_inst_insert);
  if (_param->_have_port_context_id)							  
  INSTANCE1_SC_SIGNAL(_Rename_unit_Glue, in_INSERT_RENAME_SELECT_CONTEXT_ID               ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit_Glue, in_INSERT_RENAME_SELECT_TYPE                     ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit_Glue, in_INSERT_RENAME_SELECT_OPERATION                ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit_Glue, in_INSERT_RENAME_SELECT_IMMEDIAT                 ,_param->_nb_inst_insert);
//   INSTANCE1_SC_SIGNAL(_Rename_unit_Glue, in_INSERT_RENAME_SELECT_EXCEPTION_USE            ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit_Glue, in_INSERT_RENAME_SELECT_EXCEPTION                ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit_Glue,out_INSERT_REGISTER_TRANSLATION_VAL               ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit_Glue, in_INSERT_REGISTER_TRANSLATION_ACK               ,_param->_nb_inst_insert);
  if (_param->_have_port_front_end_id)							  
  INSTANCE1_SC_SIGNAL(_Rename_unit_Glue,out_INSERT_REGISTER_TRANSLATION_FRONT_END_ID      ,_param->_nb_inst_insert);
  if (_param->_have_port_context_id)							  
  INSTANCE1_SC_SIGNAL(_Rename_unit_Glue,out_INSERT_REGISTER_TRANSLATION_CONTEXT_ID        ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit_Glue, in_INSERT_REGISTER_TRANSLATION_NUM_REG_RE_PHY_NEW,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit_Glue,out_INSERT_LOAD_STORE_QUEUE_POINTER_VAL           ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit_Glue, in_INSERT_LOAD_STORE_QUEUE_POINTER_ACK           ,_param->_nb_inst_insert);
  if (_param->_have_port_front_end_id)							  
  INSTANCE1_SC_SIGNAL(_Rename_unit_Glue,out_INSERT_LOAD_STORE_QUEUE_POINTER_FRONT_END_ID  ,_param->_nb_inst_insert);
  if (_param->_have_port_context_id)							  
  INSTANCE1_SC_SIGNAL(_Rename_unit_Glue,out_INSERT_LOAD_STORE_QUEUE_POINTER_CONTEXT_ID    ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit_Glue,out_INSERT_LOAD_STORE_QUEUE_POINTER_TYPE          ,_param->_nb_inst_insert);
  INSTANCE1_SC_SIGNAL(_Rename_unit_Glue,out_INSERT_LOAD_STORE_QUEUE_POINTER_OPERATION     ,_param->_nb_inst_insert);
											  
  INSTANCE1_SC_SIGNAL(_Rename_unit_Glue, in_RETIRE_VAL                                    ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Rename_unit_Glue,out_RETIRE_ACK                                    ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Rename_unit_Glue,out_RETIRE_LOAD_STORE_QUEUE_POINTER_VAL           ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Rename_unit_Glue, in_RETIRE_LOAD_STORE_QUEUE_POINTER_ACK           ,_param->_nb_inst_retire);
//INSTANCE1_SC_SIGNAL(_Rename_unit_Glue,out_RETIRE_LOAD_STORE_QUEUE_POINTER_TYPE          ,_param->_nb_inst_retire);
//INSTANCE1_SC_SIGNAL(_Rename_unit_Glue,out_RETIRE_LOAD_STORE_QUEUE_POINTER_OPERATION     ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Rename_unit_Glue,out_RETIRE_REGISTER_TRANSLATION_VAL               ,_param->_nb_inst_retire);
  INSTANCE1_SC_SIGNAL(_Rename_unit_Glue, in_RETIRE_REGISTER_TRANSLATION_ACK               ,_param->_nb_inst_retire);
											  
  INSTANCE2_SC_SIGNAL(_Rename_unit_Glue, in_SPR_READ_SR                                   ,_param->_nb_front_end,_param->_nb_context[it1]);

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      SC_START(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

//DELETE1_SC_SIGNAL(out_INSERT_VAL                                    ,_param->_nb_inst_insert);
//DELETE1_SC_SIGNAL( in_INSERT_ACK                                    ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_FRONT_END_ID                           ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_CONTEXT_ID                             ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_TYPE                                   ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_OPERATION                              ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_IMMEDIAT                               ,_param->_nb_inst_insert);
//   DELETE1_SC_SIGNAL(out_INSERT_EXCEPTION_USE                          ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_EXCEPTION                              ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_NUM_REG_RE_PHY_NEW                     ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL( in_INSERT_RENAME_SELECT_VAL                      ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_RENAME_SELECT_ACK                      ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL( in_INSERT_RENAME_SELECT_FRONT_END_ID             ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL( in_INSERT_RENAME_SELECT_CONTEXT_ID               ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL( in_INSERT_RENAME_SELECT_TYPE                     ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL( in_INSERT_RENAME_SELECT_OPERATION                ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL( in_INSERT_RENAME_SELECT_IMMEDIAT                 ,_param->_nb_inst_insert);
//   DELETE1_SC_SIGNAL( in_INSERT_RENAME_SELECT_EXCEPTION_USE            ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL( in_INSERT_RENAME_SELECT_EXCEPTION                ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_REGISTER_TRANSLATION_VAL               ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL( in_INSERT_REGISTER_TRANSLATION_ACK               ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_REGISTER_TRANSLATION_FRONT_END_ID      ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_REGISTER_TRANSLATION_CONTEXT_ID        ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL( in_INSERT_REGISTER_TRANSLATION_NUM_REG_RE_PHY_NEW,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_LOAD_STORE_QUEUE_POINTER_VAL           ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL( in_INSERT_LOAD_STORE_QUEUE_POINTER_ACK           ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_LOAD_STORE_QUEUE_POINTER_FRONT_END_ID  ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_LOAD_STORE_QUEUE_POINTER_CONTEXT_ID    ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_LOAD_STORE_QUEUE_POINTER_TYPE          ,_param->_nb_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_LOAD_STORE_QUEUE_POINTER_OPERATION     ,_param->_nb_inst_insert);
								      
  DELETE1_SC_SIGNAL( in_RETIRE_VAL                                    ,_param->_nb_inst_retire);
  DELETE1_SC_SIGNAL(out_RETIRE_ACK                                    ,_param->_nb_inst_retire);
  DELETE1_SC_SIGNAL(out_RETIRE_LOAD_STORE_QUEUE_POINTER_VAL           ,_param->_nb_inst_retire);
  DELETE1_SC_SIGNAL( in_RETIRE_LOAD_STORE_QUEUE_POINTER_ACK           ,_param->_nb_inst_retire);
//DELETE1_SC_SIGNAL(out_RETIRE_LOAD_STORE_QUEUE_POINTER_TYPE          ,_param->_nb_inst_retire);
//DELETE1_SC_SIGNAL(out_RETIRE_LOAD_STORE_QUEUE_POINTER_OPERATION     ,_param->_nb_inst_retire);
  DELETE1_SC_SIGNAL(out_RETIRE_REGISTER_TRANSLATION_VAL               ,_param->_nb_inst_retire);
  DELETE1_SC_SIGNAL( in_RETIRE_REGISTER_TRANSLATION_ACK               ,_param->_nb_inst_retire);
								      
  DELETE2_SC_SIGNAL( in_SPR_READ_SR                                   ,_param->_nb_front_end,_param->_nb_context[it1]);
    }
#endif

  delete _Rename_unit_Glue;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
