/*
 * $Id: Shifter.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Shifter/include/Shifter.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace shifter {


#undef  FUNCTION
#define FUNCTION "Shifter::Shifter"
  Shifter::Shifter (
#ifdef SYSTEMC
		    sc_module_name name
#else
		    std::string name
#endif
#ifdef STATISTICS
		    ,morpheo::behavioural::Parameters_Statistics * param_statistics
#endif
		    ,morpheo::behavioural::generic::shifter::Parameters *param
		    ,morpheo::behavioural::Tusage_t                usage ):
    _name   (name)
    ,_param (param)
    ,_usage (usage)
  {

#if DEBUG_Shifter == true
    log_printf(INFO,Shifter,FUNCTION,_("<%s> Parameters"),_name.c_str());

    std::cout << *param << std::endl;
#endif    

    allocation ();

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
        // Allocation of statistics
        statistics_declaration(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
        // generate the vhdl
        vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
#if (defined(STATISTICS) || defined (VHDL_TESTBENCH))
    SC_METHOD (transition);
    dont_initialize ();
    sensitive << (*(in_CLOCK)).pos();
#endif

    SC_METHOD (genMealy_shift);
    dont_initialize ();
    sensitive << (*(in_CLOCK)).neg();
    for (uint32_t i=0; i<param->_nb_port; i++)
      {
	sensitive << (*(in_SHIFTER_DATA      [i]));
	if (param->_shift_value == 0)
	sensitive << (*(in_SHIFTER_SHIFT     [i]));
	if (param->_direction   == external_direction)
	sensitive << (*(in_SHIFTER_DIRECTION [i]));
	if (_param->_rotate     == external_rotate)
	sensitive << (*(in_SHIFTER_TYPE      [i]));
	if (param->_carry       == external_carry)
	sensitive << (*(in_SHIFTER_CARRY     [i]));
	if (param->_carry       == external_completion)
	  if (_param->_type_completion_bool == true)
	    sensitive << (*(in_SHIFTER_CARRY_IN  [i]));
	  else
	    sensitive << (*(in_SHIFTER_COMPLETION[i]));
      }

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
    for (uint32_t i=0; i<param->_nb_port; i++)
      {
	(*(out_SHIFTER_DATA [i])) (*(in_SHIFTER_DATA      [i]));
	if (param->_shift_value == 0)
	(*(out_SHIFTER_DATA [i])) (*(in_SHIFTER_SHIFT     [i]));
	if (param->_direction   == external_direction)
	(*(out_SHIFTER_DATA [i])) (*(in_SHIFTER_DIRECTION [i]));
	if (_param->_rotate     == external_rotate)
	(*(out_SHIFTER_DATA [i])) (*(in_SHIFTER_TYPE      [i]));
	if (param->_carry       == external_carry)
	(*(out_SHIFTER_DATA [i])) (*(in_SHIFTER_CARRY     [i]));
	if (param->_carry       == external_completion)
	if (_param->_type_completion_bool == true)
	(*(out_SHIFTER_DATA [i])) (*(in_SHIFTER_CARRY_IN  [i]));
	else
	(*(out_SHIFTER_DATA [i])) (*(in_SHIFTER_COMPLETION[i]));
      }
#endif    
      }
#endif
  };
  
#undef  FUNCTION
#define FUNCTION "Shifter::~Shifter"
  Shifter::~Shifter (void)
  {
#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      delete _stat;
#endif

    deallocation ();
  };

}; // end namespace shifter
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
