#ifndef _REFERENCE_COUNTER_
#define _REFERENCE_COUNTER_

namespace morpheo {
	namespace ReferenceCountersUtils {
	
	//**********************************Class Declaration********************************************//
	
	template< typename reference_counter_type> class IReferenceCounter {
	public:
		virtual inline ~IReferenceCounter(void) = 0;
		
		virtual reference_counter_type attach(void) = 0; 
		virtual reference_counter_type detach(void) = 0; 
	};

	//**********************************Inline implementation*****************************************//
	
	template < typename reference_counter_type> 
	IReferenceCounter<reference_counter_type>::~IReferenceCounter(void) {}

	} // end of ReferenceCountersUtils namespace.
} // end of morpheo namespace.

#endif // end of _REFERENCE_COUNTER_ 	
