#ifndef _XMLLIGHT_H
#define _XMLLIGHT_H

#include <string>
#include <map>
#include "Behavioural/include/ClassicReferenceCounter.h"
#include "Behavioural/include/XMLLightVector.h"

using std::map;
using std::basic_string;
using morpheo::ReferenceCountersUtils::ClassicReferenceCounter;

namespace morpheo {
	namespace XMLUtils {
	
	//*******************************Class Declaration***************************************************//

		enum ETEXT_ENCODING {
			ASCII, 
			UTF8,
			UTF16,
			// UTF16_LE,
			// UTF16_BE,
			UTF32
		};


		// the main interface for XML parsing used a reference counter class to implement ref counting

		template< typename char_type, typename ReferenceCounter = ClassicReferenceCounter> class IXMLLight 
			: virtual public ReferenceCounter {
		protected :
			typedef IXMLLight<char_type, ReferenceCounter> XMLLight;
			typedef basic_string<char_type> string;
		public :
			// used to fetch XML Nodes contains inside a XMLLight object with the pattern name 	
			virtual XMLLightVector<XMLLight> getNodes( const string & pattern = "") = 0;
			//virtual XMLLight & getFirstNode ( const string & pattern ) = 0 ; 
			//virtual XMLLight & getRoot ( void ) = 0 ; 
			
			// fetch the name of tne node selected 
			virtual basic_string<char_type> getName ( void ) = 0 ; 
			// fetch the encoding used inside the XML document.
			//virtual ETEXT_ENCODING getEncodingForm ( void ) = 0;

			/*	
			virtual string &   getValue ( void ) = 0 ;
			virtual string & getValue ( const string & firstNodeName ) = 0 ; 
			*/
			virtual bool containsAttribute ( const basic_string<char_type> & attributeName ) = 0 ;
			
			virtual map<basic_string<char_type>, basic_string<char_type> > getAttributes ( void ) = 0 ; 

			virtual basic_string<char_type> getAttributeValue ( const basic_string<char_type> & attributeName ) = 0;
			virtual basic_string<char_type> getInternalString(void) const = 0 ; 						
			// only instanciated to bring a virtual destructor.
			virtual inline ~IXMLLight( void ) = 0 ; 
			
		};

	//*************************************Inline implementation*****************************************//	

		// implementation of XMLLight virtual destructor.
		template<typename char_type,typename ReferenceCounter> IXMLLight<char_type, ReferenceCounter>::~IXMLLight(void) {}  

	//******************************** Typedef of multiple XMLLight Interface**********************//

	// valid with 32 bits computer only . don't forget use of widen to widening string 

	typedef IXMLLight<char   , ClassicReferenceCounter> IXMLLightASCII;
	typedef IXMLLight<wchar_t, ClassicReferenceCounter> IXMLLightUTF8;
	typedef IXMLLight<wchar_t, ClassicReferenceCounter> IXMLLightUTF16;
	typedef IXMLLight<wchar_t, ClassicReferenceCounter> IXMLLightUTF32;


	} // end of XMLUtils namespace.
} // end of morpheo namespace.

#endif // _XMLLIGHT_H
