#ifdef VHDL

/*
 * $Id: Vhdl_generate_file_package.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Vhdl.h"
#include "Common/include/Environment.h"
#include <sstream>
#include <fstream>

namespace morpheo              {
namespace behavioural          {

  void Vhdl::generate_file_package(void)
  {
    log_printf(FUNC,Behavioural,"generate_file_package","Begin");

    directory();

    std::string name     = _name + "_Pack";
    std::string filename = MORPHEO_VHDL + "/" + name + ".vhdl";

    msg_printf(INFORMATION,_("Generate file \"%s\"."),filename.c_str());

    std::ofstream file;
    file.open(filename.c_str(),std::ios::out | std::ios::trunc);

    file << get_package (0,filename, name, _name);

    file.close();

    log_printf(FUNC,Behavioural,"generate_file_package","End");
  };
  
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
