/*
 * $Id: XML_generate_file.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/XML.h"
#include "Common/include/ErrorMorpheo.h"
#include <fstream>

namespace morpheo              {
namespace behavioural          {

#undef  FUNCTION
#define FUNCTION "XML::generate_file"
  void XML::generate_file (std::string dirname, std::string encoding)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    header (encoding);

    std::string filename = dirname + "/" + _name + _filename_extension;

    msg_printf(INFORMATION,_("Generate file \"%s\"."),filename.c_str());

    std::ofstream file;
    file.open(filename.c_str() ,std::ios::out | std::ios::trunc);

    if (!file)
      throw ERRORMORPHEO(FUNCTION,toString(_("Error opening \"%s\" file.\n"),filename.c_str()));

    file << get_body();

    file.close();

    log_printf(FUNC,Behavioural,FUNCTION,"End");
  };

  void XML::generate_file (std::string dirname)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");
    generate_file(dirname,"UTF-8");
    log_printf(FUNC,Behavioural,FUNCTION,"End");
  };

}; // end namespace behavioural          
}; // end namespace morpheo              
