#include "func_math.h"

//-----[ Multiplication ]--------------------------------------------------

// Multiplication rapide
unsigned int mul_soft(unsigned int op1,
		      unsigned int op2)
{
  unsigned int num_bit,carry;
  unsigned int op2_aux = op2;
  unsigned int res     = 0;
  
  for(num_bit=0;num_bit<32; num_bit++)
    {
      if (op2_aux == 0)
	break;

      carry   = op2_aux & 1;
      op2_aux = op2_aux >> 1;
      
      if (carry!=0)
	res += (op1 << num_bit);
    }
  return res;
}

unsigned int mul_hard(unsigned int op1,
		      unsigned int op2)
{
  return op1*op2;
}

//-----[ Division ]--------------------------------------------------------

unsigned int div_soft( unsigned int op1,
		       unsigned int op2)
{
  unsigned res;
  
  if (op2 == 0)
    return 0;
  
  for (res = 0; op1 >= op2; res ++)
    op1 -= op2;
  
  return res;
}

unsigned int div_hard( unsigned int op1,
		       unsigned int op2)
{
//return (op1/op2);
  return div_soft(op1,op2);
}

//-----[ Modulo ]----------------------------------------------------------

unsigned int modulo( unsigned int x,
		     unsigned int base)
{
  if (base==0)
    return 0;
  
  while(x >= base)
    x -= base;
  
  return x;
}
