#include "../include/Sim2OS.h"

namespace environment {
namespace sim2os {

  void * Sim2OS::service_lseek (void)
  {
    if (have_all_arguments(3) == false)
      {
	std::cerr << "<" << name << "> Usage : off_t lseek(int fildes, off_t offset, int whence);" << std::endl;
	return NULL;
      }
    
    int    flides   = static_cast<int  >(reinterpret_cast<int64_t>(arguments[1]));
    off_t  offset   = static_cast<off_t>(reinterpret_cast<int64_t>(arguments[2]));
    int    whence   = static_cast<int  >(reinterpret_cast<int64_t>(arguments[3]));
    void * result   = (void *) lseek(flides,offset,whence);
    error           = errno;
    
    // No swap -> because no access memory
    
    std::cout << "\n\t***** service : lseek         *****"        << std::endl;
    std::cout << "\tflides    : " << (unsigned int) flides << std::endl;
    std::cout << "\toffset    : " << (unsigned int) offset << std::endl;
    std::cout << "\twhence    : " << (unsigned int) whence << std::endl;
    std::cout << "\tresult    : " << static_cast<int32_t>(reinterpret_cast<int64_t>(result)) << std::endl;
    std::cout << "\terrno     : " << (unsigned int) error  << std::endl;
    
    return      result;
  }

};
};
